/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorCollection;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.Exceptions;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.BulkOperationsTest")
public class BulkOperationsTest
extends MultipleCacheManagersTest {
    protected HotRodServer[] hotrodServers;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected ControlledTimeService timeService;

    public Object[] factory() {
        return new Object[]{new BulkOperationsTest().cacheMode(CacheMode.DIST_SYNC), new BulkOperationsTest().cacheMode(CacheMode.REPL_SYNC), new BulkOperationsTest().cacheMode(CacheMode.LOCAL)};
    }

    protected int numberOfHotRodServers() {
        return this.cacheMode.isClustered() ? 3 : 1;
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder clusterConfig() {
        return HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)(this.cacheMode.isClustered() ? BulkOperationsTest.getDefaultClusteredCacheConfig((CacheMode)this.cacheMode, (boolean)false) : new org.infinispan.configuration.cache.ConfigurationBuilder()));
    }

    protected void createCacheManagers() throws Throwable {
        int numServers = this.numberOfHotRodServers();
        this.hotrodServers = new HotRodServer[numServers];
        this.createCluster(HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.clusterConfig()), this.numberOfHotRodServers());
        this.timeService = new ControlledTimeService();
        for (int i = 0; i < numServers; ++i) {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.get(i);
            this.hotrodServers[i] = HotRodClientTestingUtil.startHotRodServer(cm);
            TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, (Object)this.timeService, (boolean)true);
        }
        String servers = HotRodClientTestingUtil.getServersString(this.hotrodServers);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServers(servers);
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    @AfterMethod
    public void checkNoActiveIterations() {
        for (HotRodServer hotRodServer : this.hotrodServers) {
            AssertJUnit.assertEquals((int)0, (int)hotRodServer.getIterationManager().activeIterations());
        }
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServers);
    }

    protected void populateCacheManager() {
        for (int i = 0; i < 100; ++i) {
            this.remoteCache.put((Object)i, (Object)i);
        }
    }

    @DataProvider(name="collections-item")
    public Object[][] collectionItemProvider() {
        return new Object[][]{{CollectionOp.KEYSET, ItemTransform.IDENTITY}, {CollectionOp.VALUES, ItemTransform.IDENTITY}, {CollectionOp.ENTRYSET, ItemTransform.COPY_ENTRY}};
    }

    @Test(dataProvider="collections-item")
    public void testContains(CollectionOp op, ItemTransform transform) {
        this.populateCacheManager();
        Collection collection = (Collection)op.function.apply(this.remoteCache);
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)collection.contains(transform.function.apply(i)));
        }
        AssertJUnit.assertFalse((boolean)collection.contains(transform.function.apply(104)));
        AssertJUnit.assertFalse((boolean)collection.contains(transform.function.apply(-1)));
    }

    @Test(dataProvider="collections-item")
    public void testContainsAll(CollectionOp op, ItemTransform transform) {
        this.populateCacheManager();
        Collection collection = (Collection)op.function.apply(this.remoteCache);
        AssertJUnit.assertFalse((boolean)collection.containsAll(Arrays.asList(transform.function.apply(204), transform.function.apply(4))));
        AssertJUnit.assertTrue((boolean)collection.containsAll(Arrays.asList(transform.function.apply(4), transform.function.apply(10))));
        AssertJUnit.assertTrue((boolean)collection.containsAll(IntStream.range(0, 100).mapToObj(transform.function::apply).collect(Collectors.toList())));
    }

    @Test(dataProvider="collections-item")
    public void testRemove(CollectionOp op, ItemTransform transform) {
        this.populateCacheManager();
        Collection collection = (Collection)op.function.apply(this.remoteCache);
        collection.remove(transform.function.apply(4));
        collection.remove(transform.function.apply(23));
        collection.remove(transform.function.apply(1001));
        AssertJUnit.assertEquals((int)98, (int)collection.size());
        AssertJUnit.assertEquals((int)98, (int)this.remoteCache.size());
    }

    @Test(dataProvider="collections-item")
    public void testRemoveAll(CollectionOp op, ItemTransform transform) {
        this.populateCacheManager();
        CloseableIteratorCollection collection = (CloseableIteratorCollection)op.function.apply(this.remoteCache);
        collection.removeAll(Arrays.asList(transform.function.apply(5), transform.function.apply(10), transform.function.apply(23), transform.function.apply(18), transform.function.apply(105)));
        AssertJUnit.assertEquals((int)96, (int)collection.size());
        collection.removeAll(Arrays.asList(transform.function.apply(5), transform.function.apply(890)));
        AssertJUnit.assertEquals((int)96, (int)collection.size());
        AssertJUnit.assertEquals((int)96, (int)this.remoteCache.size());
    }

    @Test(dataProvider="collections-item")
    public void testRetainAll(CollectionOp op, ItemTransform transform) {
        this.populateCacheManager();
        Collection collection = (Collection)op.function.apply(this.remoteCache);
        collection.retainAll(Arrays.asList(transform.function.apply(1), transform.function.apply(23), transform.function.apply(102)));
        AssertJUnit.assertEquals((int)2, (int)collection.size());
        AssertJUnit.assertEquals((int)2, (int)this.remoteCache.size());
    }

    @Test(dataProvider="collections-item", expectedExceptions={UnsupportedOperationException.class})
    public void testAdd(CollectionOp op, ItemTransform transform) {
        CloseableIteratorCollection collection = (CloseableIteratorCollection)op.function.apply(this.remoteCache);
        collection.add(transform.function.apply(1));
    }

    @Test(dataProvider="collections-item", expectedExceptions={UnsupportedOperationException.class})
    public void testAddAll(CollectionOp op, ItemTransform transform) {
        CloseableIteratorCollection collection = (CloseableIteratorCollection)op.function.apply(this.remoteCache);
        collection.addAll(Arrays.asList(transform.function.apply(1), transform.function.apply(2)));
    }

    @Test(dataProvider="collections-item")
    public void testStreamAll(CollectionOp op, ItemTransform transform) {
        this.populateCacheManager();
        Collection collection = (Collection)op.function.apply(this.remoteCache);
        List strings = collection.stream().map(transform.function).map(Object::toString).collect(Collectors.toList());
        AssertJUnit.assertEquals((int)100, (int)strings.size());
        AssertJUnit.assertEquals((long)100L, (long)collection.parallelStream().count());
    }

    @Test(dataProvider="collections-item")
    public void testStreamShortCircuit(CollectionOp op, ItemTransform transform) {
        this.populateCacheManager();
        CloseableIteratorCollection collection = (CloseableIteratorCollection)op.function.apply(this.remoteCache);
        try (Stream stream = collection.stream();){
            AssertJUnit.assertEquals((boolean)false, (boolean)stream.allMatch(o -> Objects.equals(o, transform.function.apply(1))));
        }
        stream = collection.parallelStream();
        try {
            AssertJUnit.assertEquals(transform.function.apply(4), (Object)stream.filter(o -> Objects.equals(o, transform.function.apply(4))).findAny().get());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Test(dataProvider="collections-item")
    public void testForEach(CollectionOp op, ItemTransform transform) {
        this.populateCacheManager();
        Collection collection = (Collection)op.function.apply(this.remoteCache);
        ArrayList objects = new ArrayList();
        collection.forEach(objects::add);
        AssertJUnit.assertEquals((int)100, (int)objects.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)collection.contains(transform.function.apply(i)));
        }
    }

    @DataProvider(name="collections")
    public Object[][] collectionProvider() {
        return new Object[][]{{CollectionOp.ENTRYSET}, {CollectionOp.KEYSET}, {CollectionOp.VALUES}};
    }

    @Test(dataProvider="collections")
    public void testSizeWithExpiration(CollectionOp op) {
        HashMap<String, String> dataIn = new HashMap<String, String>();
        dataIn.put("aKey", "aValue");
        dataIn.put("bKey", "bValue");
        long lifespan = 5000L;
        this.remoteCache.putAll(dataIn, 5000L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertEquals((int)2, (int)((CloseableIteratorCollection)op.function.apply(this.remoteCache)).size());
        this.timeService.advance(5001L);
        AssertJUnit.assertEquals((int)0, (int)((CloseableIteratorCollection)op.function.apply(this.remoteCache)).size());
    }

    @Test(dataProvider="collections")
    public void testIteratorRemove(CollectionOp op) {
        this.populateCacheManager();
        CloseableIteratorCollection collection = (CloseableIteratorCollection)op.function.apply(this.remoteCache);
        AssertJUnit.assertEquals((int)100, (int)collection.size());
        try (CloseableIterator iter = collection.iterator();){
            AssertJUnit.assertTrue((boolean)iter.hasNext());
            AssertJUnit.assertNotNull((Object)iter.next());
            Object removed = iter.next();
            AssertJUnit.assertNotNull((Object)removed);
            iter.remove();
            AssertJUnit.assertTrue((boolean)iter.hasNext());
        }
        AssertJUnit.assertEquals((int)99, (int)collection.size());
    }

    @Test(dataProvider="collections")
    public void testClear(CollectionOp op) {
        this.populateCacheManager();
        CloseableIteratorCollection collection = (CloseableIteratorCollection)op.function.apply(this.remoteCache);
        AssertJUnit.assertEquals((int)100, (int)collection.size());
        collection.clear();
        AssertJUnit.assertEquals((int)0, (int)this.remoteCache.size());
    }

    @DataProvider(name="collectionsAndVersion")
    public Object[][] collectionAndVersionsProvider() {
        return (Object[][])Arrays.stream(CollectionOp.values()).flatMap(op -> Arrays.stream(ProtocolVersion.values()).map(v -> new Object[]{op, v})).toArray(x$0 -> new Object[x$0][]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="collectionsAndVersion")
    public void testIteration(CollectionOp op, ProtocolVersion version) throws IOException {
        block13: {
            RemoteCache cacheToUse;
            RemoteCacheManager temporaryManager;
            HashMap<String, String> dataIn = new HashMap<String, String>();
            dataIn.put("aKey", "aValue");
            dataIn.put("bKey", "bValue");
            if (version != ProtocolVersion.DEFAULT_PROTOCOL_VERSION) {
                String servers = HotRodClientTestingUtil.getServersString(this.hotrodServers);
                ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
                clientBuilder.version(version);
                clientBuilder.addServers(servers);
                temporaryManager = new RemoteCacheManager(clientBuilder.build());
                cacheToUse = temporaryManager.getCache();
            } else {
                temporaryManager = null;
                cacheToUse = this.remoteCache;
            }
            try {
                this.remoteCache.putAll(dataIn);
                CloseableIteratorCollection collection = (CloseableIteratorCollection)op.function.apply(cacheToUse);
                if (version.compareTo((Enum)op.minimumVersionForIteration()) < 0) {
                    Exceptions.expectException(UnsupportedOperationException.class, () -> {
                        CloseableIterator iter = collection.iterator();
                        if (iter != null) {
                            iter.close();
                        }
                    });
                    break block13;
                }
                try (CloseableIterator iter = collection.iterator();){
                    AssertJUnit.assertTrue((boolean)iter.hasNext());
                    AssertJUnit.assertNotNull((Object)iter.next());
                    AssertJUnit.assertTrue((boolean)iter.hasNext());
                }
            }
            finally {
                if (temporaryManager != null) {
                    temporaryManager.close();
                }
            }
        }
    }

    static enum ItemTransform {
        IDENTITY(Function.identity()),
        COPY_ENTRY(o -> new AbstractMap.SimpleEntry<Object, Object>(o, o));

        private final Function<Object, Object> function;

        private ItemTransform(Function<Object, Object> function) {
            this.function = function;
        }
    }

    static enum CollectionOp {
        ENTRYSET(RemoteCache::entrySet){

            @Override
            ProtocolVersion minimumVersionForIteration() {
                return ProtocolVersion.PROTOCOL_VERSION_23;
            }
        }
        ,
        KEYSET(RemoteCache::keySet){

            @Override
            ProtocolVersion minimumVersionForIteration() {
                return ProtocolVersion.PROTOCOL_VERSION_12;
            }
        }
        ,
        VALUES(RemoteCache::values){

            @Override
            ProtocolVersion minimumVersionForIteration() {
                return ProtocolVersion.PROTOCOL_VERSION_23;
            }
        };

        private Function<RemoteCache<?, ?>, CloseableIteratorCollection<?>> function;

        abstract ProtocolVersion minimumVersionForIteration();

        private CollectionOp(Function<RemoteCache<?, ?>, CloseableIteratorCollection<?>> function) {
            this.function = function;
        }
    }
}

