/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.admin;

import java.security.PrivilegedActionException;
import org.infinispan.client.hotrod.admin.RemoteCacheAdminTest;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.simple.SimpleServerAuthenticationProvider;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.admin.SecureRemoteCacheAdminTest")
public class SecureRemoteCacheAdminTest
extends RemoteCacheAdminTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)SecureRemoteCacheAdminTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.indexing().index(Index.ALL).autoConfig(true);
        this.createHotRodServers(2, builder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        ConfigurationBuilder builder = super.createHotRodClientConfigurationBuilder(serverPort);
        builder.marshaller((Marshaller)new ProtoStreamMarshaller());
        builder.security().authentication().enable().saslMechanism("CRAM-MD5").username("admin").password("password");
        return builder;
    }

    @Override
    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.defaultCacheName("default");
        ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        gcb.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).role("admin").permission(AuthorizationPermission.ALL);
        org.infinispan.configuration.cache.ConfigurationBuilder template = new org.infinispan.configuration.cache.ConfigurationBuilder();
        template.read(builder.build());
        template.security().authorization().role("admin");
        try {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)Security.doPrivileged(() -> {
                EmbeddedCacheManager cacheManager = this.addClusterEnabledCacheManager(gcb, builder);
                cacheManager.defineConfiguration("template", builder.build());
                return cacheManager;
            });
            HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
            serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
            SimpleServerAuthenticationProvider sap = new SimpleServerAuthenticationProvider();
            sap.addUser("admin", "realm", "password".toCharArray(), new String[]{"admin", "___schema_manager"});
            serverBuilder.authentication().enable().serverAuthenticationProvider((ServerAuthenticationProvider)sap).serverName("localhost").addAllowedMech("CRAM-MD5");
            HotRodServer server = (HotRodServer)Security.doPrivileged(() -> HotRodClientTestingUtil.startHotRodServer(cm, serverBuilder));
            this.servers.add(server);
            return server;
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }
}

