/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferFactoryImpl;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.CustomMarshallerEventIT")
public class CustomMarshallerEventIT
extends SingleHotRodServerTest {
    @Override
    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer.setMarshaller((Marshaller)new IdMarshaller());
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        builder.marshaller((Marshaller)new IdMarshaller());
        return new RemoteCacheManager(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventReceiveBasic() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        IdEventListener eventListener = new IdEventListener();
        remoteCache.addClientListener((Object)eventListener);
        try {
            remoteCache.put((Object)new Id(1), (Object)new Id(11));
            ClientCacheEntryCreatedEvent created = (ClientCacheEntryCreatedEvent)eventListener.pollEvent();
            AssertJUnit.assertEquals((Object)new Id(1), (Object)created.getKey());
            remoteCache.put((Object)new Id(2), (Object)new Id(22));
            created = (ClientCacheEntryCreatedEvent)eventListener.pollEvent();
            AssertJUnit.assertEquals((Object)new Id(2), (Object)created.getKey());
            remoteCache.put((Object)new Id(1), (Object)new Id(111));
            ClientCacheEntryModifiedEvent modified = (ClientCacheEntryModifiedEvent)eventListener.pollEvent();
            AssertJUnit.assertEquals((Object)new Id(1), (Object)modified.getKey());
            remoteCache.remove((Object)new Id(1));
            ClientCacheEntryRemovedEvent removed = (ClientCacheEntryRemovedEvent)eventListener.pollEvent();
            AssertJUnit.assertEquals((Object)new Id(1), (Object)removed.getKey());
            remoteCache.remove((Object)new Id(2));
            removed = (ClientCacheEntryRemovedEvent)eventListener.pollEvent();
            AssertJUnit.assertEquals((Object)new Id(2), (Object)removed.getKey());
        }
        finally {
            remoteCache.removeClientListener((Object)eventListener);
        }
    }

    public static class Id
    implements Serializable {
        final byte id;

        public Id(int id) {
            this.id = (byte)id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id other = (Id)o;
            return this.id == other.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    public static class IdMarshaller
    extends AbstractMarshaller {
        protected ByteBuffer objectToBuffer(Object o, int estimatedSize) {
            Id obj = (Id)o;
            ByteBufferFactoryImpl factory = new ByteBufferFactoryImpl();
            return factory.newByteBuffer(new byte[]{obj.id}, 0, 1);
        }

        public Object objectFromByteBuffer(byte[] buf, int offset, int length) {
            return new Id(buf[0]);
        }

        public boolean isMarshallable(Object o) {
            return true;
        }

        public MediaType mediaType() {
            return MediaType.parse((String)"application/x-custom-id");
        }
    }

    @ClientListener
    public static class IdEventListener {
        BlockingQueue<ClientEvent> events = new ArrayBlockingQueue<ClientEvent>(128);

        @ClientCacheEntryCreated
        @ClientCacheEntryModified
        @ClientCacheEntryRemoved
        public void handleCreatedEvent(ClientEvent e) {
            this.events.add(e);
        }

        public <E extends ClientEvent> E pollEvent() {
            try {
                ClientEvent event = this.events.poll(10L, TimeUnit.SECONDS);
                AssertJUnit.assertNotNull((Object)event);
                return (E)event;
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

