/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.net.SocketAddress;
import org.infinispan.AdvancedCache;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;

public abstract class AbstractRetryTest
extends HitsAwareCacheManagersTest {
    protected HotRodServer hotRodServer1;
    protected HotRodServer hotRodServer2;
    protected HotRodServer hotRodServer3;
    RemoteCacheImpl<Object, Object> remoteCache;
    protected RemoteCacheManager remoteCacheManager;
    protected ChannelFactory channelFactory;
    protected org.infinispan.configuration.cache.ConfigurationBuilder config;
    protected RoundRobinBalancingStrategy strategy;

    public AbstractRetryTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void createCacheManagers() throws Throwable {
        this.config = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.getCacheConfig());
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)this.config);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)this.config);
        EmbeddedCacheManager cm3 = TestCacheManagerFactory.createClusteredCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)this.config);
        this.registerCacheManager(new CacheContainer[]{cm1});
        this.registerCacheManager(new CacheContainer[]{cm2});
        this.registerCacheManager(new CacheContainer[]{cm3});
        this.hotRodServer1 = this.createStartHotRodServer(this.manager(0));
        this.addr2hrServer.put(this.getAddress(this.hotRodServer1), this.hotRodServer1);
        this.hotRodServer2 = this.createStartHotRodServer(this.manager(1));
        this.addr2hrServer.put(this.getAddress(this.hotRodServer2), this.hotRodServer2);
        this.hotRodServer3 = this.createStartHotRodServer(this.manager(2));
        this.addr2hrServer.put(this.getAddress(this.hotRodServer3), this.hotRodServer3);
        this.waitForClusterToForm();
        this.remoteCacheManager = this.createRemoteCacheManager(this.hotRodServer1.getPort());
        this.remoteCache = (RemoteCacheImpl)this.remoteCacheManager.getCache();
        this.channelFactory = ((InternalRemoteCacheManager)this.remoteCacheManager).getChannelFactory();
        this.strategy = (RoundRobinBalancingStrategy)HotRodClientTestingUtil.getLoadBalancer(this.remoteCacheManager);
        this.addInterceptors();
        assert (this.cacheManagers.size() == 3);
    }

    protected RemoteCacheManager createRemoteCacheManager(int port) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.forceReturnValues(true).connectionTimeout(5).connectionPool().maxActive(1).addServer().host("127.0.0.1").port(port);
        return new InternalRemoteCacheManager(builder.build());
    }

    protected HotRodServer createStartHotRodServer(EmbeddedCacheManager manager) {
        return HotRodClientTestingUtil.startHotRodServer(manager);
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        if (this.cleanupAfterMethod()) {
            HotRodClientTestingUtil.killRemoteCacheManagers(this.remoteCacheManager);
            HotRodClientTestingUtil.killServers(this.hotRodServer1, this.hotRodServer2, this.hotRodServer3);
        }
        super.clearContent();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        if (this.cleanupAfterTest()) {
            HotRodClientTestingUtil.killRemoteCacheManagers(this.remoteCacheManager);
            HotRodClientTestingUtil.killServers(this.hotRodServer1, this.hotRodServer2, this.hotRodServer3);
        }
        super.destroy();
    }

    protected abstract org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfig();

    protected AdvancedCache<?, ?> cacheToHit(Object key) {
        ConsistentHash consistentHash = this.channelFactory.getConsistentHash(RemoteCacheManager.cacheNameBytes());
        SocketAddress expectedServer = consistentHash.getServer((Object)HotRodTestingUtil.marshall((Object)key));
        return ((HotRodServer)this.addr2hrServer.get(expectedServer)).getCacheManager().getCache().getAdvancedCache();
    }
}

