/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tx;

import java.lang.reflect.Method;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.tx.util.KeyValueGenerator;
import org.infinispan.client.hotrod.tx.util.TransactionSetup;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.test.Exceptions;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.tx.TxFunctionalTest")
public class TxFunctionalTest<K, V>
extends MultiHotRodServersTest {
    private KeyValueGenerator<K, V> kvGenerator;
    private TransactionMode transactionMode;

    public TxFunctionalTest<K, V> keyValueGenerator(KeyValueGenerator<K, V> kvGenerator) {
        this.kvGenerator = kvGenerator;
        return this;
    }

    public Object[] factory() {
        return new Object[]{new TxFunctionalTest<String, String>().keyValueGenerator(KeyValueGenerator.STRING_GENERATOR).transactionMode(TransactionMode.NON_XA), new TxFunctionalTest<byte[], byte[]>().keyValueGenerator(KeyValueGenerator.BYTE_ARRAY_GENERATOR).transactionMode(TransactionMode.NON_XA), new TxFunctionalTest<Object[], Object[]>().keyValueGenerator(KeyValueGenerator.GENERIC_ARRAY_GENERATOR).transactionMode(TransactionMode.NON_XA), new TxFunctionalTest<String, String>().keyValueGenerator(KeyValueGenerator.STRING_GENERATOR).transactionMode(TransactionMode.NON_DURABLE_XA), new TxFunctionalTest<byte[], byte[]>().keyValueGenerator(KeyValueGenerator.BYTE_ARRAY_GENERATOR).transactionMode(TransactionMode.NON_DURABLE_XA), new TxFunctionalTest<Object[], Object[]>().keyValueGenerator(KeyValueGenerator.GENERIC_ARRAY_GENERATOR).transactionMode(TransactionMode.NON_DURABLE_XA), new TxFunctionalTest<String, String>().keyValueGenerator(KeyValueGenerator.STRING_GENERATOR).transactionMode(TransactionMode.FULL_XA), new TxFunctionalTest<byte[], byte[]>().keyValueGenerator(KeyValueGenerator.BYTE_ARRAY_GENERATOR).transactionMode(TransactionMode.FULL_XA), new TxFunctionalTest<Object[], Object[]>().keyValueGenerator(KeyValueGenerator.GENERIC_ARRAY_GENERATOR).transactionMode(TransactionMode.FULL_XA)};
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        HotRodClientTestingUtil.assertNoTransaction(this.clients);
        super.clearContent();
    }

    public TxFunctionalTest<K, V> transactionMode(TransactionMode transactionMode) {
        this.transactionMode = transactionMode;
        return this;
    }

    @BeforeClass(alwaysRun=true)
    public void printParameters() {
        this.log.debugf("Parameters: %s", (Object)super.parameters());
    }

    public void testSimpleTransaction(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        K k2 = this.kvGenerator.generateKey(method, 2);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        RemoteCache<K, V> remoteCache = this.remoteCache(0);
        TransactionManager tm = remoteCache.getTransactionManager();
        tm.begin();
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k1, v1));
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k2, v1));
        tm.commit();
        this.assertEntryInAllClients(k1, v1);
        this.assertEntryInAllClients(k2, v1);
        remoteCache.put(k1, v2);
        remoteCache.put(k2, v2);
        this.assertEntryInAllClients(k1, v2);
        this.assertEntryInAllClients(k2, v2);
    }

    public void testTransactionIsolation(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        K k2 = this.kvGenerator.generateKey(method, 2);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        RemoteCache<K, V> remoteCache = this.remoteCache(0);
        TransactionManager tm = remoteCache.getTransactionManager();
        tm.begin();
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k1, v1));
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k2, v1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k2));
        Transaction tx1 = tm.suspend();
        this.assertEntryInAllClients(k1, null);
        this.assertEntryInAllClients(k2, null);
        tm.begin();
        remoteCache.put(k1, v2);
        remoteCache.put(k2, v2);
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k2));
        tm.commit();
        this.assertEntryInAllClients(k1, v2);
        this.assertEntryInAllClients(k2, v2);
        tm.resume(tx1);
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k2));
        tm.commit();
        this.assertEntryInAllClients(k1, v1);
        this.assertEntryInAllClients(k2, v1);
    }

    public void testRollback(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        K k2 = this.kvGenerator.generateKey(method, 2);
        V v1 = this.kvGenerator.generateValue(method, 1);
        RemoteCache<K, V> remoteCache = this.remoteCache(0);
        TransactionManager tm = remoteCache.getTransactionManager();
        tm.begin();
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k1, v1));
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k2, v1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k2));
        tm.rollback();
        this.assertEntryInAllClients(k1, null);
        this.assertEntryInAllClients(k2, null);
    }

    public void testSetAsRollback(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        K k2 = this.kvGenerator.generateKey(method, 2);
        V v1 = this.kvGenerator.generateValue(method, 1);
        RemoteCache<K, V> remoteCache = this.remoteCache(0);
        TransactionManager tm = remoteCache.getTransactionManager();
        tm.begin();
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k1, v1));
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k2, v1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k2));
        tm.setRollbackOnly();
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        this.assertEntryInAllClients(k1, null);
        this.assertEntryInAllClients(k2, null);
    }

    public void testConflictWithUpdateNonExisting(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        K k2 = this.kvGenerator.generateKey(method, 2);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        RemoteCache<K, V> remoteCache = this.remoteCacheWithForceReturnValue();
        TransactionManager tm = remoteCache.getTransactionManager();
        tm.begin();
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k1, v1));
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k2, v1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k2));
        Transaction tx1 = tm.suspend();
        this.assertEntryInAllClients(k1, null);
        this.assertEntryInAllClients(k2, null);
        remoteCache.put(k1, v2);
        this.assertEntryInAllClients(k1, v2);
        this.assertEntryInAllClients(k2, null);
        tm.resume(tx1);
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k2));
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        this.assertEntryInAllClients(k1, v2);
        this.assertEntryInAllClients(k2, null);
    }

    public void testConflictWithTxUpdateNonExisting(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        K k2 = this.kvGenerator.generateKey(method, 2);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        RemoteCache<K, V> remoteCache = this.remoteCacheWithForceReturnValue();
        TransactionManager tm = remoteCache.getTransactionManager();
        tm.begin();
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k1, v1));
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k2, v1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k2));
        Transaction tx1 = tm.suspend();
        this.assertEntryInAllClients(k1, null);
        this.assertEntryInAllClients(k2, null);
        tm.begin();
        remoteCache.put(k1, v2);
        tm.commit();
        this.assertEntryInAllClients(k1, v2);
        this.assertEntryInAllClients(k2, null);
        tm.resume(tx1);
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v1, remoteCache.get(k2));
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        this.assertEntryInAllClients(k1, v2);
        this.assertEntryInAllClients(k2, null);
    }

    public void testConflictWithUpdate(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        K k2 = this.kvGenerator.generateKey(method, 2);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        RemoteCache<K, V> remoteCache = this.remoteCacheWithForceReturnValue();
        TransactionManager tm = remoteCache.getTransactionManager();
        remoteCache.put(k1, v1);
        tm.begin();
        this.kvGenerator.assertValueEquals(v1, remoteCache.put(k1, v2));
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k2, v2));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k2));
        Transaction tx1 = tm.suspend();
        this.assertEntryInAllClients(k1, v1);
        this.assertEntryInAllClients(k2, null);
        remoteCache.put(k1, v1);
        this.assertEntryInAllClients(k1, v1);
        this.assertEntryInAllClients(k2, null);
        tm.resume(tx1);
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k2));
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        this.assertEntryInAllClients(k1, v1);
        this.assertEntryInAllClients(k2, null);
    }

    public void testConflictWithTxUpdate(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        K k2 = this.kvGenerator.generateKey(method, 2);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        RemoteCache<K, V> remoteCache = this.remoteCacheWithForceReturnValue();
        TransactionManager tm = remoteCache.getTransactionManager();
        remoteCache.put(k1, v1);
        tm.begin();
        this.kvGenerator.assertValueEquals(v1, remoteCache.put(k1, v2));
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k2, v2));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k2));
        Transaction tx1 = tm.suspend();
        this.assertEntryInAllClients(k1, v1);
        this.assertEntryInAllClients(k2, null);
        tm.begin();
        remoteCache.put(k1, v1);
        tm.commit();
        this.assertEntryInAllClients(k1, v1);
        this.assertEntryInAllClients(k2, null);
        tm.resume(tx1);
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k2));
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        this.assertEntryInAllClients(k1, v1);
        this.assertEntryInAllClients(k2, null);
    }

    public void testConflictWithRemove(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        K k2 = this.kvGenerator.generateKey(method, 2);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        RemoteCache<K, V> remoteCache = this.remoteCacheWithForceReturnValue();
        TransactionManager tm = remoteCache.getTransactionManager();
        remoteCache.put(k1, v1);
        tm.begin();
        this.kvGenerator.assertValueEquals(v1, remoteCache.put(k1, v2));
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k2, v2));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k2));
        Transaction tx1 = tm.suspend();
        this.assertEntryInAllClients(k1, v1);
        this.assertEntryInAllClients(k2, null);
        remoteCache.remove(k1);
        this.assertEntryInAllClients(k1, null);
        this.assertEntryInAllClients(k2, null);
        tm.resume(tx1);
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k2));
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        this.assertEntryInAllClients(k1, null);
        this.assertEntryInAllClients(k2, null);
    }

    public void testConflictWithTxRemove(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        K k2 = this.kvGenerator.generateKey(method, 2);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        RemoteCache<K, V> remoteCache = this.remoteCacheWithForceReturnValue();
        TransactionManager tm = remoteCache.getTransactionManager();
        remoteCache.put(k1, v1);
        tm.begin();
        this.kvGenerator.assertValueEquals(v1, remoteCache.put(k1, v2));
        this.kvGenerator.assertValueEquals(null, remoteCache.put(k2, v2));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k2));
        Transaction tx1 = tm.suspend();
        this.assertEntryInAllClients(k1, v1);
        this.assertEntryInAllClients(k2, null);
        tm.begin();
        remoteCache.remove(k1);
        tm.commit();
        this.assertEntryInAllClients(k1, null);
        this.assertEntryInAllClients(k2, null);
        tm.resume(tx1);
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCache.get(k2));
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        this.assertEntryInAllClients(k1, null);
        this.assertEntryInAllClients(k2, null);
    }

    protected String[] parameterNames() {
        return (String[])TxFunctionalTest.concat((Object[])super.parameterNames(), (Object[])new String[]{null, null});
    }

    protected Object[] parameterValues() {
        return TxFunctionalTest.concat((Object[])super.parameterValues(), (Object[])new Object[]{this.kvGenerator.toString(), this.transactionMode});
    }

    protected String parameters() {
        return "[" + this.kvGenerator + "/" + this.transactionMode + "]";
    }

    protected String cacheName() {
        return "tx-cache";
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cacheBuilder = TxFunctionalTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        cacheBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        cacheBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        cacheBuilder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.createHotRodServers(this.numberOfNodes(), new org.infinispan.configuration.cache.ConfigurationBuilder());
        this.defineInAll(this.cacheName(), cacheBuilder);
    }

    protected final RemoteCache<K, V> remoteCache(int index) {
        return this.client(index).getCache(this.cacheName());
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        ConfigurationBuilder clientBuilder = super.createHotRodClientConfigurationBuilder(serverPort);
        clientBuilder.forceReturnValues(false);
        TransactionSetup.amendJTA(clientBuilder);
        clientBuilder.transaction().transactionMode(this.transactionMode);
        return clientBuilder;
    }

    private int numberOfNodes() {
        return 3;
    }

    private RemoteCache<K, V> remoteCacheWithForceReturnValue() {
        return this.client(0).getCache(this.cacheName(), true);
    }

    private void assertEntryInAllClients(K key, V value) {
        for (RemoteCacheManager manager : this.clients) {
            RemoteCache remoteCache = manager.getCache(this.cacheName());
            this.kvGenerator.assertValueEquals(value, remoteCache.get(key));
        }
    }
}

