/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockTest;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.exception.ClusteredLockException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.ClusteredLockTest")
public class ClusteredLockTest
extends BaseClusteredLockTest {
    protected static final String LOCK_NAME = "ClusteredLockTest";

    @BeforeMethod(alwaysRun=true)
    public void createLock() throws Throwable {
        ClusteredLockManager m1 = this.clusteredLockManager(0);
        m1.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
    }

    @AfterMethod(alwaysRun=true)
    protected void destroyLock() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        if (clusteredLockManager.isDefined(LOCK_NAME)) {
            AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.get(LOCK_NAME).isLocked())));
            FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(LOCK_NAME));
        }
    }

    @Test
    public void testLockAndUnlockVisibility() throws Throwable {
        ClusteredLockManager cm0 = this.clusteredLockManager(0);
        ClusteredLockManager cm1 = this.clusteredLockManager(1);
        ClusteredLockManager cm2 = this.clusteredLockManager(2);
        ClusteredLock lock0 = cm0.get(LOCK_NAME);
        ClusteredLock lock1 = cm1.get(LOCK_NAME);
        ClusteredLock lock2 = cm2.get(LOCK_NAME);
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLocked())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLocked())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLocked())));
        FunctionalTestUtils.await((CompletableFuture)lock0.lock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLocked())));
        FunctionalTestUtils.await((CompletableFuture)lock1.unlock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLocked())));
        FunctionalTestUtils.await((CompletableFuture)lock2.unlock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLocked())));
        FunctionalTestUtils.await((CompletableFuture)lock0.unlock());
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLocked())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLocked())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLocked())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockOwnership() throws Throwable {
        ClusteredLockManager cm0 = this.clusteredLockManager(0);
        ClusteredLockManager cm1 = this.clusteredLockManager(1);
        ClusteredLockManager cm2 = this.clusteredLockManager(2);
        ClusteredLock lock0 = cm0.get(LOCK_NAME);
        ClusteredLock lock1 = cm1.get(LOCK_NAME);
        ClusteredLock lock2 = cm2.get(LOCK_NAME);
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLockedByMe())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLockedByMe())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLockedByMe())));
        FunctionalTestUtils.await((CompletableFuture)lock1.lock());
        try {
            AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLockedByMe())));
            AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLockedByMe())));
            AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLockedByMe())));
        }
        finally {
            FunctionalTestUtils.await((CompletableFuture)lock1.unlock());
        }
    }

    @Test
    public void testLockWhenLockIsRemoved() throws Throwable {
        ClusteredLockManager cm0 = this.clusteredLockManager(0);
        ClusteredLockManager cm1 = this.clusteredLockManager(1);
        ClusteredLockManager cm2 = this.clusteredLockManager(2);
        ClusteredLock lock0 = cm0.get(LOCK_NAME);
        ClusteredLock lock1 = cm1.get(LOCK_NAME);
        ClusteredLock lock2 = cm2.get(LOCK_NAME);
        FunctionalTestUtils.await((CompletableFuture)lock0.lock());
        CompletableFuture lock1Request = lock1.lock();
        CompletableFuture lock2Request = lock2.lock();
        AssertJUnit.assertFalse((boolean)lock1Request.isDone());
        AssertJUnit.assertFalse((boolean)lock2Request.isDone());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)cm0.remove(LOCK_NAME))));
        AssertJUnit.assertNull((Object)FunctionalTestUtils.await((CompletableFuture)lock1Request.exceptionally(e -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)e);
            AssertJUnit.assertTrue((boolean)e.getMessage().contains("The lock was deleted."));
            return null;
        })));
        AssertJUnit.assertNull((Object)FunctionalTestUtils.await((CompletableFuture)lock2Request.exceptionally(e -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)e);
            AssertJUnit.assertTrue((boolean)e.getMessage().contains("The lock was deleted."));
            return null;
        })));
    }

    @Test
    public void testTryLockWithTimeoutWithCountersInParallelOnSingleLock() throws Throwable {
        AtomicInteger counter = new AtomicInteger();
        ClusteredLock lock = this.clusteredLockManager(0).get(LOCK_NAME);
        CompletionStage lockRes0 = lock.tryLock(1000L, TimeUnit.MILLISECONDS).thenAccept(r -> {
            if (r.booleanValue()) {
                counter.incrementAndGet();
                FunctionalTestUtils.await((CompletableFuture)lock.unlock());
            }
        });
        CompletionStage lockRes1 = lock.tryLock(1000L, TimeUnit.MILLISECONDS).thenAccept(r -> {
            if (r.booleanValue()) {
                counter.incrementAndGet();
                FunctionalTestUtils.await((CompletableFuture)lock.unlock());
            }
        });
        CompletionStage lockRes2 = lock.tryLock(1000L, TimeUnit.MILLISECONDS).thenAccept(r -> {
            if (r.booleanValue()) {
                counter.incrementAndGet();
                FunctionalTestUtils.await((CompletableFuture)lock.unlock());
            }
        });
        FunctionalTestUtils.await((CompletableFuture)lockRes0);
        FunctionalTestUtils.await((CompletableFuture)lockRes1);
        FunctionalTestUtils.await((CompletableFuture)lockRes2);
        AssertJUnit.assertEquals((int)3, (int)counter.get());
    }

    @Test
    public void testTryLockWithTimeoutWithCountersInParallelOnMultiLocks() throws Throwable {
        AtomicInteger counter = new AtomicInteger();
        ClusteredLock lock0 = this.clusteredLockManager(0).get(LOCK_NAME);
        ClusteredLock lock1 = this.clusteredLockManager(1).get(LOCK_NAME);
        ClusteredLock lock2 = this.clusteredLockManager(2).get(LOCK_NAME);
        CompletionStage lockRes0 = lock0.tryLock(1000L, TimeUnit.MILLISECONDS).thenAccept(r -> {
            if (r.booleanValue()) {
                counter.incrementAndGet();
                FunctionalTestUtils.await((CompletableFuture)lock0.unlock());
            }
        });
        CompletionStage lockRes1 = lock1.tryLock(1000L, TimeUnit.MILLISECONDS).thenAccept(r -> {
            if (r.booleanValue()) {
                counter.incrementAndGet();
                FunctionalTestUtils.await((CompletableFuture)lock1.unlock());
            }
        });
        CompletionStage lockRes2 = lock2.tryLock(1000L, TimeUnit.MILLISECONDS).thenAccept(r -> {
            if (r.booleanValue()) {
                counter.incrementAndGet();
                FunctionalTestUtils.await((CompletableFuture)lock2.unlock());
            }
        });
        FunctionalTestUtils.await((CompletableFuture)lockRes0);
        FunctionalTestUtils.await((CompletableFuture)lockRes1);
        FunctionalTestUtils.await((CompletableFuture)lockRes2);
        AssertJUnit.assertEquals((int)3, (int)counter.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTryLockWithCountersInParallel() throws Throwable {
        ClusteredLock lock0 = this.clusteredLockManager(0).get(LOCK_NAME);
        ClusteredLock lock1 = this.clusteredLockManager(1).get(LOCK_NAME);
        ClusteredLock lock2 = this.clusteredLockManager(2).get(LOCK_NAME);
        long successTryLocks = Stream.of(lock0, lock1, lock2).map(this::callTryLock).map(ClusteredLockTest::awaitTryLock).filter(Boolean::booleanValue).count();
        try {
            AssertJUnit.assertEquals((long)1L, (long)successTryLocks);
        }
        finally {
            FunctionalTestUtils.await((CompletableFuture)lock0.unlock());
            FunctionalTestUtils.await((CompletableFuture)lock1.unlock());
            FunctionalTestUtils.await((CompletableFuture)lock2.unlock());
        }
    }

    private Future<Boolean> callTryLock(ClusteredLock lock) {
        return this.fork(() -> (Boolean)FunctionalTestUtils.await((CompletableFuture)lock.tryLock()));
    }

    private static Boolean awaitTryLock(Future<Boolean> result) {
        try {
            return result.get();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

