/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.configuration.ClusteredLockManagerConfigurationBuilder;
import org.infinispan.lock.configuration.Reliability;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;

public abstract class BaseClusteredLockTest
extends MultipleCacheManagersTest {
    protected Reliability reliability = Reliability.CONSISTENT;
    protected int numOwner = -1;

    protected int clusterSize() {
        return 3;
    }

    protected BaseClusteredLockTest numOwner(int numOwner) {
        this.numOwner = numOwner;
        return this;
    }

    protected GlobalConfigurationBuilder configure(int nodeId) {
        GlobalConfigurationBuilder globalConfigurationBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalConfigurationBuilder.metrics().gauges(false);
        ((ClusteredLockManagerConfigurationBuilder)globalConfigurationBuilder.addModule(ClusteredLockManagerConfigurationBuilder.class)).numOwner(this.numOwner).reliability(this.reliability);
        return globalConfigurationBuilder;
    }

    protected final void createCacheManagers() throws Throwable {
        int size = this.clusterSize();
        for (int i = 0; i < size; ++i) {
            this.addClusterEnabledCacheManager(this.configure(i), null);
        }
        this.waitForClusteredLockCaches();
    }

    protected final void waitForClusteredLockCaches() {
        this.waitForClusterToForm("org.infinispan.LOCKS");
    }

    protected final ClusteredLockManager clusteredLockManager(int index) {
        return EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)this.manager(index));
    }

    protected String[] parameterNames() {
        return (String[])BaseClusteredLockTest.concat((Object[])super.parameterNames(), (Object[])new String[]{"lockOwners"});
    }

    protected Object[] parameterValues() {
        Integer numOwnerParameter = this.numOwner != 0 ? Integer.valueOf(this.numOwner) : null;
        return BaseClusteredLockTest.concat((Object[])super.parameterValues(), (Object[])new Object[]{numOwnerParameter});
    }
}

