/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.lock.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String lockDeleted = "ISPN029001: The lock was deleted.";
    private static final String unlockFailed = "ISPN029003: LOCK[%s] Unlock failed from node %s";
    private static final String missingName = "ISPN029004: Missing name for the clustered lock";
    private static final String invalidNumOwners = "ISPN029005: Invalid number of owner. It must be higher than zero or -1 but it was %s";
    private static final String invalidReliabilityMode = "ISPN029006: Invalid reliability mode. Modes are AVAILABLE or CONSISTENT";
    private static final String invalidScope = "ISPN029007: Invalid scope for tag <clustered-lock>. Expected CACHE_CONTAINER but was %s";
    private static final String requireClustered = "ISPN029008: Cannot create clustered locks when clustering is not enabled";
    private static final String configurationNotClustered = "ISPN029009: Configuration is not clustered, clustered locks are disabled";
    private static final String jmxRegistrationFailed = "ISPN029010: MBean registration failed";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String lockDeleted$str() {
        return lockDeleted;
    }

    @Override
    public final ClusteredLockException lockDeleted() {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.lockDeleted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unlockFailed$str() {
        return unlockFailed;
    }

    @Override
    public final ClusteredLockException unlockFailed(String lockName, Object originator) {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.unlockFailed$str(), lockName, originator));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingName$str() {
        return missingName;
    }

    @Override
    public final ClusteredLockException missingName() {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.missingName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNumOwners$str() {
        return invalidNumOwners;
    }

    @Override
    public final ClusteredLockException invalidNumOwners(Integer value) {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.invalidNumOwners$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidReliabilityMode$str() {
        return invalidReliabilityMode;
    }

    @Override
    public final ClusteredLockException invalidReliabilityMode() {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.invalidReliabilityMode$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidScope$str() {
        return invalidScope;
    }

    @Override
    public final ClusteredLockException invalidScope(String scope) {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.invalidScope$str(), scope));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requireClustered$str() {
        return requireClustered;
    }

    @Override
    public final ClusteredLockException requireClustered() {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.requireClustered$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void configurationNotClustered() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.configurationNotClustered$str(), new Object[0]);
    }

    protected String configurationNotClustered$str() {
        return configurationNotClustered;
    }

    protected String jmxRegistrationFailed$str() {
        return jmxRegistrationFailed;
    }

    @Override
    public final ClusteredLockException jmxRegistrationFailed(Throwable cause) {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.jmxRegistrationFailed$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

