package org.infinispan.lock.logging;

import java.util.Locale;
import java.lang.Integer;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.infinispan.lock.exception.ClusteredLockException;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-03-11T07:36:08-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String lockDeleted = "ISPN029001: The lock was deleted.";
    protected String lockDeleted$str() {
        return lockDeleted;
    }
    @Override
    public final ClusteredLockException lockDeleted() {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), lockDeleted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unlockFailed = "ISPN029003: LOCK[%s] Unlock failed from node %s";
    protected String unlockFailed$str() {
        return unlockFailed;
    }
    @Override
    public final ClusteredLockException unlockFailed(final String lockName, final Object originator) {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), unlockFailed$str(), lockName, originator));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingName = "ISPN029004: Missing name for the clustered lock";
    protected String missingName$str() {
        return missingName;
    }
    @Override
    public final ClusteredLockException missingName() {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), missingName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNumOwners = "ISPN029005: Invalid number of owner. It must be higher than zero or -1 but it was %s";
    protected String invalidNumOwners$str() {
        return invalidNumOwners;
    }
    @Override
    public final ClusteredLockException invalidNumOwners(final Integer value) {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), invalidNumOwners$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidReliabilityMode = "ISPN029006: Invalid reliability mode. Modes are AVAILABLE or CONSISTENT";
    protected String invalidReliabilityMode$str() {
        return invalidReliabilityMode;
    }
    @Override
    public final ClusteredLockException invalidReliabilityMode() {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), invalidReliabilityMode$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScope = "ISPN029007: Invalid scope for tag <clustered-lock>. Expected CACHE_CONTAINER but was %s";
    protected String invalidScope$str() {
        return invalidScope;
    }
    @Override
    public final ClusteredLockException invalidScope(final String scope) {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), invalidScope$str(), scope));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requireClustered = "ISPN029008: Cannot create clustered locks when clustering is not enabled";
    protected String requireClustered$str() {
        return requireClustered;
    }
    @Override
    public final ClusteredLockException requireClustered() {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), requireClustered$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void configurationNotClustered() {
        super.log.logf(FQCN, INFO, null, configurationNotClustered$str());
    }
    private static final String configurationNotClustered = "ISPN029009: Configuration is not clustered, clustered locks are disabled";
    protected String configurationNotClustered$str() {
        return configurationNotClustered;
    }
    private static final String jmxRegistrationFailed = "ISPN029010: MBean registration failed";
    protected String jmxRegistrationFailed$str() {
        return jmxRegistrationFailed;
    }
    @Override
    public final ClusteredLockException jmxRegistrationFailed(final Throwable cause) {
        final ClusteredLockException result = new ClusteredLockException(String.format(getLoggingLocale(), jmxRegistrationFailed$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
