/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.io.IOException;
import java.util.HashMap;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.configuration.serializer.AbstractConfigurationSerializerTest;
import org.infinispan.lock.configuration.ClusteredLockManagerConfiguration;
import org.infinispan.lock.configuration.Reliability;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="counter.ConfigurationSerializerTest")
@CleanupAfterMethod
public class ConfigurationSerializerTest
extends AbstractConfigurationSerializerTest {
    public void testParserAvailableReliability() throws IOException {
        ConfigurationBuilderHolder holder = new ParserRegistry().parseFile("configs/all/clustered-locks-dist.xml");
        TestingUtil.withCacheManager(() -> TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilderHolder)holder), cacheManager -> {
            cacheManager.getCache("org.infinispan.LOCKS");
            GlobalConfiguration globalConfiguration = cacheManager.getGlobalComponentRegistry().getGlobalConfiguration();
            ClusteredLockManagerConfiguration clmConfig = (ClusteredLockManagerConfiguration)globalConfiguration.module(ClusteredLockManagerConfiguration.class);
            AssertJUnit.assertNotNull((Object)clmConfig);
            AssertJUnit.assertEquals((int)3, (int)clmConfig.numOwners());
            AssertJUnit.assertEquals((Object)Reliability.AVAILABLE, (Object)clmConfig.reliability());
            AssertJUnit.assertTrue((boolean)clmConfig.locks().containsKey("lock1"));
            AssertJUnit.assertTrue((boolean)clmConfig.locks().containsKey("lock2"));
        });
    }

    public void testParserConsistentReliability() throws IOException {
        ConfigurationBuilderHolder holder = new ParserRegistry().parseFile("configs/all/clustered-locks-repl.xml");
        TestingUtil.withCacheManager(() -> TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilderHolder)holder), cacheManager -> {
            cacheManager.getCache("org.infinispan.LOCKS");
            GlobalConfiguration globalConfiguration = cacheManager.getGlobalComponentRegistry().getGlobalConfiguration();
            ClusteredLockManagerConfiguration clmConfig = (ClusteredLockManagerConfiguration)globalConfiguration.module(ClusteredLockManagerConfiguration.class);
            AssertJUnit.assertNotNull((Object)clmConfig);
            AssertJUnit.assertEquals((int)-1, (int)clmConfig.numOwners());
            AssertJUnit.assertEquals((Object)Reliability.CONSISTENT, (Object)clmConfig.reliability());
            HashMap clusteredLockConfig = new HashMap();
            AssertJUnit.assertTrue((boolean)clmConfig.locks().containsKey("consi-lock1"));
            AssertJUnit.assertTrue((boolean)clmConfig.locks().containsKey("consi-lock2"));
        });
    }
}

