/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockSplitBrainTest;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.ConsistentReliabilitySplitBrainTest")
public class ConsistentReliabilitySplitBrainTest
extends BaseClusteredLockSplitBrainTest {
    @Override
    protected String getLockName() {
        return "ConsistentReliabilitySplitBrainTest";
    }

    @Test
    public void testLockCreationWhenPartitionHappening() {
        ClusteredLockManager clusteredLockManager = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(this.getLockName()));
        this.splitCluster(new int[][]{{0, 1, 2}, {3, 4, 5}});
        for (EmbeddedCacheManager cm : this.getCacheManagers()) {
            ClusteredLockManager clm = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)cm);
            ConsistentReliabilitySplitBrainTest.eventually(() -> this.availabilityExceptionRaised(clm));
        }
    }

    @Test
    public void testLockUseAfterPartitionWithoutMajority() {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        ClusteredLockManager clm2 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(2)));
        ClusteredLockManager clm3 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(3)));
        ClusteredLockManager clm4 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(4)));
        ClusteredLockManager clm5 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(5)));
        clm0.defineLock(this.getLockName());
        AssertJUnit.assertTrue((boolean)clm0.isDefined(this.getLockName()));
        ClusteredLock lock0 = clm0.get(this.getLockName());
        ClusteredLock lock1 = clm1.get(this.getLockName());
        ClusteredLock lock2 = clm2.get(this.getLockName());
        ClusteredLock lock3 = clm3.get(this.getLockName());
        ClusteredLock lock4 = clm4.get(this.getLockName());
        ClusteredLock lock5 = clm5.get(this.getLockName());
        this.splitCluster(new int[][]{{0, 1, 2}, {3, 4, 5}});
        this.partition(0).assertDegradedMode();
        this.partition(1).assertDegradedMode();
        Arrays.asList(lock0, lock1, lock2, lock3, lock4, lock5).forEach(lock -> {
            AssertJUnit.assertNotNull((Object)lock);
            Exceptions.expectCompletionException(ClusteredLockException.class, AvailabilityException.class, (CompletionStage)lock.tryLock());
        });
    }

    @Test
    public void testLockUseAfterPartitionWithMajority() {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        ClusteredLockManager clm2 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(2)));
        ClusteredLockManager clm3 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(3)));
        ClusteredLockManager clm4 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(4)));
        ClusteredLockManager clm5 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(5)));
        AssertJUnit.assertTrue((boolean)clm0.defineLock(this.getLockName()));
        AssertJUnit.assertFalse((boolean)clm1.defineLock(this.getLockName()));
        AssertJUnit.assertFalse((boolean)clm2.defineLock(this.getLockName()));
        AssertJUnit.assertFalse((boolean)clm3.defineLock(this.getLockName()));
        AssertJUnit.assertFalse((boolean)clm4.defineLock(this.getLockName()));
        AssertJUnit.assertFalse((boolean)clm5.defineLock(this.getLockName()));
        ClusteredLock lock0 = clm0.get(this.getLockName());
        ClusteredLock lock1 = clm1.get(this.getLockName());
        ClusteredLock lock2 = clm2.get(this.getLockName());
        ClusteredLock lock3 = clm3.get(this.getLockName());
        ClusteredLock lock4 = clm4.get(this.getLockName());
        ClusteredLock lock5 = clm5.get(this.getLockName());
        this.splitCluster(new int[][]{{0, 1, 2, 3}, {4, 5}});
        Arrays.asList(lock0, lock1, lock2, lock3).forEach(this::assertTryLock);
        this.assertFailureFromMinorityPartition(lock4);
        this.assertFailureFromMinorityPartition(lock5);
    }

    @Test
    public void testAutoReleaseIfLockIsAcquiredFromAMinorityPartition() {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        ClusteredLockManager clm2 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(2)));
        AssertJUnit.assertTrue((boolean)clm0.defineLock(this.getLockName()));
        ClusteredLock lock0 = clm0.get(this.getLockName());
        ClusteredLock lock1 = clm1.get(this.getLockName());
        ClusteredLock lock2 = clm2.get(this.getLockName());
        FunctionalTestUtils.await((CompletableFuture)lock0.tryLock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLockedByMe())));
        this.splitCluster(new int[][]{{0}, {1, 2, 3, 4, 5}});
        CompletableFuture tryLock1Result = lock1.tryLock(1L, TimeUnit.SECONDS);
        CompletableFuture tryLock2Result = lock2.tryLock(1L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((String)"Just one of the locks has to work", (boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)tryLock1Result) ^ (Boolean)FunctionalTestUtils.await((CompletableFuture)tryLock2Result)));
        this.assertFailureFromMinorityPartition(lock0);
    }

    @Test
    public void testTryLocksBeforeSplitBrain() {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        ClusteredLockManager clm2 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(2)));
        AssertJUnit.assertTrue((boolean)clm0.defineLock(this.getLockName()));
        ClusteredLock lock0 = clm0.get(this.getLockName());
        ClusteredLock lock1 = clm1.get(this.getLockName());
        ClusteredLock lock2 = clm2.get(this.getLockName());
        CompletableFuture tryLock1 = lock1.tryLock();
        CompletableFuture tryLock2 = lock2.tryLock();
        this.splitCluster(new int[][]{{0}, {1, 2, 3, 4, 5}});
        AssertJUnit.assertTrue((String)"Just one of the locks has to work", (boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)tryLock1) ^ (Boolean)FunctionalTestUtils.await((CompletableFuture)tryLock2)));
        this.assertFailureFromMinorityPartition(lock0);
    }

    private void assertTryLock(ClusteredLock lock) {
        Boolean locked = (Boolean)FunctionalTestUtils.await((CompletableFuture)lock.tryLock(29L, TimeUnit.SECONDS));
        if (locked.booleanValue()) {
            FunctionalTestUtils.await((CompletableFuture)lock.unlock());
        }
        AssertJUnit.assertTrue((String)("Lock acquisition should be true " + lock), (boolean)locked);
    }

    private void assertFailureFromMinorityPartition(ClusteredLock lock) {
        Exceptions.expectCompletionException(ClusteredLockException.class, AvailabilityException.class, (CompletionStage)lock.tryLock());
    }
}

