/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.lock;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.lock.impl.lock.RequestExpirationScheduler;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.RequestExpirationSchedulerTest")
public class RequestExpirationSchedulerTest {
    private RequestExpirationScheduler expirationScheduler;
    private ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
    private ScheduledFuture scheduledFutureMock;
    private CompletableFuture<Boolean> booleanCompletableFuture;

    @BeforeMethod
    public void createRequestExpirationScheduler() {
        this.expirationScheduler = new RequestExpirationScheduler(this.scheduledExecutorService);
        this.scheduledFutureMock = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        this.booleanCompletableFuture = new CompletableFuture();
        Mockito.when(this.scheduledExecutorService.schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenReturn((Object)this.scheduledFutureMock);
    }

    @Test
    public void testScheduleForCompletionAndRunScheduling() throws Exception {
        ArgumentCaptor argument = ArgumentCaptor.forClass(Runnable.class);
        this.expirationScheduler.scheduleForCompletion("123", this.booleanCompletableFuture, 10L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertEquals((int)1, (int)this.expirationScheduler.countScheduledRequests());
        ((ScheduledExecutorService)Mockito.verify((Object)this.scheduledExecutorService)).schedule((Runnable)argument.capture(), ArgumentMatchers.eq((long)10L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        Runnable runnable = (Runnable)argument.getValue();
        runnable.run();
        AssertJUnit.assertTrue((boolean)this.booleanCompletableFuture.isDone());
        AssertJUnit.assertFalse((boolean)this.booleanCompletableFuture.get());
        AssertJUnit.assertEquals((int)0, (int)this.expirationScheduler.countScheduledRequests());
    }

    @Test
    public void testScheduleForCompletionAddsASingleRequestById() throws Exception {
        this.expirationScheduler.scheduleForCompletion("123", this.booleanCompletableFuture, 100L, TimeUnit.SECONDS);
        Exceptions.expectException(IllegalStateException.class, () -> this.expirationScheduler.scheduleForCompletion("123", this.booleanCompletableFuture, 50L, TimeUnit.SECONDS));
        RequestExpirationScheduler.ScheduledRequest scheduledRequest = this.expirationScheduler.get("123");
        AssertJUnit.assertEquals((Object)this.scheduledFutureMock, (Object)scheduledRequest.getScheduledFuture());
        AssertJUnit.assertEquals(this.booleanCompletableFuture, (Object)scheduledRequest.getRequest());
        AssertJUnit.assertEquals((int)1, (int)this.expirationScheduler.countScheduledRequests());
        ((ScheduledExecutorService)Mockito.verify((Object)this.scheduledExecutorService)).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.eq((long)100L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.SECONDS))));
        ((ScheduledExecutorService)Mockito.verify((Object)this.scheduledExecutorService, (VerificationMode)Mockito.never())).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.eq((long)0L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.SECONDS))));
        ((ScheduledExecutorService)Mockito.verify((Object)this.scheduledExecutorService, (VerificationMode)Mockito.never())).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.eq((long)50L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.SECONDS))));
    }

    @Test
    public void testCompletedRequestsShouldNotBeScheduled() throws Exception {
        CompletableFuture<Boolean> request = new CompletableFuture<Boolean>();
        request.complete(true);
        this.expirationScheduler.scheduleForCompletion("123", request, 10L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertEquals((int)0, (int)this.expirationScheduler.countScheduledRequests());
    }

    @Test
    public void testAbortSchedulingWithCompletedRequest() throws Exception {
        this.expirationScheduler.scheduleForCompletion("123", this.booleanCompletableFuture, 42L, TimeUnit.SECONDS);
        RequestExpirationScheduler.ScheduledRequest scheduledRequest = this.expirationScheduler.get("123");
        AssertJUnit.assertEquals((int)1, (int)this.expirationScheduler.countScheduledRequests());
        this.booleanCompletableFuture.complete(true);
        this.expirationScheduler.abortScheduling("123");
        AssertJUnit.assertTrue((boolean)this.booleanCompletableFuture.isDone());
        AssertJUnit.assertTrue((boolean)this.booleanCompletableFuture.get());
        ((ScheduledFuture)Mockito.verify((Object)this.scheduledFutureMock)).cancel(false);
        AssertJUnit.assertEquals((int)0, (int)this.expirationScheduler.countScheduledRequests());
    }

    @Test
    public void testAbortSchedulingShouldNotWorkIfRequestIsNotCompleted() throws Exception {
        this.expirationScheduler.scheduleForCompletion("123", this.booleanCompletableFuture, 42L, TimeUnit.SECONDS);
        RequestExpirationScheduler.ScheduledRequest scheduledRequest = this.expirationScheduler.get("123");
        AssertJUnit.assertEquals((int)1, (int)this.expirationScheduler.countScheduledRequests());
        this.expirationScheduler.abortScheduling("123");
        AssertJUnit.assertFalse((boolean)this.booleanCompletableFuture.isDone());
        ((ScheduledFuture)Mockito.verify((Object)this.scheduledFutureMock, (VerificationMode)Mockito.never())).cancel(false);
        AssertJUnit.assertEquals((int)1, (int)this.expirationScheduler.countScheduledRequests());
    }

    @Test
    public void testAbortSchedulingShouldWorkIfRequestIsNotCompletedAndForce() throws Exception {
        this.expirationScheduler.scheduleForCompletion("123", this.booleanCompletableFuture, 42L, TimeUnit.SECONDS);
        RequestExpirationScheduler.ScheduledRequest scheduledRequest = this.expirationScheduler.get("123");
        AssertJUnit.assertEquals((int)1, (int)this.expirationScheduler.countScheduledRequests());
        this.expirationScheduler.abortScheduling("123", true);
        AssertJUnit.assertFalse((boolean)this.booleanCompletableFuture.isDone());
        ((ScheduledFuture)Mockito.verify((Object)this.scheduledFutureMock)).cancel(false);
        AssertJUnit.assertEquals((int)0, (int)this.expirationScheduler.countScheduledRequests());
    }

    @Test
    public void testAbortSchedulingDoNothingForUnexistingRequests() throws Exception {
        this.expirationScheduler.abortScheduling("unexisting");
        AssertJUnit.assertEquals((int)0, (int)this.expirationScheduler.countScheduledRequests());
    }
}

