/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.lock.configuration.ClusteredLockConfiguration;
import org.infinispan.lock.configuration.ClusteredLockConfigurationBuilder;
import org.infinispan.lock.configuration.ClusteredLockManagerConfiguration;
import org.infinispan.lock.configuration.Reliability;
import org.infinispan.lock.logging.Log;

public class ClusteredLockManagerConfigurationBuilder
implements Builder<ClusteredLockManagerConfiguration> {
    private static final ClusteredLockManagerConfiguration DEFAULT = new ClusteredLockManagerConfigurationBuilder(null).create();
    private static final Log log = (Log)LogFactory.getLog(ClusteredLockManagerConfigurationBuilder.class, Log.class);
    private final AttributeSet attributes = ClusteredLockManagerConfiguration.attributeDefinitionSet();
    private final List<ClusteredLockConfigurationBuilder> locksConfig = new ArrayList<ClusteredLockConfigurationBuilder>();
    private final GlobalConfigurationBuilder builder;

    public ClusteredLockManagerConfigurationBuilder(GlobalConfigurationBuilder builder) {
        this.builder = builder;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public static ClusteredLockManagerConfiguration defaultConfiguration() {
        return DEFAULT;
    }

    public ClusteredLockManagerConfigurationBuilder numOwner(int numOwners) {
        this.attributes.attribute(ClusteredLockManagerConfiguration.NUM_OWNERS).set((Object)numOwners);
        return this;
    }

    public ClusteredLockManagerConfigurationBuilder reliability(Reliability reliability) {
        this.attributes.attribute(ClusteredLockManagerConfiguration.RELIABILITY).set((Object)reliability);
        return this;
    }

    public void validate() {
        this.attributes.attributes().forEach(Attribute::validate);
    }

    public ClusteredLockManagerConfiguration create() {
        HashMap<String, ClusteredLockConfiguration> clusteredLocks = new HashMap<String, ClusteredLockConfiguration>(this.locksConfig.size());
        for (ClusteredLockConfigurationBuilder builder : this.locksConfig) {
            ClusteredLockConfiguration lockConfiguration = builder.create();
            clusteredLocks.put(lockConfiguration.name(), lockConfiguration);
        }
        return new ClusteredLockManagerConfiguration(this.attributes.protect(), clusteredLocks);
    }

    public Builder<?> read(ClusteredLockManagerConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public ClusteredLockConfigurationBuilder addClusteredLock() {
        ClusteredLockConfigurationBuilder builder = new ClusteredLockConfigurationBuilder();
        this.locksConfig.add(builder);
        return builder;
    }
}

