/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockTest;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.ClusteredLockWith2NodesKillingOneTest")
public class ClusteredLockWith2NodesKillingOneTest
extends BaseClusteredLockTest {
    protected static final String LOCK_NAME = "ClusteredLockWith2NodesKillingOneTest";

    @Override
    protected int clusterSize() {
        return 2;
    }

    @BeforeClass(alwaysRun=true)
    public void createLock() throws Throwable {
        ClusteredLockManager m1 = this.clusteredLockManager(0);
        m1.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
    }

    @AfterClass(alwaysRun=true)
    protected void destroyLock() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(1);
        FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(LOCK_NAME));
    }

    @Test
    public void testLockWithAcquisitionAndKill() throws Throwable {
        ClusteredLock firstLockOwner = this.clusteredLockManager(0).get(LOCK_NAME);
        ClusteredLock secondLockOwner = this.clusteredLockManager(1).get(LOCK_NAME);
        StringBuilder value = new StringBuilder();
        FunctionalTestUtils.await((CompletableFuture)firstLockOwner.tryLock(1L, TimeUnit.SECONDS).thenAccept(r1 -> {
            if (r1.booleanValue()) {
                TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.manager(0)});
                FunctionalTestUtils.await((CompletableFuture)secondLockOwner.tryLock(1L, TimeUnit.SECONDS).thenAccept(r2 -> {
                    if (r2.booleanValue()) {
                        value.append("hello");
                    }
                }));
            } else {
                AssertJUnit.fail((String)"Lock should be acquired");
            }
        }));
        AssertJUnit.assertEquals((String)value.toString(), (String)"hello");
    }
}

