/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.test.Exceptions;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.ClusteredLockSplitBrainTest")
public class ClusteredLockSplitBrainTest
extends BasePartitionHandlingTest {
    private static final String LOCK_NAME = "ClusteredLockSplitBrainTest";

    @Test
    public void testLockCreationWhenPartitionHappening() throws Throwable {
        ClusteredLockManager clusteredLockManager = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(LOCK_NAME));
        this.splitCluster(new int[][]{{0, 1}, {2, 3}});
        this.eventuallyEquals(2, () -> this.advancedCache(0).getRpcManager().getTransport().getMembers().size());
        this.eventuallyEquals(2, () -> this.advancedCache(1).getRpcManager().getTransport().getMembers().size());
        this.eventuallyEquals(2, () -> this.advancedCache(2).getRpcManager().getTransport().getMembers().size());
        this.eventuallyEquals(2, () -> this.advancedCache(3).getRpcManager().getTransport().getMembers().size());
        for (EmbeddedCacheManager cm : this.getCacheManagers()) {
            ClusteredLockManager clm = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)cm);
            this.eventually(() -> this.availabilityExceptionRaised(clm));
        }
    }

    private boolean availabilityExceptionRaised(ClusteredLockManager clm) {
        AvailabilityException ex = null;
        try {
            clm.defineLock(LOCK_NAME);
        }
        catch (AvailabilityException a) {
            ex = a;
        }
        return ex != null;
    }

    @Test
    public void testLockUseAfterPartitionWithoutMajority() throws Throwable {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        ClusteredLockManager clm2 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(2)));
        ClusteredLockManager clm3 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(3)));
        clm0.defineLock(LOCK_NAME);
        AssertJUnit.assertTrue((boolean)clm0.isDefined(LOCK_NAME));
        ClusteredLock lock0 = clm0.get(LOCK_NAME);
        AssertJUnit.assertNotNull((Object)lock0);
        ClusteredLock lock1 = clm1.get(LOCK_NAME);
        AssertJUnit.assertNotNull((Object)lock1);
        ClusteredLock lock2 = clm2.get(LOCK_NAME);
        AssertJUnit.assertNotNull((Object)lock2);
        ClusteredLock lock3 = clm3.get(LOCK_NAME);
        AssertJUnit.assertNotNull((Object)lock3);
        this.splitCluster(new int[][]{{0, 1}, {2, 3}});
        FunctionalTestUtils.await((CompletableFuture)lock0.tryLock(5L, TimeUnit.SECONDS).exceptionally(ex -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)ex);
            Exceptions.assertException(AvailabilityException.class, (Throwable)ex.getCause());
            return null;
        }));
        FunctionalTestUtils.await((CompletableFuture)lock1.tryLock(5L, TimeUnit.SECONDS).exceptionally(ex -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)ex);
            Exceptions.assertException(AvailabilityException.class, (Throwable)ex.getCause());
            return null;
        }));
        FunctionalTestUtils.await((CompletableFuture)lock2.tryLock(5L, TimeUnit.SECONDS).exceptionally(ex -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)ex);
            Exceptions.assertException(AvailabilityException.class, (Throwable)ex.getCause());
            return null;
        }));
        FunctionalTestUtils.await((CompletableFuture)lock3.tryLock(5L, TimeUnit.SECONDS).exceptionally(ex -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)ex);
            Exceptions.assertException(AvailabilityException.class, (Throwable)ex.getCause());
            return null;
        }));
    }

    @Test
    public void testLockUseAfterWithMajorityPartition() throws Throwable {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        ClusteredLockManager clm2 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(2)));
        ClusteredLockManager clm3 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(3)));
        AssertJUnit.assertTrue((boolean)clm0.defineLock(LOCK_NAME));
        AssertJUnit.assertFalse((boolean)clm1.defineLock(LOCK_NAME));
        AssertJUnit.assertFalse((boolean)clm2.defineLock(LOCK_NAME));
        AssertJUnit.assertFalse((boolean)clm3.defineLock(LOCK_NAME));
        ClusteredLock lock0 = clm0.get(LOCK_NAME);
        ClusteredLock lock1 = clm1.get(LOCK_NAME);
        ClusteredLock lock2 = clm2.get(LOCK_NAME);
        ClusteredLock lock3 = clm3.get(LOCK_NAME);
        this.splitCluster(new int[][]{{0, 1, 2}, {3}});
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)lock0.tryLock(5L, TimeUnit.SECONDS).thenRun(() -> lock0.unlock())).exceptionally(ex -> {
            AssertJUnit.fail((String)"Should not be failing from majority partition");
            return null;
        }));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)lock1.tryLock(5L, TimeUnit.SECONDS).thenRun(() -> lock1.unlock())).exceptionally(ex -> {
            AssertJUnit.fail((String)"Should not be failing from majority partition");
            return null;
        }));
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)lock2.tryLock(5L, TimeUnit.SECONDS).thenRun(() -> lock2.unlock())).exceptionally(ex -> {
            AssertJUnit.fail((String)"Should not be failing from majority partition");
            return null;
        }));
        this.assertFailureFromMinorityPartition(lock3);
    }

    @Test
    public void testAutoReleaseIfLockIsAcquiredFromAMinorityPartition() throws Throwable {
        ClusteredLockManager clm0 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(0)));
        ClusteredLockManager clm1 = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)((EmbeddedCacheManager)this.getCacheManagers().get(1)));
        AssertJUnit.assertTrue((boolean)clm0.defineLock(LOCK_NAME));
        ClusteredLock lock0 = clm0.get(LOCK_NAME);
        ClusteredLock lock1 = clm1.get(LOCK_NAME);
        FunctionalTestUtils.await((CompletableFuture)lock0.tryLock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLockedByMe())));
        this.splitCluster(new int[][]{{0}, {1, 2, 3}});
        this.assertFailureFromMinorityPartition(lock0);
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.tryLock(1L, TimeUnit.SECONDS))));
    }

    private void assertFailureFromMinorityPartition(ClusteredLock lock3) {
        FunctionalTestUtils.await((CompletableFuture)((CompletableFuture)lock3.lock().thenRun(() -> {
            AssertJUnit.fail((String)"Should fail from minority partition");
            lock3.unlock();
        })).exceptionally(ex -> {
            Exceptions.assertException(CompletionException.class, (Throwable)ex);
            Exceptions.assertException(ClusteredLockException.class, (Throwable)ex.getCause());
            Exceptions.assertException(AvailabilityException.class, (Throwable)ex.getCause().getCause());
            return null;
        }));
    }
}

