/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockTest;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.test.Exceptions;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.ClusteredLockTest")
public class ClusteredLockTest
extends BaseClusteredLockTest {
    protected static final String LOCK_NAME = "ClusteredLockTest";

    @BeforeMethod(alwaysRun=true)
    public void createLock() throws Throwable {
        ClusteredLockManager m1 = this.clusteredLockManager(0);
        m1.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
    }

    @AfterMethod(alwaysRun=true)
    protected void destroyLock() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(LOCK_NAME));
    }

    @Test
    public void testLockAndUnlockVisibility() throws Throwable {
        ClusteredLockManager cm0 = this.clusteredLockManager(0);
        ClusteredLockManager cm1 = this.clusteredLockManager(1);
        ClusteredLockManager cm2 = this.clusteredLockManager(2);
        ClusteredLock lock0 = cm0.get(LOCK_NAME);
        ClusteredLock lock1 = cm1.get(LOCK_NAME);
        ClusteredLock lock2 = cm2.get(LOCK_NAME);
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLocked())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLocked())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLocked())));
        FunctionalTestUtils.await((CompletableFuture)lock0.lock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLocked())));
        FunctionalTestUtils.await((CompletableFuture)lock1.unlock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLocked())));
        FunctionalTestUtils.await((CompletableFuture)lock2.unlock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLocked())));
        FunctionalTestUtils.await((CompletableFuture)lock0.unlock());
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLocked())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLocked())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLocked())));
    }

    @Test
    public void testLockOwnership() throws Throwable {
        ClusteredLockManager cm0 = this.clusteredLockManager(0);
        ClusteredLockManager cm1 = this.clusteredLockManager(1);
        ClusteredLockManager cm2 = this.clusteredLockManager(2);
        ClusteredLock lock0 = cm0.get(LOCK_NAME);
        ClusteredLock lock1 = cm1.get(LOCK_NAME);
        ClusteredLock lock2 = cm2.get(LOCK_NAME);
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLockedByMe())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLockedByMe())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLockedByMe())));
        FunctionalTestUtils.await((CompletableFuture)lock1.lock());
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock0.isLockedByMe())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock1.isLockedByMe())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock2.isLockedByMe())));
    }

    @Test
    public void testLockWhenLockIsRemoved() throws Throwable {
        ClusteredLockManager cm0 = this.clusteredLockManager(0);
        ClusteredLockManager cm1 = this.clusteredLockManager(1);
        ClusteredLockManager cm2 = this.clusteredLockManager(2);
        ClusteredLock lock0 = cm0.get(LOCK_NAME);
        ClusteredLock lock1 = cm1.get(LOCK_NAME);
        ClusteredLock lock2 = cm2.get(LOCK_NAME);
        FunctionalTestUtils.await((CompletableFuture)lock0.lock());
        CompletableFuture lock1Request = lock1.lock();
        CompletableFuture lock2Request = lock2.lock();
        AssertJUnit.assertFalse((boolean)lock1Request.isDone());
        AssertJUnit.assertFalse((boolean)lock2Request.isDone());
        FunctionalTestUtils.await((CompletableFuture)cm0.remove(LOCK_NAME));
        FunctionalTestUtils.await((CompletableFuture)lock1Request.exceptionally(e -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)e);
            AssertJUnit.assertTrue((boolean)e.getMessage().contains("The lock was deleted."));
            return null;
        }));
        FunctionalTestUtils.await((CompletableFuture)lock2Request.exceptionally(e -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)e);
            AssertJUnit.assertTrue((boolean)e.getMessage().contains("The lock was deleted."));
            return null;
        }));
    }

    @Test
    public void testTryLockWithTimeoutWithCountersInParallel() throws Throwable {
        AtomicInteger counter = new AtomicInteger();
        ClusteredLock lock = this.clusteredLockManager(0).get(LOCK_NAME);
        FunctionalTestUtils.await(CompletableFuture.allOf(new CompletableFuture[]{lock.tryLock(1000L, TimeUnit.MILLISECONDS).thenAccept(r -> {
            if (r.booleanValue()) {
                counter.incrementAndGet();
                lock.unlock();
            }
        }), lock.tryLock(1000L, TimeUnit.MILLISECONDS).thenAccept(r -> {
            if (r.booleanValue()) {
                counter.incrementAndGet();
                lock.unlock();
            }
        }), lock.tryLock(1000L, TimeUnit.MILLISECONDS).thenAccept(r -> {
            if (r.booleanValue()) {
                counter.incrementAndGet();
                lock.unlock();
            }
        })}));
        AssertJUnit.assertEquals((int)3, (int)counter.get());
    }

    @Test
    public void testTryLockWithCountersInParallel() throws Throwable {
        AtomicInteger counter = new AtomicInteger();
        ClusteredLock lock = this.clusteredLockManager(0).get(LOCK_NAME);
        FunctionalTestUtils.await(CompletableFuture.allOf(new CompletableFuture[]{lock.tryLock().thenApply(result -> {
            if (result.booleanValue()) {
                new Counter(counter, 1, 100L).run();
                return lock.unlock();
            }
            return CompletableFuture.completedFuture(null);
        }), lock.tryLock().thenCompose(result -> {
            if (result.booleanValue()) {
                new Counter(counter, 1, 100L).run();
                return lock.unlock();
            }
            return CompletableFuture.completedFuture(null);
        }), lock.tryLock().thenCompose(result -> {
            if (result.booleanValue()) {
                try {
                    new Counter(counter, 1, 100L).run();
                }
                finally {
                    return lock.unlock();
                }
            }
            return CompletableFuture.completedFuture(null);
        })}));
        AssertJUnit.assertEquals((int)1, (int)counter.get());
    }

    class Counter
    implements Runnable {
        private AtomicInteger counter;
        private int delta;
        private long millis;

        Counter(AtomicInteger counter, int delta, long millis) {
            this.counter = counter;
            this.delta = delta;
            this.millis = millis;
        }

        @Override
        public void run() {
            try {
                TimeUnit.MILLISECONDS.sleep(this.millis);
            }
            catch (InterruptedException e) {
                AssertJUnit.fail((String)"There was a problem in the Counter");
            }
            this.counter.addAndGet(this.delta);
        }
    }
}

