/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.lock;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockTest;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.test.Exceptions;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.ClusteredLockImplTest")
public class ClusteredLockImplTest
extends BaseClusteredLockTest {
    protected static final String LOCK_NAME = "ClusteredLockImplTest";
    private ClusteredLockManager cm;
    private ClusteredLock lock;

    @Override
    protected int clusterSize() {
        return 2;
    }

    @BeforeClass
    public void createLockManager() throws Throwable {
        this.cm = this.clusteredLockManager(0);
    }

    @AfterClass
    public void destroyLock() throws Throwable {
        FunctionalTestUtils.await((CompletableFuture)this.cm.remove(LOCK_NAME));
    }

    @BeforeMethod
    public void createLock() {
        this.cm.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
        this.lock = this.clusteredLockManager(0).get(LOCK_NAME);
        FunctionalTestUtils.await((CompletableFuture)this.lock.unlock());
    }

    @AfterMethod
    public void releaseLock() {
        if (this.cm.isDefined(LOCK_NAME)) {
            FunctionalTestUtils.await((CompletableFuture)this.lock.unlock());
        }
    }

    public void testLock() throws Throwable {
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.isLocked())));
        FunctionalTestUtils.await((CompletableFuture)this.lock.lock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.isLocked())));
    }

    public void testTryLock() throws Throwable {
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock())));
    }

    public void testTryLockWithZeroTimeout() throws Throwable {
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock(0L, TimeUnit.HOURS))));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock(0L, TimeUnit.HOURS))));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.isLockedByMe())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.isLocked())));
    }

    public void testTryLockWithNegativeTimeout() throws Throwable {
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock(-10L, TimeUnit.HOURS))));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock(-10L, TimeUnit.HOURS))));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.isLockedByMe())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.isLocked())));
    }

    public void testFastLockWithTimeout() throws Throwable {
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock(1L, TimeUnit.NANOSECONDS))));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.isLockedByMe())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.isLocked())));
    }

    public void testTryLockWithTimeoutAfterLockWithSmallTimeout() throws Throwable {
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock())));
        CompletableFuture tryLock = this.lock.tryLock(1L, TimeUnit.NANOSECONDS);
        FunctionalTestUtils.await((CompletableFuture)this.lock.unlock());
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)tryLock)));
    }

    public void testTryLockWithTimeoutAfterLockWithBigTimeout() throws Throwable {
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock())));
        CompletableFuture tryLock = this.lock.tryLock(1L, TimeUnit.SECONDS);
        FunctionalTestUtils.await((CompletableFuture)this.lock.unlock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)tryLock)));
    }

    public void testUnlock() throws Throwable {
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock())));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock())));
        FunctionalTestUtils.await((CompletableFuture)this.lock.unlock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.tryLock())));
    }

    public void testIsLockedByMe() throws Throwable {
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.isLockedByMe())));
        FunctionalTestUtils.await((CompletableFuture)this.lock.lock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)this.lock.isLockedByMe())));
    }

    public void testLockAfterLockRemove() throws Throwable {
        FunctionalTestUtils.await((CompletableFuture)this.cm.remove(LOCK_NAME));
        CompletableFuture call = this.lock.lock();
        FunctionalTestUtils.await((CompletableFuture)call.exceptionally(e -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)e);
            return null;
        }));
        AssertJUnit.assertTrue((boolean)call.isCompletedExceptionally());
    }

    public void testTryLockAfterLockRemove() throws Throwable {
        FunctionalTestUtils.await((CompletableFuture)this.cm.remove(LOCK_NAME));
        CompletableFuture call = this.lock.tryLock();
        FunctionalTestUtils.await((CompletableFuture)call.exceptionally(e -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)e);
            return null;
        }));
        AssertJUnit.assertTrue((boolean)call.isCompletedExceptionally());
    }

    public void testTryLockWithTimeoutAfterLockRemove() throws Throwable {
        FunctionalTestUtils.await((CompletableFuture)this.cm.remove(LOCK_NAME));
        CompletableFuture call = this.lock.tryLock(100L, TimeUnit.MILLISECONDS);
        FunctionalTestUtils.await((CompletableFuture)call.exceptionally(e -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)e);
            return null;
        }));
        AssertJUnit.assertTrue((boolean)call.isCompletedExceptionally());
    }

    public void testIsLockedAfterLockRemove() throws Throwable {
        FunctionalTestUtils.await((CompletableFuture)this.cm.remove(LOCK_NAME));
        CompletableFuture call = this.lock.isLocked();
        FunctionalTestUtils.await((CompletableFuture)call.exceptionally(e -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)e);
            return null;
        }));
        AssertJUnit.assertTrue((boolean)call.isCompletedExceptionally());
    }

    public void testIsLockedByMeAfterLockRemove() throws Throwable {
        FunctionalTestUtils.await((CompletableFuture)this.cm.remove(LOCK_NAME));
        CompletableFuture call = this.lock.isLockedByMe();
        FunctionalTestUtils.await((CompletableFuture)call.exceptionally(e -> {
            Exceptions.assertException(ClusteredLockException.class, (Throwable)e);
            return null;
        }));
        AssertJUnit.assertTrue((boolean)call.isCompletedExceptionally());
    }
}

