/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl;

import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.impl.functions.IsLocked;
import org.infinispan.lock.impl.functions.LockFunction;
import org.infinispan.lock.impl.functions.UnlockFunction;
import org.infinispan.lock.impl.lock.ClusteredLockFilter;
import org.infinispan.lock.impl.manager.CacheHolder;
import org.infinispan.lock.impl.manager.EmbeddedClusteredLockManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.TransactionMode;

public class ClusteredLockModuleLifecycle
implements ModuleLifecycle {
    public static final String CLUSTERED_LOCK_CACHE_NAME = "org.infinispan.LOCKS";

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        Map externalizerMap = globalConfiguration.serialization().advancedExternalizers();
        externalizerMap.put(ClusteredLockKey.EXTERNALIZER.getId(), ClusteredLockKey.EXTERNALIZER);
        externalizerMap.put(ClusteredLockValue.EXTERNALIZER.getId(), ClusteredLockValue.EXTERNALIZER);
        externalizerMap.put(LockFunction.EXTERNALIZER.getId(), LockFunction.EXTERNALIZER);
        externalizerMap.put(UnlockFunction.EXTERNALIZER.getId(), UnlockFunction.EXTERNALIZER);
        externalizerMap.put(IsLocked.EXTERNALIZER.getId(), IsLocked.EXTERNALIZER);
        externalizerMap.put(ClusteredLockFilter.EXTERNALIZER.getId(), ClusteredLockFilter.EXTERNALIZER);
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class);
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache(CLUSTERED_LOCK_CACHE_NAME, ClusteredLockModuleLifecycle.createClusteredLockCacheConfiguration(), EnumSet.of(InternalCacheRegistry.Flag.EXCLUSIVE));
        CompletableFuture<CacheHolder> future = ClusteredLockModuleLifecycle.startCaches(cacheManager);
        ClusteredLockModuleLifecycle.registerClusteredLockManager(gcr, future);
    }

    private static Configuration createClusteredLockCacheConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(true).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return builder.build();
    }

    private static CompletableFuture<CacheHolder> startCaches(EmbeddedCacheManager cacheManager) {
        CompletableFuture<CacheHolder> future = new CompletableFuture<CacheHolder>();
        new Thread(() -> {
            try {
                Cache locksCache = cacheManager.getCache(CLUSTERED_LOCK_CACHE_NAME);
                future.complete(new CacheHolder((AdvancedCache<? extends ClusteredLockKey, ClusteredLockValue>)locksCache.getAdvancedCache()));
            }
            catch (Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }).start();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerClusteredLockManager(GlobalComponentRegistry registry, CompletableFuture<CacheHolder> future) {
        GlobalComponentRegistry globalComponentRegistry = registry;
        synchronized (globalComponentRegistry) {
            ClusteredLockManager clusteredLockManager = (ClusteredLockManager)registry.getComponent(ClusteredLockManager.class);
            if (clusteredLockManager == null || !(clusteredLockManager instanceof EmbeddedClusteredLockManager)) {
                clusteredLockManager = new EmbeddedClusteredLockManager(future);
                registry.registerComponent((Object)clusteredLockManager, ClusteredLockManager.class);
                ((CacheManagerJmxRegistration)registry.getComponent(CacheManagerJmxRegistration.class)).start();
            }
        }
    }
}

