/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.configuration.ClusteredLockManagerConfigurationBuilder;
import org.infinispan.lock.configuration.Reliability;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;

public abstract class BaseClusteredLockSplitBrainTest
extends BasePartitionHandlingTest {
    protected Reliability reliability = Reliability.CONSISTENT;
    protected int numOwner = -1;

    public BaseClusteredLockSplitBrainTest() {
        this.numMembersInCluster = 6;
        this.cacheMode = null;
    }

    protected void createCacheManagers() {
        ConfigurationBuilder dcc = this.cacheConfiguration();
        dcc.clustering().cacheMode(CacheMode.REPL_SYNC).partitionHandling().whenSplit(this.partitionHandling);
        this.createClusteredCaches(this.numMembersInCluster, dcc, new TransportFlags().withFD(true).withMerge(true));
        this.waitForClusterToForm("org.infinispan.LOCKS");
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(ConfigurationBuilder builder, TransportFlags flags) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ((ClusteredLockManagerConfigurationBuilder)gcb.addModule(ClusteredLockManagerConfigurationBuilder.class)).numOwner(this.numOwner).reliability(this.reliability);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((boolean)false, (GlobalConfigurationBuilder)gcb, (ConfigurationBuilder)builder, (TransportFlags)flags, (boolean)false);
        this.amendCacheManagerBeforeStart(cm);
        this.cacheManagers.add(cm);
        cm.start();
        return cm;
    }

    protected boolean availabilityExceptionRaised(ClusteredLockManager clm) {
        AvailabilityException ex = null;
        try {
            clm.defineLock(this.getLockName());
        }
        catch (AvailabilityException a) {
            ex = a;
        }
        return ex != null;
    }

    protected abstract String getLockName();
}

