/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.manager;

import java.util.concurrent.CompletableFuture;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockTest;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.api.OwnershipLevel;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.lock.impl.lock.ClusteredLockImpl;
import org.infinispan.test.Exceptions;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.EmbeddedClusteredLockManagerTest")
public class EmbeddedClusteredLockManagerTest
extends BaseClusteredLockTest {
    public void testDefinelock() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        AssertJUnit.assertTrue((boolean)clusteredLockManager.defineLock("lock", new ClusteredLockConfiguration()));
        AssertJUnit.assertFalse((boolean)clusteredLockManager.defineLock("lock", new ClusteredLockConfiguration()));
    }

    public void testGetWithLockDefinition() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        clusteredLockManager.defineLock("superLock", new ClusteredLockConfiguration());
        ClusteredLock lock = clusteredLockManager.get("superLock");
        AssertJUnit.assertNotNull((Object)lock);
    }

    public void testGetWithLockDefinitionFromAnotherNode() {
        ClusteredLockManager cm0 = this.clusteredLockManager(0);
        cm0.defineLock("lockFromC0", new ClusteredLockConfiguration());
        ClusteredLockImpl lock0 = (ClusteredLockImpl)cm0.get("lockFromC0");
        ClusteredLockManager cm1 = this.clusteredLockManager(1);
        ClusteredLockImpl lock1 = (ClusteredLockImpl)cm1.get("lockFromC0");
        AssertJUnit.assertNotNull((Object)lock0);
        AssertJUnit.assertNotNull((Object)lock1);
        AssertJUnit.assertEquals((String)lock0.getName(), (String)lock1.getName());
        AssertJUnit.assertEquals((Object)this.manager(0).getAddress(), (Object)lock0.getOriginator());
        AssertJUnit.assertEquals((Object)this.manager(1).getAddress(), (Object)lock1.getOriginator());
    }

    public void testGetWithoutLockDefinition() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        Exceptions.expectException(ClusteredLockException.class, () -> clusteredLockManager.get("notDefined"));
    }

    public void testGetConfigurationWithLockDefinition() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        clusteredLockManager.defineLock("superLock", new ClusteredLockConfiguration());
        ClusteredLockConfiguration configuration = clusteredLockManager.getConfiguration("superLock");
        AssertJUnit.assertEquals((Object)OwnershipLevel.NODE, (Object)configuration.getOwnershipLevel());
        AssertJUnit.assertFalse((boolean)configuration.isReentrant());
    }

    public void testGetConfigurationWithoutLockDefinition() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        Exceptions.expectException(ClusteredLockException.class, () -> clusteredLockManager.getConfiguration("notDefined"));
    }

    public void testIsDefined() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        AssertJUnit.assertFalse((boolean)clusteredLockManager.isDefined("notDefined"));
        clusteredLockManager.defineLock("defineLock", new ClusteredLockConfiguration());
        AssertJUnit.assertTrue((boolean)clusteredLockManager.isDefined("defineLock"));
    }

    public void testForceRelease() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        clusteredLockManager.defineLock("defineLock", new ClusteredLockConfiguration());
        ClusteredLock lock = clusteredLockManager.get("defineLock");
        FunctionalTestUtils.await((CompletableFuture)lock.lock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.forceRelease("defineLock"))));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock.isLocked())));
    }

    public void testForceReleaseUndefinedLock() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.forceRelease("notDefined"))));
    }
}

