/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.EmbeddedHotRodBulkTest")
public class EmbeddedHotRodBulkTest
extends AbstractInfinispanTest {
    CompatibilityCacheFactory<Integer, Integer> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new CompatibilityCacheFactory(CacheMode.LOCAL).setup();
    }

    @AfterClass
    protected void teardown() {
        CompatibilityCacheFactory.killCacheFactories(this.cacheFactory);
    }

    private void populateCacheManager(BasicCache cache) {
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)i);
        }
    }

    public void testEmbeddedPutHotRodGetBulk() {
        Cache<Integer, Integer> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, Integer> remote = this.cacheFactory.getHotRodCache();
        this.populateCacheManager((BasicCache)embedded);
        Map get = remote.getBulk();
        AssertJUnit.assertEquals((int)100, (int)get.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)get.containsValue(i));
            AssertJUnit.assertTrue((boolean)get.containsKey(i));
        }
    }

    public void testEmbeddedPutHotRodGetBulkWithSize() {
        Cache<Integer, Integer> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, Integer> remote = this.cacheFactory.getHotRodCache();
        this.populateCacheManager((BasicCache)embedded);
        Map get = remote.getBulk(50);
        AssertJUnit.assertEquals((int)50, (int)get.size());
    }

    public void testEmbeddedPutHotRodKeySet() {
        Cache<Integer, Integer> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, Integer> remote = this.cacheFactory.getHotRodCache();
        this.populateCacheManager((BasicCache)embedded);
        Set keySet = remote.keySet();
        AssertJUnit.assertEquals((int)100, (int)keySet.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)keySet.contains(i));
        }
    }

    public void testHotRodPutEmbeddedKeySet() {
        Cache<Integer, Integer> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, Integer> remote = this.cacheFactory.getHotRodCache();
        this.populateCacheManager((BasicCache)remote);
        CacheSet keySet = embedded.keySet();
        AssertJUnit.assertEquals((int)100, (int)keySet.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)keySet.contains(i));
        }
    }
}

