/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.infinispan.it.compatibility.TestCacheListener;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.EmbeddedHotRodCacheListenerTest")
public class EmbeddedHotRodCacheListenerTest
extends AbstractInfinispanTest {
    CompatibilityCacheFactory<String, String> cacheFactory;

    @BeforeMethod
    protected void setup() throws Exception {
        this.cacheFactory = new CompatibilityCacheFactory(CacheMode.LOCAL).setup();
    }

    @AfterMethod
    protected void teardown() {
        CompatibilityCacheFactory.killCacheFactories(this.cacheFactory);
    }

    public void testLoadingAndStoringEventsHotRod1() {
        Cache<String, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<String, String> remote = this.cacheFactory.getHotRodCache();
        TestCacheListener l = new TestCacheListener();
        embedded.addListener((Object)l);
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        remote.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((int)1, (int)l.createdCounter);
        AssertJUnit.assertEquals((Object)"v", (Object)l.created.get("k"));
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        remote.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        remote.put((Object)"key", (Object)"modifiedValue");
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.modifiedCounter);
        AssertJUnit.assertEquals((Object)"modifiedValue", (Object)l.modified.get("key"));
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        remote.replace((Object)"k", (Object)"replacedValue");
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)2, (int)l.modifiedCounter);
        AssertJUnit.assertEquals((Object)"replacedValue", (Object)l.modified.get("k"));
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        l.reset();
        HashSet<String> keys = new HashSet<String>();
        keys.add("k");
        keys.add("key");
        Map results = remote.getAll(keys);
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertEquals((int)2, (int)l.visitedCounter);
        AssertJUnit.assertEquals((Object)"replacedValue", (Object)l.visited.get("k"));
        AssertJUnit.assertEquals((Object)"modifiedValue", (Object)l.visited.get("key"));
        l.reset();
        remote.remove((Object)"key");
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.removedCounter);
        AssertJUnit.assertEquals((Object)"modifiedValue", (Object)l.removed.get("key"));
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        l.reset();
        String value = (String)remote.get((Object)"k");
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.visitedCounter);
        AssertJUnit.assertEquals((Object)"replacedValue", (Object)l.visited.get("k"));
        l.reset();
    }

    public void testLoadingAndStoringEventsHotRod2() {
        Cache<String, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<String, String> remote = this.cacheFactory.getHotRodCache();
        TestCacheListener l = new TestCacheListener();
        embedded.addListener((Object)l);
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("key", "value");
        tmp.put("key2", "value2");
        remote.putAll(tmp);
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertEquals((Object)"value", (Object)l.created.get("key"));
        AssertJUnit.assertEquals((Object)"value2", (Object)l.created.get("key2"));
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        l.reset();
        remote.putIfAbsent((Object)"newKey", (Object)"newValue");
        AssertJUnit.assertEquals((int)1, (int)l.createdCounter);
        AssertJUnit.assertEquals((Object)"newValue", (Object)l.created.get("newKey"));
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        l.reset();
        remote.putIfAbsent((Object)"newKey", (Object)"shouldNotBeAdded");
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.visitedCounter);
        l.reset();
    }

    public void testLoadingAndStoringWithVersionEventsHotRod() {
        Cache<String, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<String, String> remote = this.cacheFactory.getHotRodCache();
        TestCacheListener l = new TestCacheListener();
        embedded.addListener((Object)l);
        remote.put((Object)"key", (Object)"value");
        VersionedValue oldVersionedValue = remote.getVersioned((Object)"key");
        AssertJUnit.assertEquals((Object)"value", (Object)oldVersionedValue.getValue());
        AssertJUnit.assertEquals((int)1, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.visitedCounter);
        AssertJUnit.assertEquals((Object)"value", (Object)l.visited.get("key"));
        remote.put((Object)"key2", (Object)"value2");
        remote.put((Object)"key", (Object)"outOfVersionValue");
        VersionedValue newVersionedValue = remote.getVersioned((Object)"key2");
        l.reset();
        remote.removeWithVersion((Object)"key", oldVersionedValue.getVersion());
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.visitedCounter);
        l.reset();
        remote.removeWithVersion((Object)"key2", newVersionedValue.getVersion());
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.removedCounter);
        AssertJUnit.assertEquals((Object)"value2", (Object)l.removed.get("key2"));
        AssertJUnit.assertEquals((int)1, (int)l.visitedCounter);
        remote.put((Object)"newKey", (Object)"willBeOutOfDate");
        VersionedValue oldVersionedValueToBeReplaced = remote.getVersioned((Object)"newKey");
        remote.put((Object)"newKey", (Object)"changedValue");
        l.reset();
        remote.replaceWithVersion((Object)"newKey", (Object)"tryingToChangeButShouldNotSucceed", oldVersionedValueToBeReplaced.getVersion());
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        remote.put((Object)"newKey2", (Object)"willBeSuccessfullyChanged");
        VersionedValue newVersionedValueToBeReplaced = remote.getVersioned((Object)"newKey2");
        l.reset();
        remote.replaceWithVersion((Object)"newKey2", (Object)"successfulChange", newVersionedValueToBeReplaced.getVersion());
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.modifiedCounter);
        AssertJUnit.assertEquals((Object)"successfulChange", (Object)l.modified.get("newKey2"));
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        l.reset();
    }

    public void testLoadingAndStoringAsyncEventsHotRod() throws InterruptedException, ExecutionException, TimeoutException {
        Cache<String, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<String, String> remote = this.cacheFactory.getHotRodCache();
        TestCacheListener l = new TestCacheListener();
        embedded.addListener((Object)l);
        NotifyingFuture future = remote.putAsync((Object)"k", (Object)"v");
        future.get(60L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)1, (int)l.createdCounter);
        AssertJUnit.assertEquals((Object)"v", (Object)l.created.get("k"));
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        NotifyingFuture future2 = remote.putAsync((Object)"key", (Object)"value");
        future2.get(60L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        NotifyingFuture future3 = remote.putAsync((Object)"key", (Object)"modifiedValue");
        future3.get(60L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.modifiedCounter);
        AssertJUnit.assertEquals((Object)"modifiedValue", (Object)l.modified.get("key"));
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        NotifyingFuture future4 = remote.replaceAsync((Object)"k", (Object)"replacedValue");
        future4.get(60L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)2, (int)l.modifiedCounter);
        AssertJUnit.assertEquals((Object)"replacedValue", (Object)l.modified.get("k"));
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        l.reset();
        NotifyingFuture future5 = remote.removeAsync((Object)"key");
        future5.get(60L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.removedCounter);
        AssertJUnit.assertEquals((Object)"modifiedValue", (Object)l.removed.get("key"));
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        l.reset();
        NotifyingFuture future6 = remote.getAsync((Object)"k");
        future6.get(60L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.visitedCounter);
        AssertJUnit.assertEquals((Object)"replacedValue", (Object)l.visited.get("k"));
        l.reset();
    }
}

