/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.endpoints;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.infinispan.it.endpoints.TestCacheListener;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.endpoints.EmbeddedRestCacheListenerTest")
public class EmbeddedRestCacheListenerTest
extends AbstractInfinispanTest {
    EndpointsCacheFactory<String, String> cacheFactory;

    @BeforeMethod
    protected void setup() throws Exception {
        this.cacheFactory = new EndpointsCacheFactory(CacheMode.LOCAL).setup();
    }

    @AfterMethod
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories(this.cacheFactory);
    }

    public void testLoadingAndStoringEventsRest() throws IOException {
        Cache<String, String> embedded = this.cacheFactory.getEmbeddedCache();
        HttpClient remote = this.cacheFactory.getRestClient();
        String restUrl = this.cacheFactory.getRestUrl();
        TestCacheListener l = new TestCacheListener();
        embedded.addListener((Object)l);
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        PutMethod put = new PutMethod(restUrl + "/k");
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity("v".getBytes(), "application/octet-stream"));
        remote.executeMethod((HttpMethod)put);
        AssertJUnit.assertEquals((int)1, (int)l.createdCounter);
        AssertJUnit.assertEquals((byte[])"v".getBytes(), (byte[])((byte[])l.created.get("k")));
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)0, (int)l.modifiedCounter);
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        PutMethod put2 = new PutMethod(restUrl + "/key");
        put2.setRequestEntity((RequestEntity)new ByteArrayRequestEntity("value".getBytes(), "application/octet-stream"));
        remote.executeMethod((HttpMethod)put2);
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)0, (int)l.modifiedCounter);
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        PutMethod put3 = new PutMethod(restUrl + "/key");
        put3.setRequestEntity((RequestEntity)new ByteArrayRequestEntity("modifiedValue".getBytes(), "application/octet-stream"));
        remote.executeMethod((HttpMethod)put3);
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.modifiedCounter);
        AssertJUnit.assertEquals((byte[])"modifiedValue".getBytes(), (byte[])((byte[])l.modified.get("key")));
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        PutMethod post = new PutMethod(restUrl + "/k");
        post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity("replacedValue".getBytes(), "application/octet-stream"));
        remote.executeMethod((HttpMethod)post);
        AssertJUnit.assertEquals((int)2, (int)l.createdCounter);
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertEquals((int)2, (int)l.modifiedCounter);
        AssertJUnit.assertEquals((byte[])"replacedValue".getBytes(), (byte[])((byte[])l.modified.get("k")));
        AssertJUnit.assertTrue((boolean)l.visited.isEmpty());
        l.reset();
        DeleteMethod delete = new DeleteMethod(restUrl + "/key");
        remote.executeMethod((HttpMethod)delete);
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.removedCounter);
        AssertJUnit.assertEquals((byte[])"modifiedValue".getBytes(), (byte[])((byte[])l.removed.get("key")));
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        l.reset();
        GetMethod get = new GetMethod(restUrl + "/k");
        remote.executeMethod((HttpMethod)get);
        AssertJUnit.assertTrue((boolean)l.created.isEmpty());
        AssertJUnit.assertTrue((boolean)l.removed.isEmpty());
        AssertJUnit.assertTrue((boolean)l.modified.isEmpty());
        AssertJUnit.assertEquals((int)1, (int)l.visitedCounter);
        AssertJUnit.assertEquals((byte[])"replacedValue".getBytes(), (byte[])((byte[])l.visited.get("k")));
        l.reset();
    }
}

