/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CompletionListener;
import javax.cache.management.CacheStatisticsMXBean;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorResult;
import javax.management.MBeanServer;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.AbstractJCacheListenerAdapter;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.FailureEntryProcessorResult;
import org.infinispan.jcache.JCacheEntry;
import org.infinispan.jcache.SuccessEntryProcessorResult;
import org.infinispan.jcache.embedded.ConfigurationAdapter;
import org.infinispan.jcache.embedded.JCacheLoaderAdapter;
import org.infinispan.jcache.embedded.JCacheNotifier;
import org.infinispan.jcache.embedded.JCacheWriterAdapter;
import org.infinispan.jcache.embedded.LimitExpiryFactory;
import org.infinispan.jcache.embedded.RICacheStatistics;
import org.infinispan.jcache.embedded.functions.GetAndPut;
import org.infinispan.jcache.embedded.functions.GetAndRemove;
import org.infinispan.jcache.embedded.functions.GetAndReplace;
import org.infinispan.jcache.embedded.functions.Invoke;
import org.infinispan.jcache.embedded.functions.Put;
import org.infinispan.jcache.embedded.functions.PutIfAbsent;
import org.infinispan.jcache.embedded.functions.ReadWithExpiry;
import org.infinispan.jcache.embedded.functions.Remove;
import org.infinispan.jcache.embedded.functions.RemoveConditionally;
import org.infinispan.jcache.embedded.functions.Replace;
import org.infinispan.jcache.embedded.functions.ReplaceConditionally;
import org.infinispan.jcache.embedded.logging.Log;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerImpl;
import org.infinispan.util.logging.LogFactory;

public class JCache<K, V>
extends AbstractJCache<K, V> {
    private static final Log log = (Log)LogFactory.getLog(JCache.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final AdvancedCache<K, V> cache;
    private final AdvancedCache<K, V> skipCacheLoadCache;
    private final AdvancedCache<K, V> skipCacheLoadAndStatsCache;
    private final AdvancedCache<K, V> skipListenerCache;
    private final FunctionalMap.ReadWriteMap<K, V> rwMap;
    private final FunctionalMap.ReadWriteMap<K, V> rwMapSkipCacheLoad;
    private final RICacheStatistics stats;
    private final CacheJmxRegistration jmxRegistration;

    public JCache(AdvancedCache<K, V> cache, CacheManager cacheManager, ConfigurationAdapter<K, V> c) {
        super(JCache.adjustConfiguration(c.getConfiguration(), cache), cacheManager, new JCacheNotifier());
        this.cache = cache;
        this.skipCacheLoadCache = cache.withFlags(Flag.SKIP_CACHE_LOAD);
        this.skipCacheLoadAndStatsCache = cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_STATISTICS});
        this.skipListenerCache = cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION);
        this.rwMap = ReadWriteMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create(cache));
        this.rwMapSkipCacheLoad = this.rwMap.withParams(new Param[]{Param.PersistenceMode.SKIP_LOAD});
        this.stats = new RICacheStatistics(this.cache);
        this.jmxRegistration = cache.getCacheManager().getCacheManagerConfiguration().statistics() ? (CacheJmxRegistration)cache.getComponentRegistry().getComponent(CacheJmxRegistration.class) : null;
        this.addConfigurationListeners();
        if (cache.getComponentRegistry().getComponent(ExpiryPolicy.class) == null) {
            cache.getComponentRegistry().registerComponent((Object)this.expiryPolicy, ExpiryPolicy.class);
        }
        this.setCacheLoader((CompleteConfiguration)this.configuration);
        this.setCacheWriter((CompleteConfiguration)this.configuration);
        if (this.configuration.isManagementEnabled()) {
            this.setManagementEnabled(true);
        }
        if (this.configuration.isStatisticsEnabled()) {
            this.setStatisticsEnabled(true);
        }
    }

    private static <K, V> MutableConfiguration<K, V> adjustConfiguration(MutableConfiguration<K, V> configuration, AdvancedCache<K, V> cache) {
        Configuration cfg = cache.getCacheConfiguration();
        boolean lifespanSet = cfg.expiration().attributes().attribute(ExpirationConfiguration.LIFESPAN).isModified();
        boolean maxIdleSet = cfg.expiration().attributes().attribute(ExpirationConfiguration.MAX_IDLE).isModified();
        if (lifespanSet || maxIdleSet) {
            configuration.setExpiryPolicyFactory((Factory)new LimitExpiryFactory((Factory<ExpiryPolicy>)configuration.getExpiryPolicyFactory(), cfg.expiration().lifespan(), cfg.expiration().maxIdle()));
        }
        return configuration;
    }

    protected void addCacheLoaderAdapter(CacheLoader<K, V> cacheLoader) {
        PersistenceManagerImpl persistenceManager = (PersistenceManagerImpl)this.cache.getComponentRegistry().getComponent(PersistenceManager.class);
        JCacheLoaderAdapter<K, V> adapter = this.getCacheLoaderAdapter(persistenceManager);
        adapter.setCacheLoader(this.jcacheLoader);
        adapter.setExpiryPolicy(this.expiryPolicy);
    }

    protected void addCacheWriterAdapter(CacheWriter<? super K, ? super V> cacheWriter) {
        PersistenceManagerImpl persistenceManager = (PersistenceManagerImpl)this.cache.getComponentRegistry().getComponent(PersistenceManager.class);
        JCacheWriterAdapter<K, V> ispnCacheStore = this.getCacheWriterAdapter(persistenceManager);
        ispnCacheStore.setCacheWriter(this.jcacheWriter);
    }

    private JCacheLoaderAdapter<K, V> getCacheLoaderAdapter(PersistenceManagerImpl persistenceManager) {
        return (JCacheLoaderAdapter)persistenceManager.getAllLoaders().get(0);
    }

    private JCacheWriterAdapter<K, V> getCacheWriterAdapter(PersistenceManagerImpl persistenceManager) {
        return (JCacheWriterAdapter)persistenceManager.getAllWriters().get(0);
    }

    public void clear() {
        try {
            this.skipListenerCache.clear();
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public boolean containsKey(K key) {
        this.checkNotClosed();
        if (trace) {
            log.tracef("Invoke containsKey(key=%s)", key);
        }
        if (key == null) {
            throw log.parameterMustNotBeNull("key");
        }
        try {
            return this.skipCacheLoadAndStatsCache.containsKey(key);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public V get(K key) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        try {
            return (V)this.readMap().eval(key, new ReadWithExpiry()).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    private FunctionalMap.ReadWriteMap<K, V> readMap() {
        return this.configuration.isReadThrough() ? this.rwMap : this.rwMapSkipCacheLoad;
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkNotClosed();
        this.verifyKeys(keys);
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            return this.evalMany(this.readMap(), keys, new ReadWithExpiry());
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    private <R> Map<K, R> evalMany(FunctionalMap.ReadWriteMap<K, V> map, Set<? extends K> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> function) {
        return keys.stream().map(k -> new AbstractMap.SimpleEntry<Object, CompletableFuture>(k, map.eval(k, function))).collect(Collectors.toList()).stream().filter(e -> ((CompletableFuture)e.getValue()).join() != null).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, e -> ((CompletableFuture)e.getValue()).join()));
    }

    public V getAndPut(K key, V value) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(value, "value");
        try {
            return (V)this.rwMapSkipCacheLoad.eval(key, value, new GetAndPut()).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public V getAndRemove(K key) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        try {
            return (V)this.rwMapSkipCacheLoad.eval(key, GetAndRemove.getInstance()).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public V getAndReplace(K key, V value) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(value, "value");
        try {
            this.checkNotNull(value, "value");
            return (V)this.rwMapSkipCacheLoad.eval(key, value, new GetAndReplace()).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public void close() {
        super.close();
        this.cache.stop();
    }

    public boolean isClosed() {
        return this.cache.getStatus().isTerminated();
    }

    public String getName() {
        return this.cache.getName();
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(entryProcessor, "entryProcessor");
        try {
            FunctionalMap.ReadWriteMap<K, V> rw = this.configuration.isReadThrough() ? this.rwMap : this.rwMapSkipCacheLoad;
            return rw.eval(key, new Invoke<K, V, T>(entryProcessor, arguments, !this.configuration.isStoreByValue())).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.checkNotClosed();
        this.verifyKeys(keys);
        this.checkNotNull(entryProcessor, "entryProcessor");
        try {
            FunctionalMap.ReadWriteMap<K, V> rw = this.configuration.isReadThrough() ? this.rwMap : this.rwMapSkipCacheLoad;
            return keys.stream().map(k -> new AbstractMap.SimpleEntry<Object, CompletableFuture>(k, rw.eval(k, new Invoke(entryProcessor, arguments, !this.configuration.isStoreByValue())))).collect(Collectors.toList()).stream().filter(e -> {
                try {
                    return ((CompletableFuture)e.getValue()).join() != null;
                }
                catch (CompletionException ex) {
                    return true;
                }
            }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, e -> {
                try {
                    return new SuccessEntryProcessorResult(((CompletableFuture)e.getValue()).join());
                }
                catch (CompletionException ex) {
                    return new FailureEntryProcessorResult((Throwable)ex);
                }
            }));
        }
        catch (CompletionException e2) {
            throw Exceptions.launderException((CompletionException)e2);
        }
        catch (CacheException e3) {
            throw Exceptions.launderException((CacheException)e3);
        }
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        if (this.isClosed()) {
            throw log.cacheClosed(this.cache.getStatus());
        }
        return new Itr();
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener listener) {
        this.checkNotClosed();
        this.verifyKeys(keys);
        try {
            if (this.jcacheLoader == null && this.jcacheWriter != null) {
                this.setListenerCompletion(listener);
            } else if (this.jcacheLoader != null) {
                this.loadAllFromJCacheLoader(keys, replaceExistingValues, listener);
            } else {
                this.loadAllFromInfinispanCacheLoader(keys, replaceExistingValues, listener);
            }
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    private void loadAllFromJCacheLoader(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener listener) {
        AtomicInteger countDown = new AtomicInteger(1);
        BiConsumer<Object, Throwable> completionAction = (nil, t) -> {
            if (t != null) {
                if (countDown.getAndSet(0) != 0) {
                    this.setListenerException(listener, (Throwable)t);
                }
                return;
            }
            if (countDown.decrementAndGet() == 0) {
                this.setListenerCompletion(listener);
            }
        };
        try {
            Map loaded = this.loadAllKeys(keys);
            for (Map.Entry entry : loaded.entrySet()) {
                Object loadedKey = entry.getKey();
                Object loadedValue = entry.getValue();
                if (loadedValue == null) continue;
                countDown.incrementAndGet();
                if (replaceExistingValues) {
                    this.rwMap.withParams(new Param[]{Param.PersistenceMode.SKIP}).eval(loadedKey, loadedValue, new Put()).whenComplete(completionAction);
                    continue;
                }
                this.rwMap.withParams(new Param[]{Param.PersistenceMode.SKIP}).eval(loadedKey, loadedValue, new PutIfAbsent()).whenComplete(completionAction);
            }
            completionAction.accept(null, null);
        }
        catch (Throwable t2) {
            completionAction.accept(null, t2);
        }
    }

    public void put(K key, V value) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(value, "value");
        try {
            this.rwMapSkipCacheLoad.eval(key, value, new Put()).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public void putAll(Map<? extends K, ? extends V> inputMap) {
        this.checkNotClosed();
        InfinispanCollections.assertNotNullEntries(inputMap, (String)"inputMap");
        try {
            if (this.configuration.isWriteThrough()) {
                inputMap.entrySet().stream().map(e -> this.rwMap.eval(e.getKey(), e.getValue(), new Put())).collect(Collectors.toList()).forEach(CompletableFuture::join);
            } else {
                this.rwMapSkipCacheLoad.evalMany(inputMap, new Put()).forEach(nil -> {});
            }
        }
        catch (CompletionException e2) {
            throw Exceptions.launderException((CompletionException)e2);
        }
        catch (CacheException e3) {
            throw Exceptions.launderException((CacheException)e3);
        }
    }

    public boolean putIfAbsent(K key, V value) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(value, "value");
        try {
            return (Boolean)this.rwMapSkipCacheLoad.eval(key, value, new PutIfAbsent()).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public boolean remove(K key) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        try {
            return (Boolean)this.rwMapSkipCacheLoad.eval(key, Remove.getInstance()).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public boolean remove(K key, V oldValue) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(oldValue, "oldValue");
        try {
            return (Boolean)this.rwMapSkipCacheLoad.eval(key, oldValue, new RemoveConditionally()).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public void removeAll() {
        if (this.isClosed()) {
            throw log.cacheClosed(this.cache.getStatus());
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        try {
            for (Object key : this.cache.keySet()) {
                futures.add(this.cache.removeAsync(key));
            }
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
    }

    public void removeAll(Set<? extends K> keys) {
        this.checkNotClosed();
        this.verifyKeys(keys);
        try {
            if (this.configuration.isWriteThrough()) {
                keys.stream().map(k -> this.rwMapSkipCacheLoad.eval(k, Remove.getInstance())).collect(Collectors.toList()).forEach(CompletableFuture::join);
            } else {
                this.rwMapSkipCacheLoad.evalMany(keys, Remove.getInstance()).forEach(b -> {});
            }
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public boolean replace(K key, V value) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(value, "value");
        try {
            return (Boolean)this.rwMapSkipCacheLoad.eval(key, value, new Replace()).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(oldValue, "oldValue");
        this.checkNotNull(newValue, "newValue");
        try {
            return (Boolean)this.rwMapSkipCacheLoad.eval(key, newValue, new ReplaceConditionally(oldValue)).join();
        }
        catch (CompletionException e) {
            throw Exceptions.launderException((CompletionException)e);
        }
        catch (CacheException e) {
            throw Exceptions.launderException((CacheException)e);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrapAny(clazz, (Object[])new Object[]{this, this.cache});
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        this.notifier.addListener(listenerCfg, (AbstractJCache)this, this.notifier);
        this.addCacheEntryListenerConfiguration(listenerCfg);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        this.notifier.removeListener(listenerCfg, (AbstractJCache)this);
        this.removeCacheEntryListenerConfiguration(listenerCfg);
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.cache.getStats().setStatisticsEnabled(enabled);
        super.setStatisticsEnabled(enabled);
    }

    protected CacheStatisticsMXBean getCacheStatisticsMXBean() {
        return this.stats;
    }

    protected MBeanServer getMBeanServer() {
        return this.jmxRegistration != null ? this.jmxRegistration.getMBeanServer() : null;
    }

    protected AbstractJCache<K, V> checkNotClosed() {
        if (this.isClosed()) {
            throw log.cacheClosed(this.cache.getStatus());
        }
        return this;
    }

    private void loadAllFromInfinispanCacheLoader(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener listener) {
        AtomicInteger countDown = new AtomicInteger(keys.size() + 1);
        BiConsumer<Object, Throwable> completionAction = (v, t) -> {
            if (t != null) {
                if (countDown.getAndSet(0) != 0) {
                    this.setListenerException(listener, (Throwable)t);
                }
                return;
            }
            if (trace) {
                log.tracef("Key loaded, wait for the rest of keys to load", new Object[0]);
            }
            if (countDown.decrementAndGet() == 0) {
                this.setListenerCompletion(listener);
            }
        };
        try {
            for (K k : keys) {
                if (replaceExistingValues) {
                    this.cache.evict(k);
                }
                this.cache.getAsync(k).whenComplete(completionAction);
            }
            completionAction.accept(null, null);
        }
        catch (Throwable t2) {
            log.errorLoadingAll(keys, t2);
            completionAction.accept(null, t2);
        }
    }

    protected void addListener(AbstractJCacheListenerAdapter<K, V> listenerAdapter) {
        this.cache.addListener(listenerAdapter);
    }

    protected void removeListener(AbstractJCacheListenerAdapter<K, V> listenerAdapter) {
        this.cache.removeListener(listenerAdapter);
    }

    protected void evict(K key) {
        this.cache.evict(key);
    }

    private class Itr
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> it;
        private Cache.Entry<K, V> current;
        private Cache.Entry<K, V> next;

        Itr() {
            this.it = JCache.this.cache.entrySet().iterator();
            this.fetchNext();
        }

        private void fetchNext() {
            long start;
            long l = start = JCache.this.statisticsEnabled() ? System.nanoTime() : 0L;
            if (this.it.hasNext()) {
                Map.Entry entry = this.it.next();
                this.next = new JCacheEntry(entry.getKey(), entry.getValue());
                if (JCache.this.statisticsEnabled()) {
                    JCache.this.stats.increaseCacheHits(1L);
                    JCache.this.stats.addGetTimeNano(System.nanoTime() - start);
                }
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (this.next == null) {
                this.fetchNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Cache.Entry ret = this.next;
            JCache.this.updateTTLForAccessed((BasicCache)JCache.this.cache, this.next.getKey(), this.next.getValue());
            this.current = this.next;
            this.fetchNext();
            return ret;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object k = this.current.getKey();
            this.current = null;
            JCache.this.cache.remove(k);
        }
    }
}

