/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded.functions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.cache.CacheException;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.Expiration;
import org.infinispan.jcache.embedded.Durations;
import org.infinispan.jcache.embedded.ExternalizerIds;
import org.infinispan.jcache.embedded.functions.MutableEntrySnapshot;
import org.infinispan.jcache.embedded.functions.MutableEntryWrapper;
import org.infinispan.marshall.persistence.PersistenceMarshaller;

public class Invoke<K, V, R>
implements Function<EntryView.ReadWriteEntryView<K, V>, R>,
InjectableComponent {
    private final EntryProcessor<K, V, R> processor;
    private final Object[] arguments;
    private final boolean storeByReference;
    private PersistenceMarshaller marshaller;
    private ExpiryPolicy expiryPolicy;

    public Invoke(EntryProcessor<K, V, R> processor, Object[] arguments, boolean storeByReference) {
        this.processor = processor;
        this.arguments = arguments;
        this.storeByReference = storeByReference;
    }

    public void inject(ComponentRegistry registry) {
        this.marshaller = registry.getPersistenceMarshaller();
        this.expiryPolicy = (ExpiryPolicy)registry.getComponent(ExpiryPolicy.class);
    }

    @Override
    public R apply(EntryView.ReadWriteEntryView<K, V> view) {
        MutableEntrySnapshot<Object, Object> retval;
        Object oldValue = view.find().orElse(null);
        Supplier<Object> supplier = oldValue == null ? () -> null : () -> this.copy(oldValue);
        MutableEntryWrapper<K, Object> entry = new MutableEntryWrapper<K, Object>(view, supplier, oldValue != null, this.expiryPolicy);
        try {
            retval = this.processor.process(entry, this.arguments);
        }
        catch (Exception e) {
            throw Exceptions.launderEntryProcessorException((Exception)e);
        }
        boolean readByReturn = false;
        if (retval instanceof MutableEntryWrapper) {
            readByReturn = true;
            retval = new MutableEntrySnapshot<Object, Object>(view.key(), view.find().orElse(null));
        }
        if (!entry.isModified() && (entry.isRead() || readByReturn)) {
            boolean loaded = view.findMetaParam(MetaParam.MetaLoadedFromPersistence.class).map(MetaParam::get).orElse(false);
            Durations.updateTtl(view, this.expiryPolicy, loaded ? Expiration.Operation.CREATION : Expiration.Operation.ACCESS);
        }
        return (R)retval;
    }

    private V copy(V original) {
        if (this.storeByReference) {
            return original;
        }
        try {
            byte[] bytes = this.marshaller.objectToByteBuffer(original);
            Object o = this.marshaller.objectFromByteBuffer(bytes);
            return (V)o;
        }
        catch (Exception e) {
            throw new CacheException("Unexpected error making a copy of entry " + original, (Throwable)e);
        }
    }

    public static class Externalizer
    implements AdvancedExternalizer<Invoke> {
        public Set<Class<? extends Invoke>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{Invoke.class});
        }

        public Integer getId() {
            return ExternalizerIds.INVOKE;
        }

        public void writeObject(ObjectOutput output, Invoke object) throws IOException {
            output.writeObject(object.processor);
            MarshallUtil.marshallArray((Object[])object.arguments, (ObjectOutput)output);
            output.writeBoolean(object.storeByReference);
        }

        public Invoke readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new Invoke((EntryProcessor)input.readObject(), MarshallUtil.unmarshallArray((ObjectInput)input, Util::objectArray), input.readBoolean());
        }
    }
}

