/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded.functions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import javax.cache.processor.MutableEntry;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.jcache.embedded.ExternalizerIds;

public class MutableEntrySnapshot<K, V>
implements MutableEntry<K, V> {
    private final K key;
    private final V value;

    public MutableEntrySnapshot(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public boolean exists() {
        return this.value != null;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrap((Object)this, clazz);
    }

    public void setValue(V value) {
        throw new UnsupportedOperationException();
    }

    public static class Externalizer
    implements AdvancedExternalizer<MutableEntrySnapshot> {
        public Set<Class<? extends MutableEntrySnapshot>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{MutableEntrySnapshot.class});
        }

        public Integer getId() {
            return ExternalizerIds.MUTABLE_ENTRY_SNAPSHOT;
        }

        public void writeObject(ObjectOutput output, MutableEntrySnapshot object) throws IOException {
            output.writeObject(object.key);
            output.writeObject(object.value);
        }

        public MutableEntrySnapshot readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new MutableEntrySnapshot<Object, Object>(input.readObject(), input.readObject());
        }
    }
}

