/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.integration.CacheLoader;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.jcache.embedded.JCacheLoaderAdapter;
import org.infinispan.jcache.util.InMemoryJCacheLoader;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryFactoryImpl;
import org.infinispan.persistence.DummyInitializationContext;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.EmbeddedTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="jcache.JCacheLoaderAdapterTest")
public class JCacheLoaderAdapterTest
extends AbstractInfinispanTest {
    private static TestObjectStreamMarshaller marshaller;
    private static InitializationContext ctx;
    private JCacheLoaderAdapter<Integer, String> adapter;

    @BeforeClass
    public static void setUpClass() {
        EmbeddedTimeService timeService = new EmbeddedTimeService();
        marshaller = new TestObjectStreamMarshaller();
        MarshalledEntryFactoryImpl marshalledEntryFactory = new MarshalledEntryFactoryImpl((Marshaller)marshaller);
        ctx = new DummyInitializationContext((TimeService)timeService, (MarshallableEntryFactory)marshalledEntryFactory){
            final /* synthetic */ TimeService val$timeService;
            final /* synthetic */ MarshallableEntryFactory val$marshalledEntryFactory;
            {
                this.val$timeService = timeService;
                this.val$marshalledEntryFactory = marshallableEntryFactory;
            }

            public TimeService getTimeService() {
                return this.val$timeService;
            }

            public MarshallableEntryFactory getMarshallableEntryFactory() {
                return this.val$marshalledEntryFactory;
            }
        };
    }

    @AfterClass
    public static void tearDownClass() {
        marshaller.stop();
    }

    @BeforeMethod
    public void setUpMethod() {
        this.adapter = new JCacheLoaderAdapter();
        this.adapter.init(ctx);
        this.adapter.setCacheLoader((CacheLoader)new InMemoryJCacheLoader().store((Object)1, (Object)"v1").store((Object)2, (Object)"v2"));
    }

    public void testLoad() {
        AssertJUnit.assertNull((Object)this.adapter.loadEntry((Object)0));
        MarshallableEntry v1Entry = this.adapter.loadEntry((Object)1);
        AssertJUnit.assertNotNull((Object)v1Entry);
        AssertJUnit.assertEquals((Object)1, (Object)v1Entry.getKey());
        AssertJUnit.assertEquals((Object)"v1", (Object)v1Entry.getValue());
        MarshallableEntry v2Entry = this.adapter.loadEntry((Object)2);
        AssertJUnit.assertNotNull((Object)v2Entry);
        AssertJUnit.assertEquals((Object)2, (Object)v2Entry.getKey());
        AssertJUnit.assertEquals((Object)"v2", (Object)v2Entry.getValue());
    }

    public void testContains() {
        AssertJUnit.assertFalse((boolean)this.adapter.contains((Object)0));
        AssertJUnit.assertTrue((boolean)this.adapter.contains((Object)1));
        AssertJUnit.assertTrue((boolean)this.adapter.contains((Object)2));
    }
}

