/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.integration.CompletionListenerFuture;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.jcache.embedded.JCacheManager;
import org.infinispan.jcache.util.InMemoryJCacheLoader;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jcache.JCacheLoaderTest")
public class JCacheLoaderTest
extends AbstractInfinispanTest {
    public void testLoadAllWithJCacheLoader(Method m) {
        final String cacheName = m.getName();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((boolean)false)){

            public void call() {
                JCacheManager jCacheManager = JCacheLoaderTest.createJCacheManager(this.cm, (Object)this);
                InMemoryJCacheLoader cacheLoader = new InMemoryJCacheLoader();
                cacheLoader.store((Object)1, (Object)"v1").store((Object)2, (Object)"v2");
                MutableConfiguration cfg = new MutableConfiguration();
                cfg.setCacheLoaderFactory(FactoryBuilder.factoryOf((Serializable)cacheLoader));
                javax.cache.Cache cache = jCacheManager.createCache(cacheName, (Configuration)cfg);
                AssertJUnit.assertEquals((long)0L, (long)cacheLoader.getLoadCount());
                CompletionListenerFuture future = new CompletionListenerFuture();
                cache.loadAll(Util.asSet((Object[])new Integer[]{1, 2}), true, (CompletionListener)future);
                JCacheLoaderTest.this.futureGet(future);
                AssertJUnit.assertEquals((long)2L, (long)cacheLoader.getLoadCount());
            }
        });
    }

    public void testLoadAllWithInfinispanCacheLoader() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((boolean)false)){

            public void call() {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(((Object)((Object)JCacheLoaderTest.this)).getClass().getName());
                this.cm.defineConfiguration("dummyStore", builder.build());
                JCacheManager jCacheManager = JCacheLoaderTest.createJCacheManager(this.cm, (Object)this);
                javax.cache.Cache cache = jCacheManager.getCache("dummyStore");
                int numEntries = JCacheLoaderTest.loadInitialData(this.cm);
                DummyInMemoryStore dummyStore = (DummyInMemoryStore)TestingUtil.getFirstStore((Cache)this.cm.getCache("dummyStore"));
                CompletionListenerFuture future = new CompletionListenerFuture();
                Set<Integer> keys = Collections.singleton(1);
                cache.loadAll(keys, false, (CompletionListener)future);
                JCacheLoaderTest.this.futureGet(future);
                AssertJUnit.assertTrue((boolean)future.isDone());
                AssertJUnit.assertEquals((int)numEntries, (int)((Integer)dummyStore.stats().get("load")));
                AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)1)));
                future = new CompletionListenerFuture();
                cache.loadAll(keys, true, (CompletionListener)future);
                JCacheLoaderTest.this.futureGet(future);
                AssertJUnit.assertTrue((boolean)future.isDone());
                AssertJUnit.assertEquals((int)(numEntries * 2), (int)((Integer)dummyStore.stats().get("load")));
            }
        });
    }

    public void testLoadEntryWithExpiration(Method m) {
        final String cacheName = m.getName();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((boolean)false)){

            public void call() {
                ControlledTimeService timeService = new ControlledTimeService();
                TestingUtil.replaceComponent((CacheContainer)this.cm, TimeService.class, (Object)timeService, (boolean)true);
                JCacheManager jCacheManager = JCacheLoaderTest.createJCacheManager(this.cm, (Object)this);
                InMemoryJCacheLoader cacheLoader = new InMemoryJCacheLoader();
                cacheLoader.store((Object)1, (Object)"v1").store((Object)2, (Object)"v2");
                MutableConfiguration cfg = new MutableConfiguration();
                long lifespan = 3000L;
                cfg.setReadThrough(true);
                cfg.setExpiryPolicyFactory((Factory & Serializable)() -> new ExpiryPolicy(){

                    public Duration getExpiryForCreation() {
                        return new Duration(TimeUnit.MILLISECONDS, 3000L);
                    }

                    public Duration getExpiryForAccess() {
                        return null;
                    }

                    public Duration getExpiryForUpdate() {
                        return Duration.ZERO;
                    }
                });
                cfg.setCacheLoaderFactory(FactoryBuilder.factoryOf((Serializable)cacheLoader));
                javax.cache.Cache cache = jCacheManager.createCache(cacheName, (Configuration)cfg);
                AssertJUnit.assertEquals((String)"v2", (String)((String)cache.get((Object)2)));
                AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)1)));
                timeService.advance(3100L);
                DataContainer dc = ((AdvancedCache)cache.unwrap(AdvancedCache.class)).getDataContainer();
                AssertJUnit.assertEquals(null, (Object)dc.peek((Object)2));
                AssertJUnit.assertEquals(null, (Object)dc.peek((Object)1));
            }
        });
    }

    public void testLoadUnmarshallableValue(Method m) {
        final String cacheName = m.getName();
        final NonMarshallablePojo v1 = new NonMarshallablePojo("v1");
        final NonMarshallablePojo v2 = new NonMarshallablePojo("v2");
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((boolean)false)){

            public void call() {
                JCacheManager jCacheManager = JCacheLoaderTest.createJCacheManager(this.cm, (Object)this);
                InMemoryJCacheLoader cacheLoader = new InMemoryJCacheLoader();
                cacheLoader.store((Object)1, (Object)v1).store((Object)2, (Object)v2);
                MutableConfiguration cfg = new MutableConfiguration();
                cfg.setStoreByValue(false);
                cfg.setReadThrough(true);
                cfg.setCacheLoaderFactory(FactoryBuilder.factoryOf((Serializable)cacheLoader));
                javax.cache.Cache cache = jCacheManager.createCache(cacheName, (Configuration)cfg);
                AssertJUnit.assertEquals((Object)v2, (Object)cache.get((Object)2));
                AssertJUnit.assertEquals((Object)v1, (Object)cache.get((Object)1));
                DataContainer dc = ((AdvancedCache)cache.unwrap(AdvancedCache.class)).getDataContainer();
                AssertJUnit.assertEquals((Object)v2, (Object)dc.peek((Object)2).getValue());
                AssertJUnit.assertEquals((Object)v1, (Object)dc.peek((Object)1).getValue());
            }
        });
    }

    private Void futureGet(CompletionListenerFuture future) {
        try {
            return future.get();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    private static int loadInitialData(EmbeddedCacheManager cm) {
        TestingUtil.writeToAllStores((Object)1, (Object)"v1", (Cache)cm.getCache("dummyStore"));
        return 1;
    }

    private static JCacheManager createJCacheManager(EmbeddedCacheManager cm, Object creator) {
        return new JCacheManager(URI.create(creator.getClass().getName()), cm, null);
    }

    public static class NonMarshallablePojo {
        public final String value;

        public NonMarshallablePojo(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NonMarshallablePojo that = (NonMarshallablePojo)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "NonMarshallablePojo{value='" + this.value + '\'' + '}';
        }
    }
}

