/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import javax.cache.Cache;
import org.infinispan.encoding.DataConversion;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.JCacheEntry;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;

public class JCacheWriterAdapter<K, V>
implements CacheWriter {
    private javax.cache.integration.CacheWriter<? super K, ? super V> delegate;
    private DataConversion keyDataConversion = DataConversion.IDENTITY_KEY;
    private DataConversion valueDataConversion = DataConversion.IDENTITY_KEY;

    public void setCacheWriter(javax.cache.integration.CacheWriter<? super K, ? super V> delegate) {
        this.delegate = delegate;
    }

    public void setDataConversion(DataConversion keyDataConversion, DataConversion valueDataConversion) {
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    public void init(InitializationContext ctx) {
    }

    public void write(MarshallableEntry entry) {
        try {
            this.delegate.write((Cache.Entry)new JCacheEntry(this.keyDataConversion.fromStorage(entry.getKey()), this.valueDataConversion.fromStorage(entry.getValue())));
        }
        catch (Exception e) {
            throw Exceptions.launderCacheWriterException((Exception)e);
        }
    }

    public boolean delete(Object key) {
        try {
            this.delegate.delete(this.keyDataConversion.fromStorage(key));
        }
        catch (Exception e) {
            throw Exceptions.launderCacheWriterException((Exception)e);
        }
        return false;
    }

    public void start() {
    }

    public void stop() {
    }
}

