/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;

public class RICacheEntryEvent<K, V>
extends CacheEntryEvent<K, V> {
    private static final long serialVersionUID = 6515030413069752679L;
    private K key;
    private V value;
    private V oldValue;
    private boolean oldValueAvailable;

    public RICacheEntryEvent(Cache<K, V> source, K key, V value) {
        super(source);
        this.key = key;
        this.value = value;
        this.oldValue = null;
        this.oldValueAvailable = false;
    }

    public RICacheEntryEvent(Cache<K, V> source, K key, V value, V oldValue) {
        super(source);
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
        this.oldValueAvailable = true;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public V getOldValue() throws UnsupportedOperationException {
        if (this.isOldValueAvailable()) {
            return this.oldValue;
        }
        throw new UnsupportedOperationException("Old value is not available for key");
    }

    public boolean isOldValueAvailable() {
        return this.oldValueAvailable;
    }
}

