/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jcache.JCacheLoaderAdapter;
import org.infinispan.jcache.JCacheWriterAdapter;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;

public class ConfigurationAdapter<K, V> {
    private Configuration<K, V> c;

    public ConfigurationAdapter(Configuration<K, V> configuration) {
        this.c = configuration;
    }

    public org.infinispan.configuration.cache.Configuration build() {
        CacheWriter cacheWriter;
        ConfigurationBuilder cb = new ConfigurationBuilder();
        if (this.c.isStoreByValue()) {
            cb.storeAsBinary().enable().defensive(true);
        }
        switch (this.c.getTransactionMode()) {
            case NONE: {
                cb.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
                break;
            }
            case LOCAL: {
                cb.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
                break;
            }
            case XA: {
                break;
            }
        }
        switch (this.c.getTransactionIsolationLevel()) {
            case NONE: {
                cb.locking().isolationLevel(IsolationLevel.NONE);
                break;
            }
            case READ_UNCOMMITTED: {
                cb.locking().isolationLevel(IsolationLevel.READ_UNCOMMITTED);
                break;
            }
            case READ_COMMITTED: {
                cb.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
                break;
            }
            case REPEATABLE_READ: {
                cb.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
                break;
            }
            case SERIALIZABLE: {
                cb.locking().isolationLevel(IsolationLevel.SERIALIZABLE);
                break;
            }
        }
        CacheLoader cacheLoader = this.c.getCacheLoader();
        if (cacheLoader != null) {
            cb.loaders().addStore().cacheStore(new JCacheLoaderAdapter());
        }
        if ((cacheWriter = this.c.getCacheWriter()) != null) {
            cb.loaders().addStore().cacheStore(new JCacheWriterAdapter());
        }
        return cb.build();
    }
}

