/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.lang.reflect.Method;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Configuration;
import javax.cache.ExpiryPolicy;
import javax.cache.Factory;
import javax.cache.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.infinispan.jcache.util.JCacheRunnable;
import org.infinispan.jcache.util.JCacheTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jcache.JCacheExpiryTest")
public class JCacheExpiryTest {
    public void testGetAndReplace(Method m) {
        final MutableConfiguration cfg = new MutableConfiguration();
        cfg.setExpiryPolicyFactory((Factory)new Factory<ExpiryPolicy<? super Integer, ? super String>>(){

            public ExpiryPolicy<? super Integer, ? super String> create() {
                return new ExpiryPolicy<Integer, String>(){

                    public Configuration.Duration getTTLForCreatedEntry(Cache.Entry<? extends Integer, ? extends String> entry) {
                        return Configuration.Duration.ETERNAL;
                    }

                    public Configuration.Duration getTTLForAccessedEntry(Cache.Entry<? extends Integer, ? extends String> entry, Configuration.Duration duration) {
                        return null;
                    }

                    public Configuration.Duration getTTLForModifiedEntry(Cache.Entry<? extends Integer, ? extends String> entry, Configuration.Duration duration) {
                        return Configuration.Duration.ZERO;
                    }
                };
            }
        });
        final String name = this.getName(m);
        JCacheTestingUtil.withCachingProvider(new JCacheRunnable(){

            @Override
            public void run(CachingProvider provider) {
                CacheManager cm = provider.getCacheManager();
                Cache cache = cm.configureCache(name, (Configuration)cfg);
                cache.put((Object)1, (Object)"v1");
                AssertJUnit.assertTrue((boolean)cache.containsKey((Object)1));
                AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)1)));
                cache.getAndReplace((Object)1, (Object)"v2");
                AssertJUnit.assertFalse((boolean)cache.containsKey((Object)1));
                AssertJUnit.assertNull((Object)cache.get((Object)1));
            }
        });
    }

    private String getName(Method m) {
        return this.getClass().getName() + '.' + m.getName();
    }
}

