/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Configuration;
import javax.cache.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.infinispan.jcache.util.JCacheRunnable;
import org.infinispan.jcache.util.JCacheTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jcache.InvokeProcessorTest")
public class InvokeProcessorTest {
    public void testInvokeProcesorStoreByValueException(Method m) {
        this.invokeProcessorThrowsException(m, (MutableConfiguration<String, List<Integer>>)new MutableConfiguration(), new ArrayList<Integer>(Arrays.asList(1, 2, 3)));
    }

    public void testInvokeProcesorStoreByReferenceException(Method m) {
        this.invokeProcessorThrowsException(m, (MutableConfiguration<String, List<Integer>>)new MutableConfiguration().setStoreByValue(false), new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4)));
    }

    public void testInvokeProcesorStoreByValue(Method m) {
        this.invokeProcessor(m, (MutableConfiguration<String, List<Integer>>)new MutableConfiguration());
    }

    private void invokeProcessorThrowsException(Method m, final MutableConfiguration<String, List<Integer>> jcacheCfg, final List<Integer> expectedValue) {
        final String name = this.getName(m);
        JCacheTestingUtil.withCachingProvider(new JCacheRunnable(){

            @Override
            public void run(CachingProvider provider) {
                CacheManager cm = provider.getCacheManager();
                Cache cache = cm.configureCache(name, (Configuration)jcacheCfg);
                ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
                String query = "select * from x";
                cache.put((Object)"select * from x", list);
                try {
                    cache.invokeEntryProcessor((Object)"select * from x", (Cache.EntryProcessor)new Cache.EntryProcessor<String, List<Integer>, Object>(){

                        public Object process(Cache.MutableEntry<String, List<Integer>> entry, Object ... arguments) {
                            ((List)entry.getValue()).add(4);
                            throw new UnexpectedException();
                        }
                    }, new Object[0]);
                    AssertJUnit.fail((String)"Expected an exception to be thrown");
                }
                catch (CacheException e) {
                    AssertJUnit.assertTrue((boolean)(e.getCause() instanceof UnexpectedException));
                }
                AssertJUnit.assertEquals((Object)expectedValue, (Object)cache.get((Object)"select * from x"));
            }
        });
    }

    private void invokeProcessor(Method m, final MutableConfiguration<String, List<Integer>> jcacheCfg) {
        final String name = this.getName(m);
        JCacheTestingUtil.withCachingProvider(new JCacheRunnable(){

            @Override
            public void run(CachingProvider provider) {
                CacheManager cm = provider.getCacheManager();
                Cache cache = cm.configureCache(name, (Configuration)jcacheCfg);
                ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
                String query = "select * from x";
                cache.put((Object)"select * from x", list);
                cache.invokeEntryProcessor((Object)"select * from x", (Cache.EntryProcessor)new Cache.EntryProcessor<String, List<Integer>, Object>(){

                    public Object process(Cache.MutableEntry<String, List<Integer>> entry, Object ... arguments) {
                        List ids = (List)entry.getValue();
                        ids.add(4);
                        entry.setValue((Object)ids);
                        return null;
                    }
                }, new Object[0]);
                AssertJUnit.assertEquals(new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4)), (Object)cache.get((Object)"select * from x"));
            }
        });
    }

    private String getName(Method m) {
        return this.getClass().getName() + '.' + m.getName();
    }

    private static class UnexpectedException
    extends RuntimeException {
        private UnexpectedException() {
        }
    }
}

