/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.net.URI;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.cache.CacheManager;
import javax.cache.CachingShutdownException;
import javax.cache.OptionalFeature;
import javax.cache.Status;
import javax.cache.spi.CachingProvider;
import org.infinispan.jcache.JCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JCachingProvider
implements CachingProvider {
    private static final Log log = LogFactory.getLog(JCachingProvider.class);
    private static final URI DEFAULT_URI = URI.create(JCachingProvider.class.getName());
    private final Map<ClassLoader, Map<URI, JCacheManager>> cacheManagers = new WeakHashMap<ClassLoader, Map<URI, JCacheManager>>();

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        return this.getCacheManager(uri, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(URI managerUri, ClassLoader managerClassLoader) {
        URI uri = managerUri == null ? this.getDefaultURI() : managerUri;
        ClassLoader classLoader = managerClassLoader == null ? this.getDefaultClassLoader() : managerClassLoader;
        Map<ClassLoader, Map<URI, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            JCacheManager cacheManager;
            Map<URI, JCacheManager> map2 = this.cacheManagers.get(classLoader);
            if (map2 == null) {
                if (log.isTraceEnabled()) {
                    log.tracef("No cache managers registered under '%s'", (Object)uri);
                }
                map2 = new HashMap<URI, JCacheManager>();
                this.cacheManagers.put(classLoader, map2);
            }
            if ((cacheManager = map2.get(uri)) == null || cacheManager.getStatus() == Status.STOPPED) {
                cacheManager = this.createCacheManager(classLoader, uri);
                if (log.isTraceEnabled()) {
                    log.tracef("Created '%s' cache manager", (Object)uri);
                }
                map2.put(uri, cacheManager);
            }
            return cacheManager;
        }
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public URI getDefaultURI() {
        return DEFAULT_URI;
    }

    public Properties getDefaultProperties() {
        return null;
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(DEFAULT_URI, this.getDefaultClassLoader());
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        switch (optionalFeature) {
            case TRANSACTIONS: {
                return true;
            }
            case STORE_BY_REFERENCE: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClassLoader, Map<URI, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            IdentityHashMap failures = new IdentityHashMap();
            for (Map<URI, JCacheManager> map2 : this.cacheManagers.values()) {
                try {
                    this.close(map2);
                }
                catch (CachingShutdownException e) {
                    failures.putAll(e.getFailures());
                }
            }
            this.cacheManagers.clear();
            if (log.isTraceEnabled()) {
                log.tracef("All cache managers have been removed", new Object[0]);
            }
            if (!failures.isEmpty()) {
                throw new CachingShutdownException(failures);
            }
        }
    }

    public void close(ClassLoader classLoader) {
        this.close(null, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        Map<ClassLoader, Map<URI, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            if (uri != null) {
                Map<URI, JCacheManager> map2 = this.cacheManagers.get(classLoader);
                JCacheManager cacheManager = map2.remove(uri);
                if (map2.isEmpty()) {
                    this.cacheManagers.remove(classLoader);
                }
                if (cacheManager != null) {
                    cacheManager.close();
                }
            } else {
                Map<URI, JCacheManager> cacheManagersToClose = this.cacheManagers.remove(classLoader);
                if (cacheManagersToClose != null) {
                    this.close(cacheManagersToClose);
                }
            }
        }
    }

    private void close(Map<URI, JCacheManager> map) throws CachingShutdownException {
        IdentityHashMap<JCacheManager, Exception> failures = new IdentityHashMap<JCacheManager, Exception>();
        for (JCacheManager cacheManager : map.values()) {
            try {
                cacheManager.close();
                if (!log.isTraceEnabled()) continue;
                log.tracef("Shutdown cache manager '%s'", (Object)cacheManager.getURI());
            }
            catch (Exception e) {
                failures.put(cacheManager, e);
            }
        }
        if (!failures.isEmpty()) {
            throw new CachingShutdownException(failures);
        }
    }

    private JCacheManager createCacheManager(ClassLoader classLoader, URI uri) {
        return new JCacheManager(uri, classLoader, (CachingProvider)this);
    }
}

