/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.lang.annotation.Annotation;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.Configuration;
import javax.cache.MutableConfiguration;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheResolver;
import javax.cache.spi.CachingProvider;
import javax.enterprise.context.ApplicationScoped;
import org.infinispan.jcache.annotation.Contracts;

@ApplicationScoped
public class DefaultCacheResolver
implements CacheResolver {
    private CacheManager defaultCacheManager;

    DefaultCacheResolver() {
        CachingProvider provider = Caching.getCachingProvider();
        this.defaultCacheManager = provider.getCacheManager(provider.getDefaultURI(), provider.getDefaultClassLoader());
    }

    public <K, V> Cache<K, V> resolveCache(CacheInvocationContext<? extends Annotation> cacheInvocationContext) {
        Contracts.assertNotNull(cacheInvocationContext, "cacheInvocationContext parameter must not be null");
        String cacheName = cacheInvocationContext.getCacheName();
        if (cacheName.trim().isEmpty()) {
            return this.defaultCacheManager.configureCache(cacheName, (Configuration)new MutableConfiguration());
        }
        for (Cache cache : this.defaultCacheManager.getCaches()) {
            if (!cache.getName().equals(cacheName)) continue;
            return cache;
        }
        return this.defaultCacheManager.configureCache(cacheName, (Configuration)new MutableConfiguration());
    }
}

