/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation.solder;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.jcache.annotation.solder.Types;

public class Reflections {
    public static final Type[] EMPTY_TYPES = new Type[0];

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static Set<Field> getAllDeclaredFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Field a : c.getDeclaredFields()) {
                fields.add(a);
            }
        }
        return fields;
    }

    public static Set<Method> getAllDeclaredMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method a : c.getDeclaredMethods()) {
                methods.add(a);
            }
        }
        return methods;
    }

    public static boolean isAssignableFrom(Class<?> rawType1, Type[] actualTypeArguments1, Class<?> rawType2, Type[] actualTypeArguments2) {
        return Types.boxedClass(rawType1).isAssignableFrom(Types.boxedClass(rawType2)) && Reflections.isAssignableFrom(actualTypeArguments1, actualTypeArguments2);
    }

    public static boolean isAssignableFrom(Type[] actualTypeArguments1, Type[] actualTypeArguments2) {
        for (int i = 0; i < actualTypeArguments1.length; ++i) {
            Type type1 = actualTypeArguments1[i];
            Object type2 = Object.class;
            if (actualTypeArguments2.length > i) {
                type2 = actualTypeArguments2[i];
            }
            if (Reflections.isAssignableFrom(type1, type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignableFrom(Type type1, Type[] types2) {
        for (Type type2 : types2) {
            if (!Reflections.isAssignableFrom(type1, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type type1, Type type2) {
        TypeVariable typeVariable;
        WildcardType wildcardType;
        ParameterizedType parameterizedType1;
        Class clazz;
        if (type1 instanceof Class && Reflections.isAssignableFrom(clazz = (Class)type1, EMPTY_TYPES, type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType && (parameterizedType1 = (ParameterizedType)type1).getRawType() instanceof Class && Reflections.isAssignableFrom((Class)parameterizedType1.getRawType(), parameterizedType1.getActualTypeArguments(), type2)) {
            return true;
        }
        if (type1 instanceof WildcardType && Reflections.isTypeBounded(type2, (wildcardType = (WildcardType)type1).getLowerBounds(), wildcardType.getUpperBounds())) {
            return true;
        }
        if (type2 instanceof WildcardType && Reflections.isTypeBounded(type1, (wildcardType = (WildcardType)type2).getUpperBounds(), wildcardType.getLowerBounds())) {
            return true;
        }
        if (type1 instanceof TypeVariable && Reflections.isTypeBounded(type2, EMPTY_TYPES, (typeVariable = (TypeVariable)type1).getBounds())) {
            return true;
        }
        return type2 instanceof TypeVariable && Reflections.isTypeBounded(type1, (typeVariable = (TypeVariable)type2).getBounds(), EMPTY_TYPES);
    }

    public static boolean isTypeBounded(Type type, Type[] lowerBounds, Type[] upperBounds) {
        if (lowerBounds.length > 0 && !Reflections.isAssignableFrom(type, lowerBounds)) {
            return false;
        }
        return upperBounds.length <= 0 || Reflections.isAssignableFrom(upperBounds, type);
    }

    public static boolean isAssignableFrom(Class<?> rawType1, Type[] actualTypeArguments1, Type type2) {
        TypeVariable typeVariable;
        Class clazz;
        ParameterizedType parameterizedType;
        return type2 instanceof ParameterizedType ? (parameterizedType = (ParameterizedType)type2).getRawType() instanceof Class && Reflections.isAssignableFrom(rawType1, actualTypeArguments1, (Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments()) : (type2 instanceof Class ? Reflections.isAssignableFrom(rawType1, actualTypeArguments1, clazz = (Class)type2, EMPTY_TYPES) : type2 instanceof TypeVariable && Reflections.isTypeBounded(rawType1, actualTypeArguments1, (typeVariable = (TypeVariable)type2).getBounds()));
    }

    public static boolean isAssignableFrom(Type[] types1, Type type2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, type2)) continue;
            return true;
        }
        return false;
    }
}

