/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.Expiration;
import org.infinispan.jcache.JCacheInternalMetadata;
import org.infinispan.jcache.logging.Log;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

public class JCacheLoaderAdapter<K, V>
implements CacheLoader {
    private static final Log log = (Log)LogFactory.getLog(JCacheLoaderAdapter.class, Log.class);
    private javax.cache.integration.CacheLoader<K, V> delegate;
    private InitializationContext ctx;
    private ExpiryPolicy expiryPolicy;

    public void setCacheLoader(javax.cache.integration.CacheLoader<K, V> delegate) {
        this.delegate = delegate;
    }

    public void setExpiryPolicy(ExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
    }

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
    }

    public MarshalledEntry load(Object key) throws PersistenceException {
        V value = this.loadKey(key);
        if (value != null) {
            Duration expiry = Expiration.getExpiry(this.expiryPolicy, Expiration.Operation.CREATION);
            long now = this.ctx.getTimeService().wallClockTime();
            if (expiry.isEternal()) {
                return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(value, value, null);
            }
            JCacheInternalMetadata meta = new JCacheInternalMetadata(now, expiry.getTimeUnit().toMillis(expiry.getDurationAmount()));
            return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(value, value, (InternalMetadata)meta);
        }
        return null;
    }

    private V loadKey(Object key) {
        try {
            return (V)this.delegate.load(key);
        }
        catch (Exception e) {
            throw Exceptions.launderCacheLoaderException(e);
        }
    }

    public void start() throws PersistenceException {
    }

    public void stop() throws PersistenceException {
    }

    public boolean contains(Object key) {
        return this.load(key) != null;
    }
}

