/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.concurrent.jdk8backported.LongAdder;

public class InMemoryJCacheLoader<K, V>
implements CacheLoader<K, V> {
    private final ConcurrentMap<K, V> store = CollectionFactory.makeConcurrentMap();
    private final LongAdder counter = new LongAdder();

    public InMemoryJCacheLoader<K, V> store(K key, V value) {
        this.store.put(key, value);
        return this;
    }

    public V load(K key) throws CacheLoaderException {
        Object value = this.store.get(key);
        if (value != null) {
            this.counter.increment();
        }
        return value;
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) throws CacheLoaderException {
        HashMap<K, V> values = new HashMap<K, V>();
        for (K key : keys) {
            values.put(key, this.load(key));
        }
        return values;
    }

    public long getLoadCount() {
        return this.counter.longValue();
    }
}

