/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.GeneratedCacheKey;
import javax.interceptor.InvocationContext;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextFactory;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextImpl;
import org.infinispan.jcache.logging.Log;

public abstract class AbstractCacheResultInterceptor
implements Serializable {
    protected final boolean trace = this.getLog().isTraceEnabled();
    private static final long serialVersionUID = 5275055951121834315L;
    private final CacheResolver cacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    public AbstractCacheResultInterceptor(CacheResolver cacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.cacheResolver = cacheResolver;
        this.contextFactory = contextFactory;
    }

    public Object cacheResult(InvocationContext invocationContext) throws Exception {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Interception of method named '%s'", (Object)invocationContext.getMethod().getName());
        }
        CacheKeyInvocationContext cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheKeyGenerator cacheKeyGenerator = ((CacheKeyInvocationContextImpl)cacheKeyInvocationContext.unwrap(CacheKeyInvocationContextImpl.class)).getCacheKeyGenerator();
        CacheResult cacheResult = (CacheResult)cacheKeyInvocationContext.getCacheAnnotation();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        Cache cache = this.cacheResolver.resolveCache(cacheKeyInvocationContext);
        Object result = null;
        if (!cacheResult.skipGet()) {
            result = cache.get((Object)cacheKey);
            if (this.trace) {
                this.getLog().tracef("Entry with value '%s' has been found in cache '%s' with key '%s'", result, (Object)cache.getName(), (Object)cacheKey);
            }
        }
        if (result == null && (result = invocationContext.proceed()) != null) {
            cache.put((Object)cacheKey, result);
            if (this.trace) {
                this.getLog().tracef("Value '%s' cached in cache '%s' with key '%s'", result, (Object)cache.getName(), (Object)cacheKey);
            }
        }
        return result;
    }

    protected abstract Log getLog();
}

