/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CompletionListener;
import javax.cache.management.CacheStatisticsMXBean;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.management.MBeanServer;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.AbstractJCacheListenerAdapter;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.JCacheEntry;
import org.infinispan.jcache.MutableJCacheEntry;
import org.infinispan.jcache.embedded.ConfigurationAdapter;
import org.infinispan.jcache.embedded.JCacheLoaderAdapter;
import org.infinispan.jcache.embedded.JCacheNotifier;
import org.infinispan.jcache.embedded.JCacheWriterAdapter;
import org.infinispan.jcache.embedded.RICacheStatistics;
import org.infinispan.jcache.embedded.logging.Log;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerImpl;
import org.infinispan.util.concurrent.locks.impl.LockContainer;
import org.infinispan.util.concurrent.locks.impl.PerKeyLockContainer;
import org.infinispan.util.logging.LogFactory;

public class JCache<K, V>
extends AbstractJCache<K, V> {
    private static final Log log = (Log)LogFactory.getLog(JCache.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final AdvancedCache<K, V> cache;
    private final AdvancedCache<K, V> ignoreReturnValuesCache;
    private final AdvancedCache<K, V> skipCacheLoadCache;
    private final AdvancedCache<K, V> skipCacheLoadAndStatsCache;
    private final AdvancedCache<K, V> skipListenerCache;
    private final AdvancedCache<K, V> skipStatisticsCache;
    private final RICacheStatistics stats;
    private final LockContainer processorLocks;
    private final long lockTimeout;

    public JCache(AdvancedCache<K, V> cache, CacheManager cacheManager, ConfigurationAdapter<K, V> c) {
        super(c.getConfiguration(), cacheManager, new JCacheNotifier());
        this.cache = cache;
        this.processorLocks = new PerKeyLockContainer(32, cache.getCacheConfiguration().dataContainer().keyEquivalence());
        ((PerKeyLockContainer)this.processorLocks).inject(cache.getComponentRegistry().getTimeService());
        this.ignoreReturnValuesCache = cache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
        this.skipCacheLoadCache = cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD});
        this.skipCacheLoadAndStatsCache = cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_STATISTICS});
        this.skipListenerCache = cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION});
        this.skipStatisticsCache = cache.withFlags(new Flag[]{Flag.SKIP_STATISTICS});
        this.stats = new RICacheStatistics(this.cache);
        this.lockTimeout = cache.getCacheConfiguration().locking().lockAcquisitionTimeout();
        this.addConfigurationListeners();
        this.setCacheLoader((CompleteConfiguration)this.configuration);
        this.setCacheWriter((CompleteConfiguration)this.configuration);
        if (this.configuration.isManagementEnabled()) {
            this.setManagementEnabled(true);
        }
        if (this.configuration.isStatisticsEnabled()) {
            this.setStatisticsEnabled(true);
        }
    }

    protected void addCacheLoaderAdapter(CacheLoader<K, V> cacheLoader) {
        PersistenceManagerImpl persistenceManager = (PersistenceManagerImpl)this.cache.getComponentRegistry().getComponent(PersistenceManager.class);
        JCacheLoaderAdapter<K, V> adapter = this.getCacheLoaderAdapter(persistenceManager);
        adapter.setCacheLoader(this.jcacheLoader);
        adapter.setExpiryPolicy(this.expiryPolicy);
    }

    protected void addCacheWriterAdapter(CacheWriter<? super K, ? super V> cacheWriter) {
        PersistenceManagerImpl persistenceManager = (PersistenceManagerImpl)this.cache.getComponentRegistry().getComponent(PersistenceManager.class);
        JCacheWriterAdapter<K, V> ispnCacheStore = this.getCacheWriterAdapter(persistenceManager);
        ispnCacheStore.setCacheWriter(this.jcacheWriter);
    }

    private JCacheLoaderAdapter<K, V> getCacheLoaderAdapter(PersistenceManagerImpl persistenceManager) {
        return (JCacheLoaderAdapter)persistenceManager.getAllLoaders().get(0);
    }

    private JCacheWriterAdapter<K, V> getCacheWriterAdapter(PersistenceManagerImpl persistenceManager) {
        return (JCacheWriterAdapter)persistenceManager.getAllWriters().get(0);
    }

    public void clear() {
        this.skipListenerCache.clear();
    }

    public boolean containsKey(final K key) {
        this.checkNotClosed();
        if (trace) {
            log.tracef("Invoke containsKey(key=%s)", key);
        }
        if (key == null) {
            throw log.parameterMustNotBeNull("key");
        }
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.skipCacheLoadCache.containsKey(key);
                }
            });
        }
        return this.skipCacheLoadAndStatsCache.containsKey(key);
    }

    public V get(final K key) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.doGet(key);
                }
            });
        }
        return this.doGet(key);
    }

    private V doGet(K key) {
        Object value;
        Object object = value = this.configuration.isReadThrough() ? this.cache.get(key) : this.skipCacheLoadCache.get(key);
        if (value != null) {
            this.updateTTLForAccessed((BasicCache)this.cache, key, value);
        }
        return (V)value;
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkNotClosed();
        this.verifyKeys(keys);
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        AdvancedCache<K, V> cache = this.configuration.isReadThrough() ? this.cache : this.skipCacheLoadCache;
        return cache.getAll(keys);
    }

    public V getAndPut(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.put((BasicCache)JCache.this.skipCacheLoadCache, (BasicCache)JCache.this.skipCacheLoadCache, key, value, false);
                }
            });
        }
        return (V)this.put((BasicCache)this.skipCacheLoadCache, (BasicCache)this.skipCacheLoadCache, key, value, false);
    }

    public V getAndRemove(final K key) {
        this.checkNotClosed();
        this.skipCacheLoadCache.get(key);
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.skipCacheLoadCache.remove(key);
                }
            });
        }
        return (V)this.skipCacheLoadCache.remove(key);
    }

    public V getAndReplace(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.replace((BasicCache)JCache.this.skipCacheLoadCache, key, value);
                }
            });
        }
        return (V)this.replace((BasicCache)this.skipCacheLoadCache, key, value);
    }

    public void close() {
        this.cache.stop();
    }

    public boolean isClosed() {
        return this.cache.getStatus().isTerminated();
    }

    public String getName() {
        return this.cache.getName();
    }

    public <T> T invoke(final K key, final EntryProcessor<K, V, T> entryProcessor, final Object ... arguments) {
        this.checkNotClosed().checkNotNull(key, "key").checkNotNull(entryProcessor, "entryProcessor");
        if (trace) {
            log.tracef("Invoke entry processor %s for key=%s", entryProcessor, key);
        }
        return (T)new WithProcessorLock().call(key, new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object oldValue;
                Object safeOldValue = oldValue = JCache.this.skipCacheLoadCache.get(key);
                if (JCache.this.configuration.isStoreByValue()) {
                    safeOldValue = JCache.this.safeCopy(oldValue);
                }
                MutableJCacheEntry mutable = JCache.this.createMutableCacheEntry(safeOldValue, key);
                Object ret = JCache.this.processEntryProcessor(mutable, entryProcessor, arguments);
                switch (mutable.getOperation()) {
                    case NONE: {
                        break;
                    }
                    case ACCESS: {
                        JCache.this.updateTTLForAccessed((BasicCache)JCache.this.cache, key, oldValue);
                        break;
                    }
                    case UPDATE: {
                        Object newValue = mutable.getNewValue();
                        if (oldValue != null) {
                            JCache.this.replace((BasicCache)JCache.this.cache, (BasicCache)JCache.this.skipCacheLoadAndStatsCache, key, oldValue, newValue, true);
                            break;
                        }
                        JCache.this.put((BasicCache)JCache.this.cache, (BasicCache)JCache.this.skipCacheLoadCache, key, newValue, true);
                        break;
                    }
                    case REMOVE: {
                        JCache.this.cache.remove(key);
                        break;
                    }
                }
                return ret;
            }
        });
    }

    private MutableJCacheEntry<K, V> createMutableCacheEntry(V safeOldValue, K key) {
        return new MutableJCacheEntry(this.configuration.isReadThrough() ? this.cache : this.skipCacheLoadCache, this.skipStatisticsCache, key, safeOldValue);
    }

    private V safeCopy(V original) {
        try {
            StreamingMarshaller marshaller = this.skipCacheLoadCache.getComponentRegistry().getCacheMarshaller();
            byte[] bytes = marshaller.objectToByteBuffer(original);
            Object o = marshaller.objectFromByteBuffer(bytes);
            return (V)o;
        }
        catch (Exception e) {
            throw new CacheException("Unexpected error making a copy of entry " + original, (Throwable)e);
        }
    }

    private boolean lockRequired(K key) {
        boolean locked = this.processorLocks.isLocked(key);
        if (trace) {
            log.tracef("Lock required for key=%s? %s", key, locked);
        }
        return locked;
    }

    private void acquiredProcessorLock(K key) throws InterruptedException {
        this.processorLocks.acquire(key, (Object)Thread.currentThread(), this.lockTimeout, TimeUnit.MILLISECONDS);
    }

    private void releaseProcessorLock(K key) {
        this.processorLocks.release(key, (Object)Thread.currentThread());
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        if (this.isClosed()) {
            throw log.cacheClosed(this.cache.getStatus());
        }
        return new Itr();
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener listener) {
        this.checkNotClosed();
        if (keys == null) {
            throw log.parameterMustNotBeNull("keys");
        }
        if (this.jcacheLoader == null && this.jcacheWriter != null) {
            this.setListenerCompletion(listener);
        } else if (this.jcacheLoader != null) {
            this.loadAllFromJCacheLoader(keys, replaceExistingValues, listener, (BasicCache)this.ignoreReturnValuesCache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}), (BasicCache)this.skipCacheLoadCache);
        } else {
            this.loadAllFromInfinispanCacheLoader(keys, replaceExistingValues, listener);
        }
    }

    public void put(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            new WithProcessorLock<Void>().call(key, new Callable<Void>(){

                @Override
                public Void call() {
                    JCache.this.doPut(key, value);
                    return null;
                }
            });
        } else {
            this.doPut(key, value);
        }
    }

    public void putAll(Map<? extends K, ? extends V> inputMap) {
        this.checkNotClosed();
        InfinispanCollections.assertNotNullEntries(inputMap, (String)"inputMap");
        for (final Map.Entry<K, V> e : inputMap.entrySet()) {
            final K key = e.getKey();
            if (this.lockRequired(key)) {
                new WithProcessorLock<Void>().call(key, new Callable<Void>(){

                    @Override
                    public Void call() {
                        JCache.this.doPut(key, e.getValue());
                        return null;
                    }
                });
                continue;
            }
            this.doPut(key, e.getValue());
        }
    }

    private void doPut(K key, V value) {
        this.put((BasicCache)this.ignoreReturnValuesCache, (BasicCache)this.skipCacheLoadAndStatsCache, key, value, false);
    }

    public boolean putIfAbsent(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.put((BasicCache)JCache.this.skipCacheLoadCache, (BasicCache)JCache.this.skipCacheLoadAndStatsCache, key, value, true) == null;
                }
            });
        }
        return this.put((BasicCache)this.skipCacheLoadCache, (BasicCache)this.skipCacheLoadAndStatsCache, key, value, true) == null;
    }

    public boolean remove(final K key) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.cache.remove(key) != null;
                }
            });
        }
        try {
            return this.cache.remove(key) != null;
        }
        catch (CacheListenerException e) {
            throw Exceptions.launderCacheListenerException((CacheListenerException)e);
        }
    }

    public boolean remove(final K key, final V oldValue) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.remove((BasicCache)JCache.this.cache, key, oldValue);
                }
            });
        }
        return this.remove((BasicCache)this.cache, key, oldValue);
    }

    public void removeAll() {
        if (this.isClosed()) {
            throw log.cacheClosed(this.cache.getStatus());
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (final Object e : this.cache.keySet()) {
            if (this.lockRequired(e)) {
                new WithProcessorLock<Void>().call(e, new Callable<Void>(){

                    @Override
                    public Void call() {
                        JCache.this.cache.remove(e);
                        return null;
                    }
                });
                continue;
            }
            futures.add(this.cache.removeAsync(e));
        }
        for (Future future : futures) {
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CacheException("Interrupted while waiting for remove to complete");
            }
            catch (Exception e) {
                throw Exceptions.launderCacheWriterException((Exception)e);
            }
        }
    }

    public void removeAll(Set<? extends K> keys) {
        this.checkNotClosed();
        this.verifyKeys(keys);
        for (K k : keys) {
            this.remove(k);
        }
    }

    public boolean replace(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.replace((BasicCache)JCache.this.skipCacheLoadCache, (BasicCache)JCache.this.skipCacheLoadCache, key, null, value, false);
                }
            });
        }
        return this.replace((BasicCache)this.skipCacheLoadCache, (BasicCache)this.skipCacheLoadCache, key, null, value, false);
    }

    public boolean replace(final K key, final V oldValue, final V newValue) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.replace((BasicCache)JCache.this.skipCacheLoadCache, (BasicCache)JCache.this.skipCacheLoadCache, key, oldValue, newValue, true);
                }
            });
        }
        return this.replace((BasicCache)this.skipCacheLoadCache, (BasicCache)this.skipCacheLoadCache, key, oldValue, newValue, true);
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrapAny(clazz, (Object[])new Object[]{this, this.cache});
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        this.notifier.addListener(listenerCfg, (AbstractJCache)this, this.notifier);
        this.addCacheEntryListenerConfiguration(listenerCfg);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        this.notifier.removeListener(listenerCfg, (AbstractJCache)this);
        this.removeCacheEntryListenerConfiguration(listenerCfg);
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.cache.getStats().setStatisticsEnabled(enabled);
        super.setStatisticsEnabled(enabled);
    }

    protected CacheStatisticsMXBean getCacheStatisticsMXBean() {
        return this.stats;
    }

    protected MBeanServer getMBeanServer() {
        return JmxUtil.lookupMBeanServer((GlobalConfiguration)this.cache.getCacheManager().getCacheManagerConfiguration());
    }

    protected AbstractJCache<K, V> checkNotClosed() {
        if (this.isClosed()) {
            throw log.cacheClosed(this.cache.getStatus());
        }
        return this;
    }

    private void loadAllFromInfinispanCacheLoader(Set<? extends K> keys, boolean replaceExistingValues, final CompletionListener listener) {
        final List keysToLoad = this.filterLoadAllKeys(keys, replaceExistingValues, true);
        if (keysToLoad.isEmpty()) {
            this.setListenerCompletion(listener);
            return;
        }
        try {
            CyclicBarrier barrier = new CyclicBarrier(keysToLoad.size(), new Runnable(){

                @Override
                public void run() {
                    if (trace) {
                        log.tracef("Keys %s loaded, notify listener on completion", keysToLoad);
                    }
                    JCache.this.setListenerCompletion(listener);
                }
            });
            AdvancedCache<K, V> asyncCache = this.cache;
            for (Object k : keysToLoad) {
                asyncCache.getAsync(k).whenComplete((v, t) -> {
                    if (t != null) {
                        this.setListenerException(listener, (Throwable)t);
                    }
                    try {
                        if (trace) {
                            log.tracef("Key loaded, wait for the rest of keys to load", new Object[0]);
                        }
                        barrier.await(30L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (BrokenBarrierException e) {
                        this.setListenerException(listener, e);
                    }
                    catch (TimeoutException e) {
                        this.setListenerException(listener, e);
                    }
                });
            }
        }
        catch (Throwable t2) {
            log.errorLoadingAll(keysToLoad, t2);
            this.setListenerException(listener, t2);
        }
    }

    protected void addListener(AbstractJCacheListenerAdapter<K, V> listenerAdapter) {
        this.cache.addListener(listenerAdapter);
    }

    protected void removeListener(AbstractJCacheListenerAdapter<K, V> listenerAdapter) {
        this.cache.removeListener(listenerAdapter);
    }

    protected void evict(K key) {
        this.cache.evict(key);
    }

    private class Itr
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> it;
        private Cache.Entry<K, V> current;
        private Cache.Entry<K, V> next;

        Itr() {
            this.it = JCache.this.cache.entrySet().iterator();
            this.fetchNext();
        }

        private void fetchNext() {
            long start;
            long l = start = JCache.this.statisticsEnabled() ? System.nanoTime() : 0L;
            if (this.it.hasNext()) {
                Map.Entry entry = this.it.next();
                this.next = new JCacheEntry(entry.getKey(), entry.getValue());
                if (JCache.this.statisticsEnabled()) {
                    JCache.this.stats.increaseCacheHits(1L);
                    JCache.this.stats.addGetTimeNano(System.nanoTime() - start);
                }
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (this.next == null) {
                this.fetchNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Cache.Entry ret = this.next;
            JCache.this.updateTTLForAccessed((BasicCache)JCache.this.cache, this.next.getKey(), this.next.getValue());
            this.current = this.next;
            this.fetchNext();
            return ret;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object k = this.current.getKey();
            this.current = null;
            JCache.this.cache.remove(k);
        }
    }

    private class WithProcessorLock<V> {
        private WithProcessorLock() {
        }

        public V call(K key, Callable<V> callable) {
            try {
                JCache.this.acquiredProcessorLock(key);
                V v = callable.call();
                return v;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                V v = null;
                return v;
            }
            catch (CacheListenerException e) {
                throw Exceptions.launderCacheListenerException((CacheListenerException)e);
            }
            catch (EntryProcessorException e) {
                throw e;
            }
            catch (CacheException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EntryProcessorException((Throwable)e);
            }
            finally {
                JCache.this.releaseProcessorLock(key);
            }
        }
    }
}

