/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.profiling.LuceneUserThread;
import org.infinispan.lucene.profiling.SharedState;
import org.infinispan.lucene.testutils.ClusteredCacheFactory;
import org.infinispan.lucene.testutils.LuceneSettings;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.profiling.IndexReadingStressTest", sequential=true)
public class IndexReadingStressTest {
    private static final int THREADS = 5;
    private static final long DURATION_MS = 350000L;
    private static final int TERMS_NUMBER = 200000;
    private static final String indexName = "tempIndexName";
    private static final ClusteredCacheFactory cacheFactory = new ClusteredCacheFactory(CacheTestSupport.createTestConfiguration());

    @Test
    public void profileTestRAMDirectory() throws InterruptedException, IOException {
        RAMDirectory dir = new RAMDirectory();
        this.testDirectory((Directory)dir, "RAMDirectory");
    }

    @Test
    public void profileTestFSDirectory() throws InterruptedException, IOException {
        File indexDir = new File(new File("."), indexName);
        boolean directoriesCreated = indexDir.mkdirs();
        assert (directoriesCreated) : "couldn't create directory for FSDirectory test";
        FSDirectory dir = FSDirectory.open((File)indexDir);
        this.testDirectory((Directory)dir, "FSDirectory");
    }

    @Test
    public void profileTestInfinispanDirectory() throws InterruptedException, IOException {
        Cache cache = cacheFactory.createClusteredCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, "iname");
        this.testDirectory((Directory)dir, "InfinispanClustered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void profileInfinispanLocalDirectory() throws InterruptedException, IOException {
        CacheContainer cacheManager = CacheTestSupport.createLocalCacheManager();
        try {
            Cache cache = cacheManager.getCache();
            InfinispanDirectory dir = new InfinispanDirectory(cache, "iname");
            this.testDirectory((Directory)dir, "InfinispanLocal");
        }
        finally {
            cacheManager.stop();
        }
    }

    private void testDirectory(Directory dir, String testLabel) throws InterruptedException, IOException {
        SharedState state = IndexReadingStressTest.fillDirectory(dir, 200000);
        ExecutorService e = Executors.newFixedThreadPool(5);
        for (int i = 0; i < 5; ++i) {
            e.execute(new IndependentLuceneReaderThread(dir, state, i, 1, 200000));
        }
        e.shutdown();
        state.startWaitingThreads();
        Thread.sleep(350000L);
        long searchesCount = state.incrementIndexSearchesCount(0L);
        long writerTaskCount = state.incrementIndexWriterTaskCount(0L);
        state.quit();
        e.awaitTermination(10L, TimeUnit.SECONDS);
        System.out.println("Test " + testLabel + " run in " + 350000L + "ms:\n\tSearches: " + searchesCount + "\n\t" + "Writes: " + writerTaskCount);
    }

    static SharedState fillDirectory(Directory directory, int termsNumber) throws CorruptIndexException, LockObtainFailedException, IOException {
        CacheTestSupport.initializeDirectory(directory);
        SharedState state = new SharedState(0);
        IndexWriter iwriter = LuceneSettings.openWriter(directory, 100000);
        for (int i = 0; i <= termsNumber; ++i) {
            Document doc = new Document();
            String term = String.valueOf(i);
            if (i % 2 == 0) {
                doc.add((Fieldable)new Field("main", term, Field.Store.NO, Field.Index.NOT_ANALYZED));
                state.addStringWrittenToIndex(term);
            } else {
                doc.add((Fieldable)new Field("secondaryField", term, Field.Store.NO, Field.Index.NOT_ANALYZED));
            }
            iwriter.addDocument(doc);
        }
        iwriter.commit();
        iwriter.close();
        return state;
    }

    @BeforeClass
    public static void beforeTest() {
        cacheFactory.start();
    }

    @AfterClass(alwaysRun=true)
    public static void afterTest() {
        cacheFactory.stop();
        TestingUtil.recursiveFileRemove((String)indexName);
    }

    private static class IndependentLuceneReaderThread
    extends LuceneUserThread {
        private final int startValue;
        private final int increment;
        private final int max;
        private final IndexReader indexReader;
        private final IndexSearcher searcher;

        IndependentLuceneReaderThread(Directory dir, SharedState state, int startValue, int increment, int max) throws CorruptIndexException, IOException {
            super(dir, state);
            this.startValue = startValue;
            this.increment = increment;
            this.max = max;
            this.indexReader = IndexReader.open((Directory)this.directory, (boolean)true);
            this.searcher = new IndexSearcher(this.indexReader);
        }

        @Override
        protected void testLoop() throws IOException {
            Term t = new Term("main", "0");
            for (int i = this.startValue; i <= this.max && !this.state.needToQuit(); i += this.increment) {
                Term termToQuery = t.createTerm(Integer.toString(i));
                TermQuery query = new TermQuery(termToQuery);
                TopDocs docs = this.searcher.search((Query)query, null, 1);
                if (i % 2 == 0 && docs.totalHits != 1) {
                    throw new RuntimeException("String '" + String.valueOf(i) + "' should exist but was not found in index");
                }
                if (i % 2 == 1 && docs.totalHits != 0) {
                    throw new RuntimeException("String '" + String.valueOf(i) + "' should NOT exist but was found in index");
                }
                this.state.incrementIndexSearchesCount(1L);
            }
        }

        @Override
        protected void cleanup() throws IOException {
            this.indexReader.close();
        }
    }
}

