/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cachestore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.KeyVisitor;
import org.infinispan.lucene.logging.Log;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.logging.LogFactory;

final class DirectoryLoaderAdaptor {
    private static final Log log = (Log)LogFactory.getLog(DirectoryLoaderAdaptor.class, Log.class);
    private final Directory directory;
    private final LoadVisitor loadVisitor = new LoadVisitor();
    private final ContainsKeyVisitor containsKeyVisitor = new ContainsKeyVisitor();
    private final String indexName;
    private final int autoChunkSize;

    protected DirectoryLoaderAdaptor(Directory directory, String indexName, int autoChunkSize) {
        this.directory = directory;
        this.indexName = indexName;
        this.autoChunkSize = autoChunkSize;
    }

    protected void loadAllEntries(HashSet<InternalCacheEntry> entriesCollector, int maxEntries) throws CacheLoaderException {
        int existingElements = entriesCollector.size();
        int toLoadElements = maxEntries - existingElements;
        if (toLoadElements <= 0) {
            return;
        }
        HashSet<IndexScopedKey> keysCollector = new HashSet<IndexScopedKey>(toLoadElements);
        this.loadSomeKeys(keysCollector, Collections.EMPTY_SET, toLoadElements);
        for (IndexScopedKey key : keysCollector) {
            Object value = this.load(key);
            if (value == null) continue;
            ImmortalCacheEntry cacheEntry = new ImmortalCacheEntry((Object)key, value);
            entriesCollector.add((InternalCacheEntry)cacheEntry);
        }
    }

    private void loadSomeKeys(HashSet<IndexScopedKey> keysCollector, Set<IndexScopedKey> keysToExclude, int maxElements) throws CacheLoaderException {
        if (maxElements <= 0) {
            return;
        }
        int collectedKeys = 0;
        FileListCacheKey rootKey = new FileListCacheKey(this.indexName);
        if (!keysToExclude.contains(rootKey) && keysCollector.add(rootKey)) {
            ++collectedKeys;
        }
        try {
            String[] listAll;
            for (String fileName : listAll = this.directory.listAll()) {
                if (collectedKeys >= maxElements) {
                    return;
                }
                FileCacheKey key = new FileCacheKey(this.indexName, fileName);
                if (keysToExclude.contains(key) || !keysCollector.add(key) || ++collectedKeys < maxElements) continue;
                return;
            }
            for (String fileName : listAll) {
                int numChunksInt = this.figureChunksNumber(fileName);
                for (int i = 0; i < numChunksInt; ++i) {
                    ChunkCacheKey key = new ChunkCacheKey(this.indexName, fileName, i, this.autoChunkSize);
                    if (keysToExclude.contains(key) || !keysCollector.add(key) || ++collectedKeys < maxElements) continue;
                    return;
                }
            }
        }
        catch (IOException e) {
            throw log.exceptionInCacheLoader(e);
        }
    }

    private int figureChunksNumber(String fileName) throws IOException {
        long fileLength = this.directory.fileLength(fileName);
        return DirectoryLoaderAdaptor.figureChunksNumber(fileName, fileLength, this.autoChunkSize);
    }

    private static int figureChunksNumber(String fileName, long fileLength, int chunkSize) {
        if (chunkSize < 0) {
            throw new IllegalStateException("Overflow in rescaling chunkSize. File way too large?");
        }
        long numChunks = fileLength / (long)chunkSize;
        if (numChunks > Integer.MAX_VALUE) {
            log.rescalingChunksize(fileName, fileLength, chunkSize);
            chunkSize = 32 * chunkSize;
            return DirectoryLoaderAdaptor.figureChunksNumber(fileName, fileLength, chunkSize);
        }
        return (int)numChunks;
    }

    protected void loadAllKeys(HashSet<IndexScopedKey> keysCollector, Set<IndexScopedKey> keysToExclude) throws CacheLoaderException {
        this.loadSomeKeys(keysCollector, keysToExclude, Integer.MAX_VALUE);
    }

    protected void close() {
        try {
            this.directory.close();
        }
        catch (IOException e) {
            log.errorOnFSDirectoryClose(e);
        }
    }

    protected Object load(IndexScopedKey key) throws CacheLoaderException {
        try {
            return key.accept(this.loadVisitor);
        }
        catch (Exception e) {
            throw log.exceptionInCacheLoader(e);
        }
    }

    protected boolean containsKey(IndexScopedKey key) throws CacheLoaderException {
        try {
            Boolean returnValue = key.accept(this.containsKeyVisitor);
            return returnValue;
        }
        catch (Exception e) {
            throw log.exceptionInCacheLoader(e);
        }
    }

    private Object loadIntern(FileListCacheKey key) throws IOException {
        String[] listAll = this.directory.listAll();
        ConcurrentHashSet fileNames = new ConcurrentHashSet();
        for (String filename : listAll) {
            fileNames.add((Object)filename);
        }
        return fileNames;
    }

    private FileMetadata loadIntern(FileCacheKey key) throws IOException {
        String fileName = key.getFileName();
        long fileModified = this.directory.fileModified(fileName);
        long fileLength = this.directory.fileLength(fileName);
        FileMetadata meta = new FileMetadata((int)fileLength);
        meta.setLastModified(fileModified);
        meta.setSize(fileLength);
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadIntern(ChunkCacheKey key) throws IOException {
        byte[] buffer;
        String fileName = key.getFileName();
        int chunkId = key.getChunkId();
        int bufferSize = key.getBufferSize();
        int seekTo = chunkId * bufferSize;
        IndexInput input = this.directory.openInput(fileName);
        int length = (int)input.length();
        try {
            if (seekTo != 0) {
                input.seek((long)seekTo);
            }
            bufferSize = Math.min(length - seekTo, bufferSize);
            buffer = new byte[bufferSize];
            input.readBytes(buffer, 0, bufferSize);
        }
        finally {
            input.close();
        }
        return buffer;
    }

    private Boolean containsKeyIntern(ChunkCacheKey chunkCacheKey) throws IOException {
        try {
            long length = this.directory.fileLength(chunkCacheKey.getFileName());
            int bufferSize = chunkCacheKey.getBufferSize();
            int chunkId = chunkCacheKey.getChunkId();
            return (long)(chunkId * bufferSize) < length + (long)bufferSize;
        }
        catch (FileNotFoundException nfne) {
            return Boolean.FALSE;
        }
    }

    protected Boolean containsKeyIntern(FileCacheKey fileCacheKey) throws IOException {
        return this.directory.fileExists(fileCacheKey.getFileName());
    }

    private final class ContainsKeyVisitor
    implements KeyVisitor<Boolean> {
        private ContainsKeyVisitor() {
        }

        @Override
        public Boolean visit(FileListCacheKey fileListCacheKey) throws IOException {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(ChunkCacheKey chunkCacheKey) throws IOException {
            return DirectoryLoaderAdaptor.this.containsKeyIntern(chunkCacheKey);
        }

        @Override
        public Boolean visit(FileCacheKey fileCacheKey) throws IOException {
            return DirectoryLoaderAdaptor.this.containsKeyIntern(fileCacheKey);
        }

        @Override
        public Boolean visit(FileReadLockKey fileReadLockKey) {
            return Boolean.FALSE;
        }
    }

    private final class LoadVisitor
    implements KeyVisitor {
        private LoadVisitor() {
        }

        public Object visit(FileListCacheKey fileListCacheKey) throws IOException {
            return DirectoryLoaderAdaptor.this.loadIntern(fileListCacheKey);
        }

        public Object visit(ChunkCacheKey chunkCacheKey) throws IOException {
            return DirectoryLoaderAdaptor.this.loadIntern(chunkCacheKey);
        }

        public Object visit(FileCacheKey fileCacheKey) throws IOException {
            return DirectoryLoaderAdaptor.this.loadIntern(fileCacheKey);
        }

        public Object visit(FileReadLockKey fileReadLockKey) {
            return null;
        }
    }
}

