/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;

public final class CompletableOnErrorComplete
extends Completable {
    final CompletableSource source;
    final Predicate<? super Throwable> predicate;

    public CompletableOnErrorComplete(CompletableSource source, Predicate<? super Throwable> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(CompletableObserver s) {
        this.source.subscribe(new OnError(s));
    }

    final class OnError
    implements CompletableObserver {
        private final CompletableObserver s;

        OnError(CompletableObserver s) {
            this.s = s;
        }

        @Override
        public void onComplete() {
            this.s.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            boolean b;
            try {
                b = CompletableOnErrorComplete.this.predicate.test(e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.s.onError(new CompositeException(e, ex));
                return;
            }
            if (b) {
                this.s.onComplete();
            } else {
                this.s.onError(e);
            }
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.s.onSubscribe(d);
        }
    }
}

