/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshaller.test;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.marshaller.test.TestObject;
import org.infinispan.marshaller.test.User;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractMarshallingTest
extends AbstractInfinispanTest {
    private final List<TestObject> testObjects = IntStream.range(1, 2).boxed().map(this::getTestObject).collect(Collectors.toList());
    private final Marshaller marshaller;
    private ByteArrayOutputStream outputStream;

    protected AbstractMarshallingTest(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    @BeforeMethod(alwaysRun=true)
    protected void init() {
        this.outputStream = new ByteArrayOutputStream(1024);
    }

    @AfterMethod(alwaysRun=true)
    protected void reset() throws Exception {
        this.resetCustomerSerializerCounters();
        this.outputStream.close();
    }

    protected abstract void checkCustomSerializerCounters(int var1, int var2);

    protected abstract void resetCustomerSerializerCounters();

    protected TestObject getTestObject(int id) {
        TestObject testObject = new TestObject(id);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(id, "Test" + id);
        testObject.setMap(map);
        testObject.setList(IntStream.range(0, id).boxed().collect(Collectors.toList()));
        testObject.setUser(new User("User" + id));
        return testObject;
    }

    @Test
    protected void testObjectMarshallingTest() throws Exception {
        ArrayList<ByteBuffer> serializedObjects = new ArrayList<ByteBuffer>(this.testObjects.size());
        for (TestObject object : this.testObjects) {
            serializedObjects.add(this.marshaller.objectToBuffer((Object)object));
        }
        assert (serializedObjects.size() == this.testObjects.size());
        for (int i = 0; i < this.testObjects.size(); ++i) {
            byte[] bytes = ((ByteBuffer)serializedObjects.get(i)).getBuf();
            TestObject testObj = this.testObjects.get(i);
            Object unmarshalledObj = this.marshaller.objectFromByteBuffer(bytes);
            assert (((Object)testObj).equals(unmarshalledObj));
        }
    }

    @Test
    protected void testRegisterSerializersAreUtilised() throws Exception {
        TestObject obj = this.testObjects.get(0);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)obj);
        assert (this.marshaller.objectFromByteBuffer(bytes).equals(obj));
        this.checkCustomSerializerCounters(1, 1);
    }

    @Test
    protected void testImmutableCollections() throws Exception {
        int listSize = 10;
        TestObject obj = this.testObjects.get(0);
        obj.setList(Collections.unmodifiableList(IntStream.range(0, 10).boxed().collect(Collectors.toList())));
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)obj);
        TestObject unmarshalledObj = (TestObject)this.marshaller.objectFromByteBuffer(bytes);
        assert (unmarshalledObj.getList().size() == listSize);
        for (int i = 0; i < listSize; ++i) {
            assert (unmarshalledObj.getList().get(i) == i);
        }
    }

    @Test
    protected void testSerializingByteArrays() throws Exception {
        byte[] bytes = new byte[10];
        IntStream.range(0, 10).forEach(i -> {
            bytes[i] = (byte)i;
        });
        byte[] marshalledBytes = this.marshaller.objectToBuffer((Object)bytes).getBuf();
        byte[] unmarsalledBytes = (byte[])this.marshaller.objectFromByteBuffer(marshalledBytes);
        IntStream.range(0, 10).forEach(i -> Assert.assertEquals((int)unmarsalledBytes[i], (int)i));
    }
}

