/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.sifs.SoftIndexFileStore;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.SoftIndexFileStoreTest")
public class SoftIndexFileStoreTest
extends BaseStoreTest {
    SoftIndexFileStore store;
    String tmpDirectory;

    @BeforeClass
    protected void setUpTempDir() {
        this.tmpDirectory = TestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
    }

    @AfterClass
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove((String)this.tmpDirectory);
    }

    protected AdvancedLoadWriteStore createStore() throws Exception {
        this.clearTempDir();
        this.store = new SoftIndexFileStore();
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        ((SoftIndexFileStoreConfigurationBuilder)builder.persistence().addStore(SoftIndexFileStoreConfigurationBuilder.class)).indexLocation(this.tmpDirectory).dataLocation(this.tmpDirectory + "/data");
        this.store.init(this.createContext(builder.build()));
        this.store.start();
        return this.store;
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }

    public void testLoadUnload() {
        InternalCacheEntry ice;
        int i;
        int numEntries = 10000;
        for (i = 0; i < numEntries; ++i) {
            ice = TestInternalCacheEntryFactory.create((Object)this.key(i), (Object)("value" + i));
            this.store.write((MarshalledEntry)new MarshalledEntryImpl(ice.getKey(), ice.getValue(), PersistenceUtil.internalMetadata((InternalCacheEntry)ice), this.getMarshaller()));
        }
        System.out.println("Loaded all entries");
        for (i = 0; i < numEntries; ++i) {
            if (this.store.delete((Object)this.key(i))) continue;
            AssertJUnit.fail((String)("Key " + this.key(i) + " not found"));
        }
        this.store.clear();
        for (i = 0; i < numEntries; ++i) {
            ice = TestInternalCacheEntryFactory.create((Object)this.key(i), (Object)("value" + i));
            this.store.write((MarshalledEntry)new MarshalledEntryImpl(ice.getKey(), ice.getValue(), PersistenceUtil.internalMetadata((InternalCacheEntry)ice), this.getMarshaller()));
        }
        for (i = numEntries - 1; i >= 0; --i) {
            if (this.store.delete((Object)this.key(i))) continue;
            AssertJUnit.fail((String)("Key " + this.key(i) + " not found"));
        }
    }

    public void testStopStartAndMultipleWrites() {
        MarshalledEntry entry1 = this.marshalledEntry(this.internalCacheEntry("k1", "v1", -1L));
        MarshalledEntry entry2 = this.marshalledEntry(this.internalCacheEntry("k1", "v2", -1L));
        this.store.write(entry1);
        this.store.write(entry1);
        this.store.write(entry1);
        this.store.stop();
        this.store.start();
        AssertJUnit.assertEquals((Object)"v1", (Object)this.store.load((Object)"k1").getValue());
        this.store.write(entry2);
        this.store.stop();
        this.store.start();
        AssertJUnit.assertEquals((Object)"v2", (Object)this.store.load((Object)"k1").getValue());
    }

    private String key(int i) {
        return String.format("key%010d", i);
    }
}

