/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rhq;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheManagerDiscovery
extends MBeanResourceDiscoveryComponent<JMXComponent> {
    private static final Log log = LogFactory.getLog(CacheManagerDiscovery.class);
    protected static final String CACHE_MANAGER_OBJECTS = "*:type=CacheManager,*";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent> ctx) {
        Set<DiscoveredResourceDetails> discoveredResources;
        List manualCfgs;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Discover resources with context: %s", new Object[]{ctx});
        }
        if (!(manualCfgs = ctx.getPluginConfigurations()).isEmpty()) {
            discoveredResources = this.createDiscoveredResource(ctx, CACHE_MANAGER_OBJECTS);
            if (trace) {
                log.trace((Object)"Manually discovered resources are %s", new Object[]{discoveredResources});
            }
        } else {
            discoveredResources = this.createDiscoveredResource(ctx, CACHE_MANAGER_OBJECTS);
            if (trace) {
                log.trace((Object)"Automatically discovered resources are %s", new Object[]{discoveredResources});
            }
        }
        return discoveredResources;
    }

    private Set<DiscoveredResourceDetails> createDiscoveredResource(ResourceDiscoveryContext<JMXComponent> ctx, String objectName) {
        boolean trace = log.isTraceEnabled();
        JMXComponent parentComponent = (JMXComponent)ctx.getParentResourceComponent();
        EmsConnection conn = parentComponent.getEmsConnection();
        if (conn != null) {
            if (trace) {
                log.trace((Object)"Connection to ems server established: %s", new Object[]{conn});
            }
            ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(objectName);
            List beans = conn.queryBeans(queryUtility.getTranslatedQuery());
            if (trace) {
                log.trace((Object)"Querying [%s] returned beans: %s", new Object[]{queryUtility.getTranslatedQuery(), beans});
            }
            HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
            for (EmsBean bean : beans) {
                String managerName = bean.getBeanName().getCanonicalName();
                String resourceName = bean.getAttribute("Name").getValue().toString();
                String version = bean.getAttribute("Version").getValue().toString();
                if (trace) {
                    log.trace((Object)"Add resource with version '%s' and type %s", new Object[]{version, ctx.getResourceType()});
                }
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(ctx.getResourceType(), resourceName, resourceName, version, "A cache manager within Infinispan", null, null);
                log.info((Object)"Discovered Infinispan instance with key %s and name %s", new Object[]{resourceName, managerName});
                discoveredResources.add(detail);
            }
            return discoveredResources;
        }
        log.debug((Object)"Unable to establish connection");
        return null;
    }
}

