/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.Stoppable$;
import org.infinispan.server.hotrod.HotRodConfigurationTest$;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.UniquePortThreadLocal$;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.hotrod.HotRodConfigurationTest")
@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u0017\t9\u0002j\u001c;S_\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001[8ue>$'BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!)\u0001\u0004\u0001C\u00013\u00059B/Z:u+N,'\u000fR3gS:,G\rV5nK>,Ho\u001d\u000b\u00025A\u0011QbG\u0005\u000399\u0011A!\u00168ji\")a\u0004\u0001C\u00013\u0005!B/Z:u\u0019\u0006T\u0018\u0010T8bIR{\u0007o\u001c7pOfDQ\u0001\t\u0001\u0005\u0002e\t!\u0006^3tiJ+\u0007/Z1uC\ndWMU3bI&\u001bx\u000e\\1uS>tG*\u001a<fYZ\u000bG.\u001b3bi&|g\u000e\u000b\u0003 E)Z\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003-\tgN\\8uCRLwN\\:\u000b\u0005\u001dB\u0011A\u0002;fgRtw-\u0003\u0002*I\t!A+Z:u\u0003I)\u0007\u0010]3di\u0016$W\t_2faRLwN\\:-\u00031\u001a\u0013!\f\t\u0003]Ej\u0011a\f\u0006\u0003a\u0019\tqaY8n[>t7/\u0003\u00023_\tY2)Y2iK\u000e{gNZ5hkJ\fG/[8o\u000bb\u001cW\r\u001d;j_:DQ\u0001\u000e\u0001\u0005\u0002e\t\u0001\u0006^3tiN+'/[1mSj\f'\r\\3Jg>d\u0017\r^5p]2+g/\u001a7WC2LG-\u0019;j_:DCa\r\u0012+m1\nA\u0006C\u00039\u0001\u0011\u0005\u0011$A\u001cuKN$(+\u001a9fCR\f'\r\\3SK\u0006$\u0017j]8mCRLwN\u001c'fm\u0016dw+\u001b;i'.,wo\u00115fG.4\u0016\r\\5eCRLwN\u001c\u0005\u0006u\u0001!IaO\u0001\u0014o&$\bn\u00117vgR,'/\u001a3TKJ4XM\u001d\u000b\u0003y5#\"AG\u001f\t\u000byJ\u0004\u0019A \u0002\r\u0005\u001c8/\u001a:u!\u0015i\u0001I\u0011&\u001b\u0013\t\teBA\u0005Gk:\u001cG/[8oeA\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003\u000f\u001a\tQbY8oM&<WO]1uS>t\u0017BA%E\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]B\u0011QbS\u0005\u0003\u0019:\u0011A\u0001T8oO\")a*\u000fa\u0001\u001f\u00069!-^5mI\u0016\u0014\bC\u0001)S\u001b\u0005\t&BA$\u0003\u0013\t\u0019\u0016K\u0001\u0011I_R\u0014v\u000eZ*feZ,'oQ8oM&<WO]1uS>t')^5mI\u0016\u0014\b\"B+\u0001\t\u00131\u0016A\u0006<bY&$\u0017\r^3Jg>d\u0017\r^5p]2+g/\u001a7\u0015\u0007i9\u0016\rC\u0003Y)\u0002\u0007\u0011,\u0001\bjg>d\u0017\r^5p]2+g/\u001a7\u0011\u0005i{V\"A.\u000b\u0005qk\u0016AC2p]\u000e,(O]3oi*\u0011aLB\u0001\u0005kRLG.\u0003\u0002a7\nq\u0011j]8mCRLwN\u001c'fm\u0016d\u0007\"\u00022U\u0001\u0004\u0019\u0017!C<sSR,7k[3x!\tiA-\u0003\u0002f\u001d\t9!i\\8mK\u0006t\u0007F\u0002\u0001#O\"\\G.\u0001\u0004he>,\bo\u001d\u0017\u0002S\u0006\n!.\u0001\u0006gk:\u001cG/[8oC2\f\u0001\u0002^3ti:\u000bW.Z\u0011\u0002[\u0006)3/\u001a:wKJt\u0003n\u001c;s_\u0012t\u0003j\u001c;S_\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]R+7\u000f\u001e")
public class HotRodConfigurationTest {
    public void testUserDefinedTimeouts() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyLockTimeout(26000L).topologyReplTimeout(31000L);
        this.withClusteredServer(builder, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.locking().lockAcquisitionTimeout(), (long)26000L);
                Assert.assertEquals((long)cfg.clustering().sync().replTimeout(), (long)31000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                Assert.assertEquals((long)cfg.clustering().stateTransfer().timeout(), (long)(31000L + distSyncTimeout));
                Assert.assertTrue((boolean)cfg.persistence().stores().isEmpty());
            }
        });
    }

    public void testLazyLoadTopology() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyStateTransfer(false).topologyReplTimeout(43000L);
        this.withClusteredServer(builder, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.clustering().sync().replTimeout(), (long)43000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                ClusterLoaderConfiguration clcfg = (ClusterLoaderConfiguration)cfg.persistence().stores().get(0);
                Assert.assertNotNull((Object)clcfg);
                Assert.assertEquals((long)clcfg.remoteCallTimeout(), (long)43000L);
            }
        });
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testRepeatableReadIsolationLevelValidation() {
        this.validateIsolationLevel(IsolationLevel.REPEATABLE_READ, false);
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testSerializableIsolationLevelValidation() {
        this.validateIsolationLevel(IsolationLevel.SERIALIZABLE, false);
    }

    public void testRepeatableReadIsolationLevelWithSkewCheckValidation() {
        this.validateIsolationLevel(IsolationLevel.REPEATABLE_READ, true);
    }

    private void withClusteredServer(HotRodServerConfigurationBuilder builder, Function2<Configuration, Object, BoxedUnit> function2) {
        Stoppable$.MODULE$.useCacheManager(TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration()), (Function1)new Serializable(this, builder, function2){
            public static final long serialVersionUID = 0L;
            private final HotRodServerConfigurationBuilder builder$1;
            public final Function2 assert$1;

            public final void apply(EmbeddedCacheManager cm) {
                Stoppable$.MODULE$.useServer((AbstractProtocolServer)HotRodTestingUtil$.MODULE$.startHotRodServer(cm, (int)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())), this.builder$1), (Function1)new Serializable(this, cm){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$withClusteredServer$1 $outer;
                    private final EmbeddedCacheManager cm$1;

                    public final void apply(HotRodServer server) {
                        Configuration cfg = this.cm$1.getCache("___hotRodTopologyCache").getCacheConfiguration();
                        this.$outer.assert$1.apply((Object)cfg, (Object)BoxesRunTime.boxToLong((long)this.cm$1.getCacheManagerConfiguration().transport().distributedSyncTimeout()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.cm$1 = cm$1;
                    }
                });
            }
            {
                this.builder$1 = builder$1;
                this.assert$1 = assert$1;
            }
        });
    }

    private void validateIsolationLevel(IsolationLevel isolationLevel, boolean writeSkew) {
        HotRodServerConfigurationBuilder hotRodBuilder = new HotRodServerConfigurationBuilder();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.locking().isolationLevel(isolationLevel).writeSkewCheck(writeSkew);
        Object object = writeSkew ? builder.versioning().enable().scheme(VersioningScheme.SIMPLE) : BoxedUnit.UNIT;
        Stoppable$.MODULE$.useCacheManager(TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration(builder)), (Function1)new Serializable(this, hotRodBuilder){
            public static final long serialVersionUID = 0L;
            private final HotRodServerConfigurationBuilder hotRodBuilder$1;

            public final void apply(EmbeddedCacheManager cm) {
                Stoppable$.MODULE$.useServer((AbstractProtocolServer)HotRodTestingUtil$.MODULE$.startHotRodServer(cm, (int)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(UniquePortThreadLocal$.MODULE$.get())), this.hotRodBuilder$1), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(HotRodServer server) {
                    }
                });
            }
            {
                this.hotRodBuilder$1 = hotRodBuilder$1;
            }
        });
    }
}

