/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.hotrod.Constants$;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus$;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodClient$;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestSizeResponse;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@Test(groups={"functional"}, testName="server.hotrod.HotRodDistributionTest")
@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u0017\t1\u0002j\u001c;S_\u0012$\u0015n\u001d;sS\n,H/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u00051\u0001n\u001c;s_\u0012T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003'!{GOU8e\u001bVdG/\u001b(pI\u0016$Vm\u001d;\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002CA\u0007\u0001\u0011\u0015)\u0002\u0001\"\u0015\u0017\u0003%\u0019\u0017m\u00195f\u001d\u0006lW-F\u0001\u0018!\tAbD\u0004\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"$\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0001\u0012aa\u0015;sS:<'BA\u000f\u001b\u0011\u0015\u0011\u0003\u0001\"\u0015$\u0003E\u0019'/Z1uK\u000e\u000b7\r[3D_:4\u0017nZ\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003S\u0019\tQbY8oM&<WO]1uS>t\u0017BA\u0016'\u0005Q\u0019uN\u001c4jOV\u0014\u0018\r^5p]\n+\u0018\u000e\u001c3fe\")Q\u0006\u0001C\u0001]\u0005)C/Z:u\t&\u001cHO]5ckR,G\rU;u/&$\b\u000eV8q_2|w-_\"iC:<Wm\u001d\u000b\u0003_I\u0002\"!\u0007\u0019\n\u0005ER\"\u0001B+oSRDQa\r\u0017A\u0002Q\n\u0011!\u001c\t\u0003kqj\u0011A\u000e\u0006\u0003oa\nqA]3gY\u0016\u001cGO\u0003\u0002:u\u0005!A.\u00198h\u0015\u0005Y\u0014\u0001\u00026bm\u0006L!!\u0010\u001c\u0003\r5+G\u000f[8e\u0011\u0015y\u0004\u0001\"\u0001A\u0003!!Xm\u001d;TSj,GCA\u0018B\u0011\u0015\u0019d\b1\u00015Q\u0019\u00011i\u0013'P!B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\fC:tw\u000e^1uS>t7O\u0003\u0002I\u0011\u00051A/Z:u]\u001eL!AS#\u0003\tQ+7\u000f^\u0001\u0007OJ|W\u000f]:-\u00035\u000b\u0013AT\u0001\u000bMVt7\r^5p]\u0006d\u0017\u0001\u0003;fgRt\u0015-\\3\"\u0003E\u000bAe]3sm\u0016\u0014h\u0006[8ue>$g\u0006S8u%>$G)[:ue&\u0014W\u000f^5p]R+7\u000f\u001e")
public class HotRodDistributionTest
extends HotRodMultiNodeTest {
    @Override
    public String cacheName() {
        return "hotRodDistSync";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigurationBuilder createCacheConfig() {
        void var1_1;
        ConfigurationBuilder cfg = HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration(AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        cfg.clustering().l1().disable();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void testDistributedPutWithTopologyChanges(Method m) {
        HotRodClient client1 = (HotRodClient)this.clients().head();
        HotRodClient client2 = (HotRodClient)((IterableLike)this.clients().tail()).head();
        TestResponse resp = client1.ping(Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopology20Received((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.cacheName(), this.currentServerTopologyId());
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), Constants$.MODULE$.INTELLIGENCE_BASIC(), 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m));
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v1-"), Constants$.MODULE$.INTELLIGENCE_TOPOLOGY_AWARE(), 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.currentServerTopologyId());
        resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v2-"), Constants$.MODULE$.INTELLIGENCE_TOPOLOGY_AWARE(), 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertTopologyReceived((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.currentServerTopologyId());
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v3-"), Constants$.MODULE$.INTELLIGENCE_TOPOLOGY_AWARE(), 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        Assert.assertEquals(resp.topologyResponse(), (Object)None$.MODULE$);
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v3-"));
        resp = client1.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v4-"), Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopology20Received((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.cacheName(), this.currentServerTopologyId());
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v4-"));
        resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v5-"), Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), 0);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopology20Received((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.cacheName(), this.currentServerTopologyId());
        HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v5-"));
        HotRodServer newServer = this.startClusteredServer(((AbstractProtocolServer)((IterableLike)this.servers().tail()).head()).getPort() + 25);
        HotRodClient newClient = new HotRodClient("127.0.0.1", newServer.getPort(), this.cacheName(), 60, this.protocolVersion(), HotRodClient$.MODULE$.$lessinit$greater$default$6());
        HotRodServer hotRodServer = newServer;
        List allServers = this.servers().$colon$colon((Object)hotRodServer);
        try {
            this.log.trace((Object)"New client started, modify key to be v6-*");
            resp = newClient.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v6-"), Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), 0);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            HotRodTestingUtil$.MODULE$.assertHashTopology20Received((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), (List<HotRodServer>)allServers, this.cacheName(), this.currentServerTopologyId());
            this.log.trace((Object)"Get key and verify that's v6-*");
            HotRodTestingUtil$.MODULE$.assertSuccess(client2.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v6-"));
            resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v7-"), Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), 0);
            HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
            HotRodTestingUtil$.MODULE$.assertHashTopology20Received((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), (List<HotRodServer>)allServers, this.cacheName(), this.currentServerTopologyId());
            HotRodTestingUtil$.MODULE$.assertSuccess(newClient.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v7-"));
        }
        catch (Throwable throwable) {
            void var5_5;
            void var6_6;
            this.log.trace((Object)"Stopping new server");
            HotRodTestingUtil$.MODULE$.killClient((HotRodClient)var6_6);
            this.stopClusteredServer((HotRodServer)var5_5);
            TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            this.log.trace((Object)"New server stopped");
            throw throwable;
        }
        this.log.trace((Object)"Stopping new server");
        HotRodTestingUtil$.MODULE$.killClient(newClient);
        this.stopClusteredServer(newServer);
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        this.log.trace((Object)"New server stopped");
        resp = client2.put(HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m, "v8-"), Constants$.MODULE$.INTELLIGENCE_HASH_DISTRIBUTION_AWARE(), 2);
        HotRodTestingUtil$.MODULE$.assertStatus(resp, OperationStatus$.MODULE$.Success());
        HotRodTestingUtil$.MODULE$.assertHashTopology20Received((AbstractTestTopologyAwareResponse)resp.topologyResponse().get(), this.servers(), this.cacheName(), this.currentServerTopologyId());
        HotRodTestingUtil$.MODULE$.assertSuccess(client1.get(HotRodTestingUtil$.MODULE$.k(m), 0), HotRodTestingUtil$.MODULE$.v(m, "v8-"));
    }

    public void testSize(Method m) {
        String cacheName = "dist-size";
        this.defineCaches(cacheName);
        List<HotRodClient> clients = this.createClients(cacheName);
        TestSizeResponse sizeStart = ((HotRodClient)clients.head()).size();
        HotRodTestingUtil$.MODULE$.assertStatus(sizeStart, OperationStatus$.MODULE$.Success());
        Assert.assertEquals((long)0L, (long)sizeStart.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this, m, clients){
            public static final long serialVersionUID = 0L;
            private final Method m$1;
            private final List clients$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ((HotRodClient)((IterableLike)this.clients$1.tail()).head()).assertPut(this.m$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
            }
            {
                this.m$1 = m$1;
                this.clients$1 = clients$1;
            }
        });
        TestSizeResponse sizeEnd = ((HotRodClient)((IterableLike)clients.tail()).head()).size();
        HotRodTestingUtil$.MODULE$.assertStatus(sizeEnd, OperationStatus$.MODULE$.Success());
        Assert.assertEquals((long)20L, (long)sizeEnd.size());
    }
}

