/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.util.EncodeUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.hotrod.AccessLoggingHeader;
import org.infinispan.server.hotrod.BaseDecoder;
import org.infinispan.server.hotrod.BitShift;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.Intrinsics;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.TimeUnitValue;
import org.infinispan.server.hotrod.TransactionWrite;
import org.infinispan.server.hotrod.logging.HotRodAccessLogging;
import org.infinispan.server.hotrod.tx.ControlByte;

public class HotRodDecoder
extends BaseDecoder {
    private int state;
    private int requestBytes;
    private byte hr2x_timeUnits;
    private int hr2x_numEntries;
    private String hr2x_iterationId;
    private byte hr2x_controlByte;
    private byte[] hr2x_fixedArray;
    private byte[] hr2x_queryBytes;
    private byte hr2x_counterFlags;
    private long hr2x_expectValue;
    private ByteBuf hr2x_readable;
    private boolean hr2x_includeCurrentState;
    private String hr2x_taskParam;
    private String hr2x_cacheName;
    private int hr2x_vInt;
    private MediaType hr2x_valueType;
    private long hr2x_initialValue;
    private int hr2x_numModifications;
    private byte[] hr2x_param;
    private String hr2x_authMech;
    private byte[] hr2x_authResponse;
    private int hr2x_listenerInterests;
    private byte hr2x_numParams;
    private int hr2x_xidFormat;
    private String hr2x_filterFactory;
    private long hr2x_maxIdleLong;
    private HotRodOperation hr2x_operation;
    private long hr2x_upperBound;
    private byte hr2x_version;
    private String hr2x_converterFactory;
    private int hr2x_signedVInt;
    private MediaType hr2x_keyType;
    private String hr2x_filterConverterFactory;
    private Map<String, String> hr2x_mediaTypeParams;
    private long hr2x_versionRead;
    private int hr2x_lifespanInt;
    private String hr2x_mediaParamValue;
    private byte hr2x_intelligence;
    private long hr2x_long;
    private String hr2x_mediaParamName;
    private List<byte[]> hr2x_converterParams;
    private boolean hr2x_recoverable;
    private byte[] hr2x_value;
    private byte hr2x_branchLength;
    private String hr2x_optionalString;
    private byte[] hr2x_optionalArray;
    private boolean hr2x_bool;
    private byte hr2x_xidLength;
    private byte hr2x_mediaTypeDefinition;
    private Metadata hr2x_expiration;
    private List<byte[]> hr2x_filterParams;
    private int hr2x_offset;
    private ByteBuf hr2x_chunkBytes;
    private long hr2x_updateValue;
    private byte hr2x_txMarker;
    private boolean hr2x_useRawEvents;
    private int hr2x_chunkLength;
    private long hr2x_timeout;
    private String hr2x_taskName;
    private String hr2x_mediaTypeName;
    private long hr2x_lowerBound;
    private byte[] hr2x_taskParamValue;
    private ByteBuf hr2x_chunkedValue;
    private byte[] hr2x_key;
    private int hr2x_batchSize;
    private HotRodHeader hr2x_header;
    private int hr2x_scope;
    private long hr2x_lifespanLong;
    private Map<String, byte[]> hr2x_taskParams;
    private byte[] hr2x_array;
    private int hr2x_flags;
    private byte[] hr2x_listenerId;
    private byte[] hr2x_segmentMask;
    private byte hr2x_magic;
    private int hr2x_maxIdleInt;
    private boolean hr2x_onePhaseCommit;
    private long hr2x_entryVersion;
    private int hr2x_mediaTypeId;
    private boolean hr2x_includeMetadata;
    private byte hr2x_opCode;
    private Map<byte[], byte[]> hr2x_entryMap;
    private int hr2x_mediaTypeParamsNum;
    private long hr2x_messageId;
    private long hr2x_vLong;
    private List<byte[]> hr2x_filterConverterParams;
    private int hr2x_numKeys;
    private MediaType hr2x_mediaType;
    private byte[] hr2x_branchId;
    private String hr2x_string;
    private byte hr2x_byte;
    private byte[] hr2x_transactionId;
    private MediaType hr2x_mediaTypeDescription;
    private String hr2x_counterName;
    private TransactionWrite hr2x_modification;
    private CounterConfiguration.Builder hr2x_counterConfiguration;
    private int hr2x_topologyId;
    private Set<byte[]> hr2x_keys;
    private XidImpl hr2x_xid;
    private List<TransactionWrite> hr2x_modifications;
    private final boolean accessLogging;
    private Temporal requestStart;
    private boolean deadEnd = false;

    public HotRodDecoder(EmbeddedCacheManager cacheManager, Executor executor, HotRodServer server) {
        super(cacheManager, executor, server);
        server.accessLogging();
        this.accessLogging = HotRodAccessLogging.isEnabled();
    }

    @Override
    protected HotRodHeader getHeader() {
        if (this.accessLogging && this.hr2x_header != null) {
            return new AccessLoggingHeader(this.hr2x_header, this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.requestBytes, this.requestStart);
        }
        return this.hr2x_header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            while (this.switch1_0(buf)) {
            }
        }
        catch (Throwable t) {
            this.exceptionally(t);
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch1_0(ByteBuf buf) throws Exception {
        switch (this.state >> 6) {
            case 0: {
                return this.switch0(buf);
            }
            case 1: {
                return this.switch1(buf);
            }
            case 2: {
                return this.switch2(buf);
            }
            case 3: {
                return this.switch3(buf);
            }
            case 4: {
                return this.switch4(buf);
            }
            case 5: {
                return this.switch5(buf);
            }
            case 6: {
                return this.switch6(buf);
            }
        }
        throw new IllegalStateException();
    }

    private boolean switch0(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_magic = this.hr2x_byte;
                this.state = 2;
            }
            case 2: {
                if (this.accessLogging) {
                    this.requestStart = ZonedDateTime.now();
                }
                this.state = 3;
            }
            case 3: {
                if (this.hr2x_magic != -96) {
                    this.state = 5;
                    return true;
                }
                this.deadEnd = false;
                this.state = 6;
                return true;
            }
            case 4: {
                if (trace) {
                    log.tracef("Parsed header: %s", this.hr2x_header);
                }
                this.state = 55;
                return true;
            }
            case 5: {
                throw new InvalidMagicIdException("Error reading magic byte or message id: " + this.hr2x_magic);
            }
            case 6: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_messageId = this.hr2x_vLong;
                this.state = 7;
            }
            case 7: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_version = this.hr2x_byte;
                this.state = 8;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_opCode = this.hr2x_byte;
                this.hr2x_operation = HotRodOperation.fromRequestOpCode(this.hr2x_byte);
                this.state = 9;
            }
            case 9: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_cacheName = this.hr2x_string;
                this.state = 10;
            }
            case 10: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_flags = this.hr2x_vInt;
                this.state = 11;
            }
            case 11: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intelligence = this.hr2x_byte;
                this.state = 12;
            }
            case 12: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_topologyId = this.hr2x_vInt;
                this.state = 13;
            }
            case 13: {
                if (this.hr2x_version < 20) {
                    this.state = 15;
                    return true;
                }
                this.hr2x_txMarker = 0;
                this.state = 14;
            }
            case 14: {
                if (this.hr2x_version >= 28) {
                    this.state = 17;
                    return true;
                }
                this.hr2x_keyType = this.hr2x_mediaType = null;
                this.state = 16;
                return true;
            }
            case 15: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_txMarker = this.hr2x_byte;
                this.state = 14;
                return true;
            }
            case 16: {
                if (this.hr2x_version >= 28) {
                    this.state = 36;
                    return true;
                }
                this.hr2x_valueType = this.hr2x_mediaType = null;
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType);
                this.state = 4;
                return true;
            }
            case 17: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeDefinition = this.hr2x_byte;
                this.state = 18;
            }
            case 18: {
                switch (this.hr2x_mediaTypeDefinition) {
                    case 0: {
                        this.state = 19;
                        return true;
                    }
                    case 1: {
                        this.state = 20;
                        return true;
                    }
                    case 2: {
                        this.state = 28;
                        return true;
                    }
                }
                throw new RequestParsingException("Unknown MediaType definition: " + this.hr2x_mediaTypeDefinition, this.hr2x_version, this.hr2x_messageId);
            }
            case 19: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.APPLICATION_UNKNOWN);
                this.state = 16;
                return true;
            }
            case 20: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeId = this.hr2x_vInt;
                this.state = 21;
            }
            case 21: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 23;
                return true;
            }
            case 22: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaTypeIds.getMediaType((Short)((short)this.hr2x_mediaTypeId)).withParameters(this.hr2x_mediaTypeParams));
                this.state = 16;
                return true;
            }
            case 23: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 24;
            }
            case 24: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 22;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 25;
            }
            case 25: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 26;
            }
            case 26: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 27;
            }
            case 27: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 24;
                return true;
            }
            case 28: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeName = this.hr2x_string;
                this.state = 29;
            }
            case 29: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 31;
                return true;
            }
            case 30: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.parse((String)this.hr2x_mediaTypeName).withParameters(this.hr2x_mediaTypeParams));
                this.state = 16;
                return true;
            }
            case 31: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 32;
            }
            case 32: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 30;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 33;
            }
            case 33: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 34;
            }
            case 34: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 35;
            }
            case 35: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 32;
                return true;
            }
            case 36: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeDefinition = this.hr2x_byte;
                this.state = 37;
            }
            case 37: {
                switch (this.hr2x_mediaTypeDefinition) {
                    case 0: {
                        this.state = 38;
                        return true;
                    }
                    case 1: {
                        this.state = 39;
                        return true;
                    }
                    case 2: {
                        this.state = 47;
                        return true;
                    }
                }
                throw new RequestParsingException("Unknown MediaType definition: " + this.hr2x_mediaTypeDefinition, this.hr2x_version, this.hr2x_messageId);
            }
            case 38: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.APPLICATION_UNKNOWN);
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType);
                this.state = 4;
                return true;
            }
            case 39: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeId = this.hr2x_vInt;
                this.state = 40;
            }
            case 40: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 42;
                return true;
            }
            case 41: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaTypeIds.getMediaType((Short)((short)this.hr2x_mediaTypeId)).withParameters(this.hr2x_mediaTypeParams));
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType);
                this.state = 4;
                return true;
            }
            case 42: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 43;
            }
            case 43: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 41;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 44;
            }
            case 44: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 45;
            }
            case 45: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 46;
            }
            case 46: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 43;
                return true;
            }
            case 47: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeName = this.hr2x_string;
                this.state = 48;
            }
            case 48: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 50;
                return true;
            }
            case 49: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.parse((String)this.hr2x_mediaTypeName).withParameters(this.hr2x_mediaTypeParams));
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType);
                this.state = 4;
                return true;
            }
            case 50: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 51;
            }
            case 51: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 49;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 52;
            }
            case 52: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 53;
            }
            case 53: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 54;
            }
            case 54: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 51;
                return true;
            }
            case 55: {
                return this.userSwitch55();
            }
            case 56: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 57;
            }
            case 57: {
                if (this.hr2x_version < 22) {
                    this.state = 59;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 61;
                return true;
            }
            case 58: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 65;
                return true;
            }
            case 59: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 60;
            }
            case 60: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 58;
                return true;
            }
            case 61: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 63;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 62;
            }
            case 62: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 64;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 58;
                return true;
            }
            case 63: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 62;
                return true;
            }
        }
        return true;
    }

    private boolean switch1(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 64: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 58;
                return true;
            }
            case 65: {
                this.cacheProcessor.put(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 66: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 67;
            }
            case 67: {
                this.cacheProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 68: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 69;
            }
            case 69: {
                if (this.hr2x_version < 22) {
                    this.state = 71;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 73;
                return true;
            }
            case 70: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 77;
                return true;
            }
            case 71: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 72;
            }
            case 72: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 70;
                return true;
            }
            case 73: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 75;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 74;
            }
            case 74: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 76;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 70;
                return true;
            }
            case 75: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 74;
                return true;
            }
            case 76: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 70;
                return true;
            }
            case 77: {
                this.cacheProcessor.putIfAbsent(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 78: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 79;
            }
            case 79: {
                if (this.hr2x_version < 22) {
                    this.state = 81;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 83;
                return true;
            }
            case 80: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 87;
                return true;
            }
            case 81: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 82;
            }
            case 82: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 80;
                return true;
            }
            case 83: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 85;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 84;
            }
            case 84: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 86;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 80;
                return true;
            }
            case 85: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 84;
                return true;
            }
            case 86: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 80;
                return true;
            }
            case 87: {
                this.cacheProcessor.replace(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 88: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 89;
            }
            case 89: {
                if (this.hr2x_version < 22) {
                    this.state = 91;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 93;
                return true;
            }
            case 90: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 97;
                return true;
            }
            case 91: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 92;
            }
            case 92: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 90;
                return true;
            }
            case 93: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 95;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 94;
            }
            case 94: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 96;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 90;
                return true;
            }
            case 95: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 94;
                return true;
            }
            case 96: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 90;
                return true;
            }
            case 97: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 98;
            }
            case 98: {
                this.cacheProcessor.replaceIfUnmodified(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_entryVersion, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 99: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 100;
            }
            case 100: {
                this.cacheProcessor.remove(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 101: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 102;
            }
            case 102: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 103;
            }
            case 103: {
                this.cacheProcessor.removeIfUnmodified(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_entryVersion);
                this.state = 0;
                return true;
            }
            case 104: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 105;
            }
            case 105: {
                this.cacheProcessor.containsKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 106: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 107;
            }
            case 107: {
                this.cacheProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 108: {
                this.cacheProcessor.clear(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 109: {
                this.cacheProcessor.stats(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 110: {
                this.cacheProcessor.ping(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 111: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numKeys = this.hr2x_vInt;
                this.state = 112;
            }
            case 112: {
                this.cacheProcessor.bulkGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_numKeys);
                this.state = 0;
                return true;
            }
            case 113: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 114;
            }
            case 114: {
                this.cacheProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, 0);
                this.state = 0;
                return true;
            }
            case 115: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_scope = this.hr2x_vInt;
                this.state = 116;
            }
            case 116: {
                this.cacheProcessor.bulkGetKeys(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_scope);
                this.state = 0;
                return true;
            }
            case 117: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_queryBytes = this.hr2x_array;
                this.state = 118;
            }
            case 118: {
                this.cacheProcessor.query(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_queryBytes);
                this.state = 0;
                return true;
            }
            case 119: {
                this.auth.authMechList(this.hr2x_header);
                this.state = 0;
                return true;
            }
            case 120: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_authMech = this.hr2x_string;
                this.state = 121;
            }
            case 121: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_authResponse = this.hr2x_array;
                this.state = 122;
            }
            case 122: {
                this.auth.auth(this.hr2x_header, this.hr2x_authMech, this.hr2x_authResponse);
                this.state = 0;
                return true;
            }
            case 123: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 124;
            }
            case 124: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_includeCurrentState = this.hr2x_bool;
                this.state = 125;
            }
            case 125: {
                if (this.hr2x_version >= 21) {
                    this.state = 127;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterFactory = this.hr2x_string;
                this.state = 142;
                return true;
            }
            case 126: {
                if (this.hr2x_version >= 26) {
                    this.state = 156;
                    return true;
                }
                this.hr2x_listenerInterests = 0;
                this.state = 155;
                return true;
            }
            case 127: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterFactory = this.hr2x_string;
                this.state = 128;
            }
        }
        return true;
    }

    private boolean switch2(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 128: {
                if (!this.hr2x_filterFactory.isEmpty()) {
                    this.state = 130;
                    return true;
                }
                this.hr2x_filterParams = null;
                this.state = 129;
            }
            case 129: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_converterFactory = this.hr2x_string;
                this.state = 135;
                return true;
            }
            case 130: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 131;
            }
            case 131: {
                this.hr2x_filterParams = this.allocList(this.hr2x_numParams);
                this.state = 132;
            }
            case 132: {
                if (this.hr2x_numParams == 0) {
                    this.state = 129;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 133;
            }
            case 133: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 134;
            }
            case 134: {
                this.hr2x_filterParams.add(this.hr2x_param);
                this.state = 132;
                return true;
            }
            case 135: {
                if (!this.hr2x_converterFactory.isEmpty()) {
                    this.state = 137;
                    return true;
                }
                this.hr2x_converterParams = null;
                this.state = 136;
            }
            case 136: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_useRawEvents = this.hr2x_bool;
                this.state = 126;
                return true;
            }
            case 137: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 138;
            }
            case 138: {
                this.hr2x_converterParams = this.allocList(this.hr2x_numParams);
                this.state = 139;
            }
            case 139: {
                if (this.hr2x_numParams == 0) {
                    this.state = 136;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 140;
            }
            case 140: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 141;
            }
            case 141: {
                this.hr2x_converterParams.add(this.hr2x_param);
                this.state = 139;
                return true;
            }
            case 142: {
                if (!this.hr2x_filterFactory.isEmpty()) {
                    this.state = 144;
                    return true;
                }
                this.hr2x_filterParams = null;
                this.state = 143;
            }
            case 143: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_converterFactory = this.hr2x_string;
                this.state = 149;
                return true;
            }
            case 144: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 145;
            }
            case 145: {
                this.hr2x_filterParams = this.allocList(this.hr2x_numParams);
                this.state = 146;
            }
            case 146: {
                if (this.hr2x_numParams == 0) {
                    this.state = 143;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 147;
            }
            case 147: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 148;
            }
            case 148: {
                this.hr2x_filterParams.add(this.hr2x_param);
                this.state = 146;
                return true;
            }
            case 149: {
                if (!this.hr2x_converterFactory.isEmpty()) {
                    this.state = 150;
                    return true;
                }
                this.hr2x_converterParams = null;
                this.state = 126;
                return true;
            }
            case 150: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 151;
            }
            case 151: {
                this.hr2x_converterParams = this.allocList(this.hr2x_numParams);
                this.state = 152;
            }
            case 152: {
                if (this.hr2x_numParams == 0) {
                    this.state = 126;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 153;
            }
            case 153: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 154;
            }
            case 154: {
                this.hr2x_converterParams.add(this.hr2x_param);
                this.state = 152;
                return true;
            }
            case 155: {
                this.cacheProcessor.addClientListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_listenerId, this.hr2x_includeCurrentState, this.hr2x_filterFactory, this.hr2x_filterParams, this.hr2x_converterFactory, this.hr2x_converterParams, this.hr2x_useRawEvents, this.hr2x_listenerInterests);
                this.state = 0;
                return true;
            }
            case 156: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerInterests = this.hr2x_vInt;
                this.state = 155;
                return true;
            }
            case 157: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 158;
            }
            case 158: {
                this.cacheProcessor.removeClientListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 159: {
                this.cacheProcessor.size(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 160: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskName = this.hr2x_string;
                this.state = 161;
            }
            case 161: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 163;
                return true;
            }
            case 162: {
                this.taskProcessor.exec(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_taskName, this.hr2x_taskParams);
                this.state = 0;
                return true;
            }
            case 163: {
                this.hr2x_taskParams = this.allocMap(this.hr2x_numParams);
                this.state = 164;
            }
            case 164: {
                if (this.hr2x_numParams == 0) {
                    this.state = 162;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 165;
            }
            case 165: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskParam = this.hr2x_string;
                this.state = 166;
            }
            case 166: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskParamValue = this.hr2x_array;
                this.state = 167;
            }
            case 167: {
                this.hr2x_taskParams.put(this.hr2x_taskParam, this.hr2x_taskParamValue);
                this.state = 164;
                return true;
            }
            case 168: {
                if (this.hr2x_version < 22) {
                    this.state = 170;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 172;
                return true;
            }
            case 169: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numEntries = this.hr2x_vInt;
                this.state = 177;
                return true;
            }
            case 170: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 171;
            }
            case 171: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 169;
                return true;
            }
            case 172: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 174;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 173;
            }
            case 173: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 175;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 169;
                return true;
            }
            case 174: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 173;
                return true;
            }
            case 175: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 169;
                return true;
            }
            case 176: {
                this.cacheProcessor.putAll(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_entryMap, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 177: {
                this.hr2x_entryMap = this.allocMap(this.hr2x_numEntries);
                this.state = 178;
            }
            case 178: {
                if (this.hr2x_numEntries == 0) {
                    this.state = 176;
                    return true;
                }
                --this.hr2x_numEntries;
                this.state = 179;
            }
            case 179: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 180;
            }
            case 180: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 181;
            }
            case 181: {
                this.hr2x_entryMap.put(this.hr2x_key, this.hr2x_value);
                this.state = 178;
                return true;
            }
            case 182: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numKeys = this.hr2x_vInt;
                this.state = 184;
                return true;
            }
            case 183: {
                this.cacheProcessor.getAll(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_keys);
                this.state = 0;
                return true;
            }
            case 184: {
                this.hr2x_keys = this.allocSet(this.hr2x_numKeys);
                this.state = 185;
            }
            case 185: {
                if (this.hr2x_numKeys == 0) {
                    this.state = 183;
                    return true;
                }
                --this.hr2x_numKeys;
                this.state = 186;
            }
            case 186: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 187;
            }
            case 187: {
                this.hr2x_keys.add(this.hr2x_key);
                this.state = 185;
                return true;
            }
            case 188: {
                int pos = buf.readerIndex();
                this.hr2x_optionalArray = Intrinsics.optionalArray(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_segmentMask = this.hr2x_optionalArray;
                this.state = 189;
            }
            case 189: {
                int pos = buf.readerIndex();
                this.hr2x_optionalString = Intrinsics.optionalString(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterConverterFactory = this.hr2x_optionalString;
                this.state = 190;
            }
            case 190: {
                if (this.hr2x_filterConverterFactory != null) {
                    this.state = 192;
                    return true;
                }
                this.hr2x_filterConverterParams = null;
                this.state = 191;
            }
            case 191: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_batchSize = this.hr2x_vInt;
                this.state = 197;
                return true;
            }
        }
        return true;
    }

    private boolean switch3(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 192: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 193;
            }
            case 193: {
                this.hr2x_filterConverterParams = this.allocList(this.hr2x_numParams);
                this.state = 194;
            }
            case 194: {
                if (this.hr2x_numParams == 0) {
                    this.state = 191;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 195;
            }
            case 195: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 196;
            }
            case 196: {
                this.hr2x_filterConverterParams.add(this.hr2x_param);
                this.state = 194;
                return true;
            }
            case 197: {
                if (this.hr2x_version >= 24) {
                    this.state = 199;
                    return true;
                }
                this.hr2x_includeMetadata = false;
                this.state = 198;
            }
            case 198: {
                this.cacheProcessor.iterationStart(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_segmentMask, this.hr2x_filterConverterFactory, this.hr2x_filterConverterParams, this.hr2x_batchSize, this.hr2x_includeMetadata);
                this.state = 0;
                return true;
            }
            case 199: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_includeMetadata = this.hr2x_bool;
                this.state = 198;
                return true;
            }
            case 200: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_iterationId = this.hr2x_string;
                this.state = 201;
            }
            case 201: {
                this.cacheProcessor.iterationNext(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_iterationId);
                this.state = 0;
                return true;
            }
            case 202: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_iterationId = this.hr2x_string;
                this.state = 203;
            }
            case 203: {
                this.cacheProcessor.iterationEnd(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_iterationId);
                this.state = 0;
                return true;
            }
            case 204: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 205;
            }
            case 205: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_offset = this.hr2x_vInt;
                this.state = 206;
            }
            case 206: {
                this.cacheProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_offset);
                this.state = 0;
                return true;
            }
            case 207: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 208;
            }
            case 208: {
                if (this.hr2x_version < 22) {
                    this.state = 210;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 212;
                return true;
            }
            case 209: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 216;
                return true;
            }
            case 210: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 211;
            }
            case 211: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 209;
                return true;
            }
            case 212: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 214;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 213;
            }
            case 213: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 215;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 209;
                return true;
            }
            case 214: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 213;
                return true;
            }
            case 215: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 209;
                return true;
            }
            case 216: {
                this.hr2x_chunkedValue = this.cacheProcessor.channel().alloc().buffer();
                this.hr2x_chunkLength = 1;
                this.state = 218;
                return true;
            }
            case 217: {
                this.cacheProcessor.putStream(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_chunkedValue, this.hr2x_entryVersion, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 218: {
                if (this.hr2x_chunkLength == 0) {
                    this.state = 217;
                    return true;
                }
                --this.hr2x_chunkLength;
                this.state = 219;
            }
            case 219: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 220;
            }
            case 220: {
                if (this.hr2x_chunkLength > 0) {
                    this.state = 222;
                    return true;
                }
                this.hr2x_chunkBytes = this.cacheProcessor.channel().alloc().buffer(0);
                this.state = 221;
            }
            case 221: {
                this.hr2x_chunkedValue.writeBytes(this.hr2x_chunkBytes, this.hr2x_chunkBytes.readerIndex() - this.hr2x_chunkLength, this.hr2x_chunkLength);
                this.state = 218;
                return true;
            }
            case 222: {
                int pos = buf.readerIndex();
                this.hr2x_readable = Intrinsics.readable(buf, this.hr2x_chunkLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkBytes = this.hr2x_readable;
                this.state = 221;
                return true;
            }
            case 223: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 225;
                return true;
            }
            case 224: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_onePhaseCommit = this.hr2x_bool;
                this.state = 231;
                return true;
            }
            case 225: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 226;
            }
            case 226: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 228;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 227;
            }
            case 227: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 229;
                return true;
            }
            case 228: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 227;
                return true;
            }
            case 229: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 230;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 224;
                return true;
            }
            case 230: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 224;
                return true;
            }
            case 231: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numModifications = this.hr2x_vInt;
                this.state = 233;
                return true;
            }
            case 232: {
                this.cacheProcessor.prepareTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid, this.hr2x_onePhaseCommit, this.hr2x_modifications, false, 60000L);
                this.state = 0;
                return true;
            }
            case 233: {
                this.hr2x_modifications = this.allocList(this.hr2x_numModifications);
                this.state = 234;
            }
            case 234: {
                if (this.hr2x_numModifications == 0) {
                    this.state = 232;
                    return true;
                }
                --this.hr2x_numModifications;
                this.state = 235;
            }
            case 235: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 237;
                return true;
            }
            case 236: {
                this.hr2x_modifications.add(this.hr2x_modification);
                this.state = 234;
                return true;
            }
            case 237: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_controlByte = this.hr2x_byte;
                this.state = 238;
            }
            case 238: {
                if (!ControlByte.NOT_READ.hasFlag(this.hr2x_controlByte) && !ControlByte.NON_EXISTING.hasFlag(this.hr2x_controlByte)) {
                    this.state = 240;
                    return true;
                }
                this.hr2x_versionRead = 0L;
                this.state = 239;
            }
            case 239: {
                if (!ControlByte.REMOVE_OP.hasFlag(this.hr2x_controlByte)) {
                    this.state = 241;
                    return true;
                }
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 236;
                return true;
            }
            case 240: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_versionRead = this.hr2x_entryVersion = this.hr2x_long;
                this.state = 239;
                return true;
            }
            case 241: {
                if (this.hr2x_version < 22) {
                    this.state = 243;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 245;
                return true;
            }
            case 242: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 236;
                return true;
            }
            case 243: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 244;
            }
            case 244: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 242;
                return true;
            }
            case 245: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 247;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 246;
            }
            case 246: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 248;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 242;
                return true;
            }
            case 247: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 246;
                return true;
            }
            case 248: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 242;
                return true;
            }
            case 249: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 251;
                return true;
            }
            case 250: {
                this.cacheProcessor.commitTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 251: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 252;
            }
            case 252: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 254;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 253;
            }
            case 253: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 255;
                return true;
            }
            case 254: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 253;
                return true;
            }
            case 255: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 256;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 250;
                return true;
            }
        }
        return true;
    }

    private boolean switch4(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 256: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 250;
                return true;
            }
            case 257: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 259;
                return true;
            }
            case 258: {
                this.cacheProcessor.rollbackTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 259: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 260;
            }
            case 260: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 262;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 261;
            }
            case 261: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 263;
                return true;
            }
            case 262: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 261;
                return true;
            }
            case 263: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 264;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 258;
                return true;
            }
            case 264: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 258;
                return true;
            }
            case 265: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 267;
                return true;
            }
            case 266: {
                this.cacheProcessor.forgetTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 267: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 268;
            }
            case 268: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 270;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 269;
            }
            case 269: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 271;
                return true;
            }
            case 270: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 269;
                return true;
            }
            case 271: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 272;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 266;
                return true;
            }
            case 272: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 266;
                return true;
            }
            case 273: {
                this.cacheProcessor.getPreparedTransactions(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 274: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 276;
                return true;
            }
            case 275: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_onePhaseCommit = this.hr2x_bool;
                this.state = 282;
                return true;
            }
            case 276: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 277;
            }
            case 277: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 279;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 278;
            }
            case 278: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 280;
                return true;
            }
            case 279: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 278;
                return true;
            }
            case 280: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 281;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 275;
                return true;
            }
            case 281: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 275;
                return true;
            }
            case 282: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_recoverable = this.hr2x_bool;
                this.state = 283;
            }
            case 283: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeout = this.hr2x_long;
                this.state = 284;
            }
            case 284: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numModifications = this.hr2x_vInt;
                this.state = 286;
                return true;
            }
            case 285: {
                this.cacheProcessor.prepareTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid, this.hr2x_onePhaseCommit, this.hr2x_modifications, this.hr2x_recoverable, this.hr2x_timeout);
                this.state = 0;
                return true;
            }
            case 286: {
                this.hr2x_modifications = this.allocList(this.hr2x_numModifications);
                this.state = 287;
            }
            case 287: {
                if (this.hr2x_numModifications == 0) {
                    this.state = 285;
                    return true;
                }
                --this.hr2x_numModifications;
                this.state = 288;
            }
            case 288: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 290;
                return true;
            }
            case 289: {
                this.hr2x_modifications.add(this.hr2x_modification);
                this.state = 287;
                return true;
            }
            case 290: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_controlByte = this.hr2x_byte;
                this.state = 291;
            }
            case 291: {
                if (!ControlByte.NOT_READ.hasFlag(this.hr2x_controlByte) && !ControlByte.NON_EXISTING.hasFlag(this.hr2x_controlByte)) {
                    this.state = 293;
                    return true;
                }
                this.hr2x_versionRead = 0L;
                this.state = 292;
            }
            case 292: {
                if (!ControlByte.REMOVE_OP.hasFlag(this.hr2x_controlByte)) {
                    this.state = 294;
                    return true;
                }
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 289;
                return true;
            }
            case 293: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_versionRead = this.hr2x_entryVersion = this.hr2x_long;
                this.state = 292;
                return true;
            }
            case 294: {
                if (this.hr2x_version < 22) {
                    this.state = 296;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 298;
                return true;
            }
            case 295: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 289;
                return true;
            }
            case 296: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 297;
            }
            case 297: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 295;
                return true;
            }
            case 298: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 300;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 299;
            }
            case 299: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 301;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 295;
                return true;
            }
            case 300: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 299;
                return true;
            }
            case 301: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 295;
                return true;
            }
            case 302: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 303;
            }
            case 303: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterFlags = this.hr2x_byte;
                this.state = 305;
                return true;
            }
            case 304: {
                this.counterProcessor.createCounter(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_counterConfiguration.build());
                this.state = 0;
                return true;
            }
            case 305: {
                this.hr2x_counterConfiguration = CounterConfiguration.builder((CounterType)EncodeUtil.decodeType((byte)this.hr2x_counterFlags)).storage(EncodeUtil.decodeStorage((byte)this.hr2x_counterFlags));
                this.state = 306;
            }
            case 306: {
                if ((this.hr2x_counterFlags & 1) == 1) {
                    this.state = 308;
                    return true;
                }
                this.state = 307;
            }
            case 307: {
                if ((this.hr2x_counterFlags & 2) == 2) {
                    this.state = 311;
                    return true;
                }
                this.state = 310;
                return true;
            }
            case 308: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 309;
            }
            case 309: {
                this.hr2x_counterConfiguration.concurrencyLevel(this.hr2x_vInt);
                this.state = 307;
                return true;
            }
            case 310: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_initialValue = this.hr2x_long;
                this.hr2x_counterConfiguration = this.hr2x_counterConfiguration.initialValue(this.hr2x_initialValue);
                this.state = 304;
                return true;
            }
            case 311: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lowerBound = this.hr2x_long;
                this.state = 312;
            }
            case 312: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_upperBound = this.hr2x_long;
                this.state = 313;
            }
            case 313: {
                this.hr2x_counterConfiguration.lowerBound(this.hr2x_lowerBound).upperBound(this.hr2x_upperBound);
                this.state = 310;
                return true;
            }
            case 314: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 315;
            }
            case 315: {
                this.counterProcessor.getCounterConfiguration(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 316: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 317;
            }
            case 317: {
                this.counterProcessor.isCounterDefined(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 318: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 319;
            }
            case 319: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_updateValue = this.hr2x_long;
                this.state = 320;
            }
        }
        return true;
    }

    private boolean switch5(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 320: {
                this.counterProcessor.counterAddAndGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_updateValue);
                this.state = 0;
                return true;
            }
            case 321: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 322;
            }
            case 322: {
                this.counterProcessor.counterReset(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 323: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 324;
            }
            case 324: {
                this.counterProcessor.counterGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 325: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 326;
            }
            case 326: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_expectValue = this.hr2x_long;
                this.state = 327;
            }
            case 327: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_updateValue = this.hr2x_long;
                this.state = 328;
            }
            case 328: {
                this.counterProcessor.counterCompareAndSwap(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_expectValue, this.hr2x_updateValue);
                this.state = 0;
                return true;
            }
            case 329: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 330;
            }
            case 330: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 331;
            }
            case 331: {
                this.counterProcessor.addCounterListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 332: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 333;
            }
            case 333: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 334;
            }
            case 334: {
                this.counterProcessor.removeCounterListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 335: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 336;
            }
            case 336: {
                this.counterProcessor.counterRemove(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 337: {
                this.counterProcessor.getCounterNames(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 338: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 339;
            }
            case 339: {
                this.multimapProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 340: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 341;
            }
            case 341: {
                this.multimapProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 342: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 343;
            }
            case 343: {
                if (this.hr2x_version < 22) {
                    this.state = 345;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 347;
                return true;
            }
            case 344: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 351;
                return true;
            }
            case 345: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 346;
            }
            case 346: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 344;
                return true;
            }
            case 347: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 349;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 348;
            }
            case 348: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 350;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 344;
                return true;
            }
            case 349: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 348;
                return true;
            }
            case 350: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 344;
                return true;
            }
            case 351: {
                this.multimapProcessor.put(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value);
                this.state = 0;
                return true;
            }
            case 352: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 353;
            }
            case 353: {
                this.multimapProcessor.removeKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 354: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 355;
            }
            case 355: {
                if (this.hr2x_version < 22) {
                    this.state = 357;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 359;
                return true;
            }
            case 356: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 363;
                return true;
            }
            case 357: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 358;
            }
            case 358: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 356;
                return true;
            }
            case 359: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 361;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 360;
            }
            case 360: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 362;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 356;
                return true;
            }
            case 361: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 360;
                return true;
            }
            case 362: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 356;
                return true;
            }
            case 363: {
                this.multimapProcessor.removeEntry(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value);
                this.state = 0;
                return true;
            }
            case 364: {
                this.multimapProcessor.size(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 365: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 366;
            }
            case 366: {
                if (this.hr2x_version < 22) {
                    this.state = 368;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 370;
                return true;
            }
            case 367: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 374;
                return true;
            }
            case 368: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 369;
            }
            case 369: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 367;
                return true;
            }
            case 370: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 372;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 371;
            }
            case 371: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 373;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 367;
                return true;
            }
            case 372: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 371;
                return true;
            }
            case 373: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 367;
                return true;
            }
            case 374: {
                this.multimapProcessor.containsEntry(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value);
                this.state = 0;
                return true;
            }
            case 375: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 376;
            }
            case 376: {
                this.multimapProcessor.containsKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 377: {
                if (this.hr2x_version < 22) {
                    this.state = 379;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 381;
                return true;
            }
            case 378: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 385;
                return true;
            }
            case 379: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 380;
            }
            case 380: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 378;
                return true;
            }
            case 381: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 383;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 382;
            }
            case 382: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 384;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 378;
                return true;
            }
            case 383: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 382;
                return true;
            }
        }
        return true;
    }

    private boolean switch6(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 384: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_header, this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 378;
                return true;
            }
            case 385: {
                this.multimapProcessor.containsValue(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_value);
                this.state = 0;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        if (!this.deadEnd) {
            this.cacheProcessor.writeException(this.getHeader(), (Throwable)((Object)new RequestParsingException("Invalid state of parsing", this.hr2x_version, this.hr2x_messageId)));
            this.deadEnd = true;
        }
        this.state = 0;
    }

    private void exceptionally(Throwable t) throws Exception {
        log.trace("Parsing error", t);
        this.cacheProcessor.writeException(this.getHeader(), t);
        this.state = 0;
    }

    private void reset() {
        this.requestBytes = 0;
        this.hr2x_timeUnits = 0;
        this.hr2x_numEntries = 0;
        this.hr2x_iterationId = null;
        this.hr2x_controlByte = 0;
        this.hr2x_fixedArray = null;
        this.hr2x_queryBytes = null;
        this.hr2x_counterFlags = 0;
        this.hr2x_expectValue = 0L;
        this.hr2x_readable = null;
        this.hr2x_includeCurrentState = false;
        this.hr2x_taskParam = null;
        this.hr2x_cacheName = null;
        this.hr2x_vInt = 0;
        this.hr2x_valueType = null;
        this.hr2x_initialValue = 0L;
        this.hr2x_numModifications = 0;
        this.hr2x_param = null;
        this.hr2x_authMech = null;
        this.hr2x_authResponse = null;
        this.hr2x_listenerInterests = 0;
        this.hr2x_numParams = 0;
        this.hr2x_xidFormat = 0;
        this.hr2x_filterFactory = null;
        this.hr2x_maxIdleLong = 0L;
        this.hr2x_operation = null;
        this.hr2x_upperBound = 0L;
        this.hr2x_version = 0;
        this.hr2x_converterFactory = null;
        this.hr2x_signedVInt = 0;
        this.hr2x_keyType = null;
        this.hr2x_filterConverterFactory = null;
        this.hr2x_mediaTypeParams = null;
        this.hr2x_versionRead = 0L;
        this.hr2x_lifespanInt = 0;
        this.hr2x_mediaParamValue = null;
        this.hr2x_intelligence = 0;
        this.hr2x_long = 0L;
        this.hr2x_mediaParamName = null;
        this.hr2x_converterParams = null;
        this.hr2x_recoverable = false;
        this.hr2x_value = null;
        this.hr2x_branchLength = 0;
        this.hr2x_optionalString = null;
        this.hr2x_optionalArray = null;
        this.hr2x_bool = false;
        this.hr2x_xidLength = 0;
        this.hr2x_mediaTypeDefinition = 0;
        this.hr2x_expiration = null;
        this.hr2x_filterParams = null;
        this.hr2x_offset = 0;
        this.hr2x_chunkBytes = null;
        this.hr2x_updateValue = 0L;
        this.hr2x_txMarker = 0;
        this.hr2x_useRawEvents = false;
        this.hr2x_chunkLength = 0;
        this.hr2x_timeout = 0L;
        this.hr2x_taskName = null;
        this.hr2x_mediaTypeName = null;
        this.hr2x_lowerBound = 0L;
        this.hr2x_taskParamValue = null;
        this.hr2x_chunkedValue = null;
        this.hr2x_key = null;
        this.hr2x_batchSize = 0;
        this.hr2x_header = null;
        this.hr2x_scope = 0;
        this.hr2x_lifespanLong = 0L;
        this.hr2x_taskParams = null;
        this.hr2x_array = null;
        this.hr2x_flags = 0;
        this.hr2x_listenerId = null;
        this.hr2x_segmentMask = null;
        this.hr2x_magic = 0;
        this.hr2x_maxIdleInt = 0;
        this.hr2x_onePhaseCommit = false;
        this.hr2x_entryVersion = 0L;
        this.hr2x_mediaTypeId = 0;
        this.hr2x_includeMetadata = false;
        this.hr2x_opCode = 0;
        this.hr2x_entryMap = null;
        this.hr2x_mediaTypeParamsNum = 0;
        this.hr2x_messageId = 0L;
        this.hr2x_vLong = 0L;
        this.hr2x_filterConverterParams = null;
        this.hr2x_numKeys = 0;
        this.hr2x_mediaType = null;
        this.hr2x_branchId = null;
        this.hr2x_string = null;
        this.hr2x_byte = 0;
        this.hr2x_transactionId = null;
        this.hr2x_mediaTypeDescription = null;
        this.hr2x_counterName = null;
        this.hr2x_modification = null;
        this.hr2x_counterConfiguration = null;
        this.hr2x_topologyId = 0;
        this.hr2x_keys = null;
        this.hr2x_xid = null;
        this.hr2x_modifications = null;
    }

    public int requestBytes() {
        return this.requestBytes;
    }

    private boolean userSwitch55() throws Exception {
        switch (this.hr2x_opCode) {
            case 1: {
                this.state = 56;
                return true;
            }
            case 3: {
                this.state = 66;
                return true;
            }
            case 5: {
                this.state = 68;
                return true;
            }
            case 7: {
                this.state = 78;
                return true;
            }
            case 9: {
                this.state = 88;
                return true;
            }
            case 11: {
                this.state = 99;
                return true;
            }
            case 13: {
                this.state = 101;
                return true;
            }
            case 15: {
                this.state = 104;
                return true;
            }
            case 17: {
                this.state = 106;
                return true;
            }
            case 19: {
                this.state = 108;
                return true;
            }
            case 21: {
                this.state = 109;
                return true;
            }
            case 23: {
                this.state = 110;
                return true;
            }
            case 25: {
                this.state = 111;
                return true;
            }
            case 27: {
                this.state = 113;
                return true;
            }
            case 29: {
                this.state = 115;
                return true;
            }
            case 31: {
                this.state = 117;
                return true;
            }
            case 33: {
                this.state = 119;
                return true;
            }
            case 35: {
                this.state = 120;
                return true;
            }
            case 37: {
                this.state = 123;
                return true;
            }
            case 39: {
                this.state = 157;
                return true;
            }
            case 41: {
                this.state = 159;
                return true;
            }
            case 43: {
                this.state = 160;
                return true;
            }
            case 45: {
                this.state = 168;
                return true;
            }
            case 47: {
                this.state = 182;
                return true;
            }
            case 49: {
                this.state = 188;
                return true;
            }
            case 51: {
                this.state = 200;
                return true;
            }
            case 53: {
                this.state = 202;
                return true;
            }
            case 55: {
                this.state = 204;
                return true;
            }
            case 57: {
                this.state = 207;
                return true;
            }
            case 59: {
                this.state = 223;
                return true;
            }
            case 61: {
                this.state = 249;
                return true;
            }
            case 63: {
                this.state = 257;
                return true;
            }
            case 121: {
                this.state = 265;
                return true;
            }
            case 123: {
                this.state = 273;
                return true;
            }
            case 125: {
                this.state = 274;
                return true;
            }
            case 75: {
                this.state = 302;
                return true;
            }
            case 77: {
                this.state = 314;
                return true;
            }
            case 79: {
                this.state = 316;
                return true;
            }
            case 82: {
                this.state = 318;
                return true;
            }
            case 84: {
                this.state = 321;
                return true;
            }
            case 86: {
                this.state = 323;
                return true;
            }
            case 88: {
                this.state = 325;
                return true;
            }
            case 90: {
                this.state = 329;
                return true;
            }
            case 92: {
                this.state = 332;
                return true;
            }
            case 94: {
                this.state = 335;
                return true;
            }
            case 100: {
                this.state = 337;
                return true;
            }
            case 103: {
                this.state = 338;
                return true;
            }
            case 105: {
                this.state = 340;
                return true;
            }
            case 107: {
                this.state = 342;
                return true;
            }
            case 109: {
                this.state = 352;
                return true;
            }
            case 111: {
                this.state = 354;
                return true;
            }
            case 113: {
                this.state = 364;
                return true;
            }
            case 115: {
                this.state = 365;
                return true;
            }
            case 117: {
                this.state = 375;
                return true;
            }
            case 119: {
                this.state = 377;
                return true;
            }
        }
        throw new HotRodUnknownOperationException("Unknown operation " + this.hr2x_opCode, this.hr2x_version, this.hr2x_messageId);
    }
}

