/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.counter.CounterManagerTestStrategy;
import org.infinispan.server.hotrod.counter.impl.CounterManagerImplTestStrategy;
import org.infinispan.server.hotrod.counter.impl.TestCounterManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.counter.CounterManagerOperationTest")
public class CounterManagerOperationTest
extends HotRodMultiNodeTest
implements CounterManagerTestStrategy {
    private static final String PERSISTENT_LOCATION = TestingUtil.tmpDirectory((String)"CounterManagerOperationTest");
    private static final String TMP_LOCATION = PERSISTENT_LOCATION + File.separator + "tmp";
    private static final String SHARED_LOCATION = PERSISTENT_LOCATION + File.separator + "shared";
    private final CounterManagerTestStrategy strategy = new CounterManagerImplTestStrategy(this::allTestCounterManagers, this::log, this::cacheManager);

    @Override
    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
        if (!new File(PERSISTENT_LOCATION).mkdirs()) {
            this.log.warnf("Unable to create persistent location file: '%s'", (Object)PERSISTENT_LOCATION);
        }
        super.createBeforeClass();
    }

    @Override
    public void testWeakCounter(Method method) {
        this.strategy.testWeakCounter(method);
    }

    @Override
    public void testUnboundedStrongCounter(Method method) {
        this.strategy.testUnboundedStrongCounter(method);
    }

    @Override
    public void testUpperBoundedStrongCounter(Method method) {
        this.strategy.testUpperBoundedStrongCounter(method);
    }

    @Override
    public void testLowerBoundedStrongCounter(Method method) {
        this.strategy.testLowerBoundedStrongCounter(method);
    }

    @Override
    public void testBoundedStrongCounter(Method method) {
        this.strategy.testBoundedStrongCounter(method);
    }

    @Override
    public void testUndefinedCounter() {
        this.strategy.testUndefinedCounter();
    }

    @Override
    public void testRemove(Method method) {
        this.strategy.testRemove(method);
    }

    @Override
    public void testGetCounterNames(Method method) {
        this.strategy.testGetCounterNames(method);
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        super.destroy();
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
    }

    @Override
    protected void createCacheManagers() {
        for (int i = 0; i < this.nodeCount(); ++i) {
            char id = 'A';
            id = (char)(id + i);
            GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder().clusteredDefault();
            builder.globalState().enable().persistentLocation(PERSISTENT_LOCATION + File.separator + id).temporaryLocation(TMP_LOCATION).sharedPersistentLocation(SHARED_LOCATION);
            EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)builder, (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
            this.cacheManagers.add(cm);
        }
        this.waitForClusterToForm("org.infinispan.COUNTER");
    }

    @Override
    protected String cacheName() {
        return "unused-cache";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        return new ConfigurationBuilder();
    }

    @Override
    protected byte protocolVersion() {
        return HotRodVersion.HOTROD_27.getVersion();
    }

    private Log log() {
        return this.log;
    }

    private List<CounterManager> allTestCounterManagers() {
        return this.clients().stream().map(TestCounterManager::new).collect(Collectors.toList());
    }

    private EmbeddedCacheManager cacheManager() {
        return this.manager(0);
    }
}

